/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.svpol;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class ResourceGroupInformation
extends SmfData {
    public static final int SVPOLMXS = 128;
    public static final int SVPOLMNS = 64;
    public static final int SVPOLGSD = 32;
    public static final int SVPOLGPV = 16;
    public static final int SVPOLGPC = 8;
    public static final int SVPOLMLS = 4;
    public static final int SVPOLISP = 2;
    public static final int SVPOLGMS = 1;
    public static final int SVPOLTRG = 128;
    public static final int SVPOLTRG_HWCONTAINER = 64;

    private ResourceGroupInformation(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String svpolgnm() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String svpolgde() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public long svpolgmn() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long svpolgmx() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long svpolglt() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public boolean svpolmxs() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 128, Field.svpolglt.length, 0);
    }

    public boolean svpolmns() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 64, Field.svpolglt.length, 0);
    }

    public boolean svpolgsd() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 32, Field.svpolglt.length, 0);
    }

    public boolean svpolgpv() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 16, Field.svpolglt.length, 0);
    }

    public boolean svpolgpc() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 8, Field.svpolglt.length, 0);
    }

    public boolean svpolmls() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 4, Field.svpolglt.length, 0);
    }

    public boolean svpolisp() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 2, Field.svpolglt.length, 0);
    }

    public boolean svpolgms() {
        return Util.ConvertFlag(this.data, this.svpolglt(), 1, Field.svpolglt.length, 0);
    }

    public long svpolMemoryLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long svpolgl1() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public boolean svpoltrg() {
        return Util.ConvertFlag(this.data, this.svpolgl1(), 128, Field.svpolgl1.length, 0);
    }

    public boolean svpolTrgHwContainer() {
        return Util.ConvertFlag(this.data, this.svpolgl1(), 64, Field.svpolgl1.length, 0);
    }

    public String svpolTenantId() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public String svpolTenantName() {
        return Util.ConvertEbcdic(this.data, 72, 32);
    }

    public String svpolTrgSolutionId() {
        return Util.ConvertEbcdic(this.data, 104, 64);
    }

    public static ResourceGroupInformation create(byte[] Data2, int offset, int length) {
        return new ResourceGroupInformation(Data2, offset, length);
    }

    static enum Field {
        svpolgnm(0, 8),
        svpolgde(8, 32),
        svpolgmn(40, 4),
        svpolgmx(44, 4),
        svpolglt(48, 4),
        svpolMemoryLimit(52, 4),
        svpolgl1(56, 4),
        svpolTenantId(64, 8),
        svpolTenantName(72, 32),
        svpolTrgSolutionId(104, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

