/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.zutil.io;

import com.blackhillsoftware.zutil.io.TextRecordReader;
import com.blackhillsoftware.zutil.io.TextRecordWriter;
import com.ibm.jzos.ZFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RunTests {
    public static void main(String[] args) throws IOException {
        List<String> inputData = Arrays.asList("0123456789", "start", "padded    ", "  middle  ", "       end", "empty next", "", "two empty:", "", "", "last line");
        List<String> resultfb10 = Arrays.asList("0123456789", "start     ", "padded    ", "  middle  ", "       end", "empty next", "          ", "two empty:", "          ", "          ", "last line ");
        List<String> resu1tfb3 = Arrays.asList("012", "345", "678", "9  ", "sta", "rt ", "pad", "ded", "   ", "   ", "  m", "idd", "le ", "   ", "   ", "   ", " en", "d  ", "emp", "ty ", "nex", "t  ", "   ", "two", " em", "pty", ":  ", "   ", "   ", "las", "t l", "ine");
        List<String> resu1tvb7 = Arrays.asList("012", "345", "678", "9", "sta", "rt", "pad", "ded", "   ", " ", "  m", "idd", "le ", " ", "   ", "   ", " en", "d", "emp", "ty ", "nex", "t", "", "two", " em", "pty", ":", "", "", "las", "t l", "ine");
        System.out.format("Test1: ", new Object[0]);
        System.out.format("%s%n", RunTests.runTest(inputData, resultfb10, "fb", 10, false));
        System.out.format("Test2: ", new Object[0]);
        System.out.format("%s%n", RunTests.runTest(inputData, inputData, "vb", 14, false));
        StringBuilder sb = new StringBuilder(inputData.get(0));
        for (int i = 1; i < inputData.size(); ++i) {
            sb.append(System.lineSeparator());
            sb.append(inputData.get(i));
        }
        System.out.format("Test3: ", new Object[0]);
        System.out.format("%s%n", RunTests.runTest(Collections.singletonList(sb.toString()), resultfb10, "fb", 10, false));
        System.out.format("Test4: ", new Object[0]);
        System.out.format("%s%n", RunTests.runTest(Collections.singletonList(sb.toString()), inputData, "vb", 14, false));
        System.out.format("Test5: ", new Object[0]);
        System.out.format("%s%n", RunTests.runTest(inputData, resu1tfb3, "fb", 3, true));
        System.out.format("Test6: ", new Object[0]);
        System.out.format("%s%n", RunTests.runTest(inputData, resu1tvb7, "vb", 7, true));
        try {
            System.out.format("Test7: ", new Object[0]);
            RunTests.runTest(inputData, resu1tfb3, "fb", 3, false);
            System.out.println("Fail: did not throw expected exception");
        }
        catch (IllegalArgumentException e) {
            System.out.format("Pass: Caught expected exception %s : %s%n", e.getClass().getSimpleName(), e.getMessage());
        }
        try {
            System.out.format("Test8: ", new Object[0]);
            RunTests.runTest(inputData, resu1tvb7, "vb", 7, false);
            System.out.println("Fail: did not throw expected exception");
        }
        catch (IllegalArgumentException e) {
            System.out.format("Pass: Caught expected exception %s : %s%n", e.getClass().getSimpleName(), e.getMessage());
        }
    }

    private static String runTest(List<String> data, List<String> expected, String recfm, int lrecl, boolean wrap) throws IOException {
        String FAIL = "Fail";
        String PASS = "Pass";
        String ddname = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)String.format("alloc fi(%s) new delete recfm(%s) lrecl(%d) blksize(%d) space(1) tracks reuse", ddname, recfm, lrecl, lrecl * 100));
        try (TextRecordWriter writer = TextRecordWriter.newWriterForDD(ddname).setWrapLines(wrap);){
            for (String line : data) {
                writer.writeLine(line);
            }
        }
        try (TextRecordReader reader = TextRecordReader.newReaderForDD(ddname);){
            List<String> result = reader.readAllLines();
            if (result.size() != expected.size()) {
                System.out.format("Wrong number of lines, expected %d but was %d%n", expected.size(), result.size());
                System.out.format("%s : %s%n", "Expected", "Result");
                for (int i = 0; i < Math.max(result.size(), expected.size()); ++i) {
                    System.out.format("\"%s\" : \"%s\"%n", i < expected.size() ? expected.get(i) : null, i < result.size() ? result.get(i) : null);
                }
                String i = FAIL;
                return i;
            }
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i).equals(expected.get(i))) continue;
                System.out.format("Line mismatch, expected \"%s\" but was \"%s\"%n", expected.get(i), result.get(i));
                String string = FAIL;
                return string;
            }
        }
        ZFile.bpxwdyn((String)("free fi(" + ddname + ")"));
        return PASS;
    }
}

