/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.fields.daa.BinaryUnsignedIntL2Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InMemoryResource {
    private static BinaryUnsignedIntL2Field nameLengthField = new BinaryUnsignedIntL2Field(Field.access$000(Field.namelength));
    static final int QRPBX_INMEMRESOURCE_EXT_LEN = 288;
    private String name;
    private String filename = null;
    private List<Integer> smfTypes = Collections.emptyList();

    static InMemoryResource create(byte[] Data, int offset, int length) {
        return new InMemoryResource(Data, offset, length);
    }

    static InMemoryResource create(String name, String filename) {
        return new InMemoryResource(name, filename);
    }

    private InMemoryResource(String name, String filename) {
        this.name = name;
        this.filename = filename;
    }

    private InMemoryResource(byte[] Data, int offset, int length) {
        if (offset + length > Data.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Section is outside the bounds of the data. Offset: 0x%X (%d)  Length: 0x%X (%d) Data Length: 0x%X (%d)%n", offset, offset, length, length, Data.length, Data.length));
        }
        int len = nameLengthField.getInt(Data, offset);
        this.name = ByteUtil.bytesAsString((byte[])Data, (int)(offset + 2), (int)len, (String)"Cp1047");
        this.smfTypes = new ArrayList<Integer>();
        for (int i = 0; i < 256; ++i) {
            int entry = Data[offset + Field.smftypes.offset + i];
            for (int j = 0; j < 8; ++j) {
                if ((entry & 0x80) == 128) {
                    this.getSmfTypes().add(i * 8 + j);
                }
                entry <<= 1;
            }
        }
    }

    public String name() {
        return this.name;
    }

    public boolean isSimulated() {
        return this.filename != null;
    }

    public String file() {
        return this.filename;
    }

    public List<Integer> getSmfTypes() {
        return this.smfTypes;
    }

    static enum Field {
        namelength(0, 2),
        name(2, 0),
        smftypes(32, 256);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

