/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

class RcReason
extends Exception {
    private static final long serialVersionUID = 4569430326372223122L;
    private int rc;
    private int reason;

    public RcReason(int rc, int reason) {
        this.rc = rc;
        this.reason = reason;
    }

    public int getRc() {
        return this.rc;
    }

    public int getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        String sRc = "";
        String sReason = "";
        block0 : switch (this.rc) {
            case 0: {
                sRc = "Success";
                break;
            }
            case 4: {
                sRc = "Warning";
                switch (this.reason) {
                    case 1025: {
                        sReason = "Missed data";
                        break block0;
                    }
                    case 1026: {
                        sReason = "No more data - resource removed";
                        break block0;
                    }
                    case 1027: {
                        sReason = "No more data - temporary";
                        break block0;
                    }
                    case 1028: {
                        sReason = "Another get in progress";
                        break block0;
                    }
                    case 1029: {
                        sReason = "Get in progress";
                        break block0;
                    }
                    case 1030: {
                        sReason = "Disconnect in progress";
                        break block0;
                    }
                    case 1031: {
                        sReason = "Disconnect in progress";
                        break block0;
                    }
                    case 1032: {
                        sReason = "Disconnected while get in progress";
                        break block0;
                    }
                }
                sReason = "Unrecognized";
                break;
            }
            case 8: {
                sRc = "Error";
                switch (this.reason) {
                    case 2049: {
                        sReason = "Bad mode";
                        break block0;
                    }
                    case 2050: {
                        sReason = "Bad parm list";
                        break block0;
                    }
                    case 2051: {
                        sReason = "No connections";
                        break block0;
                    }
                    case 2052: {
                        sReason = "Bad token";
                        break block0;
                    }
                    case 2053: {
                        sReason = "Unsupported options in parm list";
                        break block0;
                    }
                    case 2054: {
                        sReason = "Not enough space in output buffer";
                        break block0;
                    }
                    case 2055: {
                        sReason = "No such resource or insufficient authority";
                        break block0;
                    }
                    case 2056: {
                        sReason = "Not enough query space";
                        break block0;
                    }
                }
                sReason = "Unrecognized";
                break;
            }
            case 12: {
                sRc = "Env Error";
                switch (this.reason) {
                    case 3074: {
                        sReason = "SMF Not active";
                        break block0;
                    }
                    case 3075: {
                        sReason = "Unable to obtain storage";
                        break block0;
                    }
                }
                sReason = "Unrecognized";
                break;
            }
            case 16: {
                sRc = "Fatal Error";
                break;
            }
            default: {
                sRc = "Unrecognized";
            }
        }
        return String.format("Return code: 0x%02X %s, Reason: 0x%04X %s", this.rc, sRc, this.reason, sReason);
    }
}

