/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.blackhillsoftware.smf.realtime.SmfConnection;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SmfConnectionIterator
implements Iterator<byte[]> {
    private SmfConnection source;
    private final ThreadLocal<byte[]> next = new ThreadLocal();

    SmfConnectionIterator(SmfConnection source) {
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        if (this.next.get() == null) {
            try {
                this.next.set(this.source.read());
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
        return this.next.get() != null;
    }

    @Override
    public byte[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        byte[] result = this.next.get();
        this.next.set(null);
        return result;
    }
}

