/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.realtime;

import com.blackhillsoftware.smf.realtime.MissedDataException;
import com.blackhillsoftware.smf.realtime.SmfConnection;
import com.blackhillsoftware.zutil.mvs.CommandHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Queue;

class SmfSimulatedConnection
extends SmfConnection {
    private String filename;
    private InputStream instream;
    private volatile boolean connected = false;
    int nextCount = 1;

    SmfSimulatedConnection(String name) {
        super(name);
        String environmentVariable = name.replace(".", "_");
        this.filename = System.getenv(environmentVariable);
        if (this.filename == null) {
            throw new IllegalStateException("Running in simulation mode but resource name environment variable not set: " + environmentVariable);
        }
        this.filename = this.filename.trim();
        if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
            this.filename = this.filename.substring(1, this.filename.length() - 1);
        } else if (this.filename.startsWith("'") && this.filename.endsWith("'")) {
            this.filename = this.filename.substring(1, this.filename.length() - 1);
        }
    }

    @Override
    synchronized SmfConnection connect() throws IOException {
        this.instream = new BufferedInputStream(new FileInputStream(this.filename));
        this.connected = true;
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.instream != null) {
                this.instream.close();
            }
        }
        finally {
            this.connected = false;
        }
    }

    @Override
    protected synchronized void readRecords(Queue<byte[]> inner) throws IOException, MissedDataException {
        byte[] record;
        if (!this.connected) {
            return;
        }
        int count = 0;
        int target = this.nextCount;
        this.nextCount *= 2;
        if (this.nextCount > 200) {
            this.nextCount = 1;
        }
        while ((record = this.readRecord()) != null) {
            inner.add(record);
            if (++count < target) continue;
            return;
        }
    }

    private byte[] readRecord() throws IOException {
        byte[] work = new byte[32768];
        int read = this.instream.read(work, 0, 4);
        if (read > 0 && read != 4) {
            throw new IOException(String.format("Error reading RDW, read only %d bytes", read));
        }
        if (read <= 0) {
            return null;
        }
        int length = ((work[0] & 0xFF) << 8) + (work[1] & 0xFF);
        if (length > 32768) {
            throw new IOException(String.format("Invalid record length: %d", length));
        }
        int sdw = ((work[2] & 0xFF) << 8) + (work[3] & 0xFF);
        if (sdw != 0) {
            throw new IOException(String.format("Invalid segment bytes: %04X", sdw));
        }
        read = this.instream.read(work, 4, length - 4);
        if (read != length - 4) {
            throw new IOException(String.format("Tried to read %d bytes, received only %d", length - 4, read));
        }
        work[0] = (byte)(length >> 8);
        work[1] = (byte)(length & 0xFF);
        return Arrays.copyOfRange(work, 0, length);
    }

    @Override
    protected boolean handleStop() {
        try {
            CommandHandler.removeStop((CommandHandler)this.stopHandler);
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

