/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.values.EAttr;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.dataset.Dsorg;
import com.blackhillsoftware.smf.dataset.Recfm;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class ActiveDataset
extends DcollectRecord {
    public static final int DCDEMNGD = 128;
    public static final int DCDEDVVR = 64;
    public static final int DCDNOSPC = 32;
    public static final int DCDVSAMI = 16;
    public static final int DCDNOFM1 = 8;
    public static final int DCDRACFD = 128;
    public static final int DCDSMSM = 64;
    public static final int DCDTEMP = 32;
    public static final int DCDPDSE = 16;
    public static final int DCDGDS = 8;
    public static final int DCDREBLK = 4;
    public static final int DCDCHIND = 2;
    public static final int DCDCKDSI = 1;
    public static final int DCDNOVVR = 128;
    public static final int DCDINTCG = 64;
    public static final int DCDINICF = 32;
    public static final int DCDALLFG = 8;
    public static final int DCDUSEFG = 4;
    public static final int DCDSECFG = 2;
    public static final int DCDNMBFG = 1;
    public static final int DCDPDSEX = 128;
    public static final int DCDSTRP = 64;
    public static final int DCDDDMEX = 32;
    public static final int DCDCPOIT = 16;
    public static final int DCDGT64K = 8;
    public static final int DCDCMPTV = 4;
    public static final int DCDDSGIS = 128;
    public static final int DCDDSGPS = 64;
    public static final int DCDDSGDA = 32;
    public static final int DCDDSGPO = 2;
    public static final int DCDDSGU = 1;
    public static final int DCDDSGGS = 128;
    public static final int DCDDSGVS = 8;
    public static final int DCDRECFT = 32;
    public static final int DCDRECFB = 16;
    public static final int DCDRECFS = 8;
    public static final int DCDRECFA = 4;
    public static final int DCDRECFC = 2;
    public static final int DCDBDSZ = 128;
    public static final int DCDALLFX = 128;
    public static final int DCDUSEFX = 64;
    public static final int DCDSCAFX = 32;
    public static final int DCDNMBFX = 16;
    public static final int DCDDS9CR = 128;
    public static final int DCDCNCMP = 0;
    public static final int DCDCGENC = 1;
    public static final int DCDCTLRD = 2;
    public static final int DCDCZEDC = 3;

    ActiveDataset(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.D)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    ActiveDataset(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.D)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static ActiveDataset from(VRecord record) {
        return new ActiveDataset(record);
    }

    public String dcddsnam() {
        return Util.ConvertEbcdic(this.data, 24, 44);
    }

    public int dcderror() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public boolean dcdemngd() {
        return Util.ConvertFlag(this.data, this.dcderror(), 128);
    }

    public boolean dcdedvvr() {
        return Util.ConvertFlag(this.data, this.dcderror(), 64);
    }

    public boolean dcdnospc() {
        return Util.ConvertFlag(this.data, this.dcderror(), 32);
    }

    public boolean dcdvsami() {
        return Util.ConvertFlag(this.data, this.dcderror(), 16);
    }

    public boolean dcdnofm1() {
        return Util.ConvertFlag(this.data, this.dcderror(), 8);
    }

    public int dcdflag1() {
        return Util.ConvertUnsignedBinary1(this.data, 69);
    }

    public boolean dcdracfd() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 128);
    }

    public boolean dcdsmsm() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 64);
    }

    public boolean dcdtemp() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 32);
    }

    public boolean dcdpdse() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 16);
    }

    public boolean dcdgds() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 8);
    }

    public boolean dcdreblk() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 4);
    }

    public boolean dcdchind() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 2);
    }

    public boolean dcdckdsi() {
        return Util.ConvertFlag(this.data, this.dcdflag1(), 1);
    }

    public int dcdflag2() {
        return Util.ConvertUnsignedBinary1(this.data, 70);
    }

    public boolean dcdnovvr() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 128);
    }

    public boolean dcdintcg() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 64);
    }

    public boolean dcdinicf() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 32);
    }

    public boolean dcdallfg() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 8);
    }

    public boolean dcdusefg() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 4);
    }

    public boolean dcdsecfg() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 2);
    }

    public boolean dcdnmbfg() {
        return Util.ConvertFlag(this.data, this.dcdflag2(), 1);
    }

    public int dcdflag3() {
        return Util.ConvertUnsignedBinary1(this.data, 71);
    }

    public boolean dcdpdsex() {
        return Util.ConvertFlag(this.data, this.dcdflag3(), 128);
    }

    public boolean dcdstrp() {
        return Util.ConvertFlag(this.data, this.dcdflag3(), 64);
    }

    public boolean dcdddmex() {
        return Util.ConvertFlag(this.data, this.dcdflag3(), 32);
    }

    public boolean dcdcpoit() {
        return Util.ConvertFlag(this.data, this.dcdflag3(), 16);
    }

    public boolean dcdgt64k() {
        return Util.ConvertFlag(this.data, this.dcdflag3(), 8);
    }

    public boolean dcdcmptv() {
        return Util.ConvertFlag(this.data, this.dcdflag3(), 4);
    }

    public Dsorg dcddsorg() {
        return Dsorg.fromDsorgBytes(this.dcddsorgRawValue());
    }

    public int dcddsorgRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 74);
    }

    public int dcddsor0() {
        return Util.ConvertUnsignedBinary1(this.data, 74);
    }

    public boolean dcddsgis() {
        return Util.ConvertFlag(this.data, this.dcddsor0(), 128);
    }

    public boolean dcddsgps() {
        return Util.ConvertFlag(this.data, this.dcddsor0(), 64);
    }

    public boolean dcddsgda() {
        return Util.ConvertFlag(this.data, this.dcddsor0(), 32);
    }

    public boolean dcddsgpo() {
        return Util.ConvertFlag(this.data, this.dcddsor0(), 2);
    }

    public boolean dcddsgu() {
        return Util.ConvertFlag(this.data, this.dcddsor0(), 1);
    }

    public int dcddsor1() {
        return Util.ConvertUnsignedBinary1(this.data, 75);
    }

    public boolean dcddsggs() {
        return Util.ConvertFlag(this.data, this.dcddsor1(), 128);
    }

    public boolean dcddsgvs() {
        return Util.ConvertFlag(this.data, this.dcddsor1(), 8);
    }

    public Recfm dcdrecrd() {
        return Recfm.fromRecfmByte(this.dcdrecrdRawValue());
    }

    public int dcdrecrdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 76);
    }

    public int dcdrecfm() {
        return Util.ConvertUnsignedBinary1(this.data, 76, 192);
    }

    public boolean dcdrecft() {
        return Util.ConvertFlag(this.data, this.dcdrecrdRawValue(), 32);
    }

    public boolean dcdrecfb() {
        return Util.ConvertFlag(this.data, this.dcdrecrdRawValue(), 16);
    }

    public boolean dcdrecfs() {
        return Util.ConvertFlag(this.data, this.dcdrecrdRawValue(), 8);
    }

    public boolean dcdrecfa() {
        return Util.ConvertFlag(this.data, this.dcdrecrdRawValue(), 4);
    }

    public boolean dcdrecfc() {
        return Util.ConvertFlag(this.data, this.dcdrecrdRawValue(), 2);
    }

    public int dcdnmext() {
        return Util.ConvertUnsignedBinary1(this.data, 77);
    }

    public String dcdvolsr() {
        return Util.ConvertEbcdic(this.data, 78, 6);
    }

    public int dcdbklng() {
        return Util.ConvertSignedBinary2(this.data, 84);
    }

    public int dcdlrecl() {
        return Util.ConvertSignedBinary2(this.data, 86);
    }

    public int dcdallsp() {
        return Util.ConvertSignedBinary4(this.data, 88);
    }

    public double dcdallspMB() {
        return (double)Util.ConvertSignedBinary4(this.data, 88) / 1024.0;
    }

    public int dcdusesp() {
        return Util.ConvertSignedBinary4(this.data, 92);
    }

    public double dcdusespMB() {
        return (double)Util.ConvertSignedBinary4(this.data, 92) / 1024.0;
    }

    public int dcdscall() {
        return Util.ConvertSignedBinary4(this.data, 96);
    }

    public double dcdscallMB() {
        return (double)Util.ConvertSignedBinary4(this.data, 96) / 1024.0;
    }

    public int dcdnmblk() {
        return Util.ConvertSignedBinary4(this.data, 100);
    }

    public LocalDate dcdcredt() {
        return Util.Packed4YYYYDDD(this.data, 104);
    }

    public int dcdcredtRawValue() {
        return Util.ConvertPacked4(this.data, 104);
    }

    public LocalDate dcdexpdt() {
        return Util.Packed4YYYYDDD(this.data, 108);
    }

    public int dcdexpdtRawValue() {
        return Util.ConvertPacked4(this.data, 108);
    }

    public LocalDate dcdlstrf() {
        return Util.Packed4YYYYDDD(this.data, 112);
    }

    public int dcdlstrfRawValue() {
        return Util.ConvertPacked4(this.data, 112);
    }

    public String dcddsser() {
        return Util.ConvertEbcdic(this.data, 116, 6);
    }

    public int dcdvolsq() {
        return Util.ConvertUnsignedBinary2(this.data, 122);
    }

    public ZonedDateTime dcdlbkdt() {
        return Util.Binary8xStckTime(this.data, 124);
    }

    public BigInteger dcdlbkdtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 124);
    }

    private int dcddclng() {
        return Util.ConvertUnsignedBinary2(this.data, 132);
    }

    public String dcddclas() {
        if (this.data.length >= 134 + this.dcddclng()) {
            return Util.ConvertEbcdic(this.data, 134, this.dcddclng());
        }
        return null;
    }

    private int dcdsclng() {
        return Util.ConvertUnsignedBinary2(this.data, 164);
    }

    public String dcdsclas() {
        if (this.data.length >= 166 + this.dcdsclng()) {
            return Util.ConvertEbcdic(this.data, 166, this.dcdsclng());
        }
        return null;
    }

    private int dcdmclng() {
        return Util.ConvertUnsignedBinary2(this.data, 196);
    }

    public String dcdmclas() {
        if (this.data.length >= 198 + this.dcdmclng()) {
            return Util.ConvertEbcdic(this.data, 198, this.dcdmclng());
        }
        return null;
    }

    private int dcdsglng() {
        return Util.ConvertUnsignedBinary2(this.data, 228);
    }

    public String dcdstogp() {
        if (this.data.length >= 230 + this.dcdsglng()) {
            return Util.ConvertEbcdic(this.data, 230, this.dcdsglng());
        }
        return null;
    }

    public String dcdccsid() {
        return Util.ConvertEbcdic(this.data, 260, 2);
    }

    public int dcdcatf() {
        return Util.ConvertUnsignedBinary1(this.data, 262);
    }

    public EAttr dcdeatrc() {
        int value = Util.ConvertUnsignedBinary1(this.data, 262, 3);
        return EAttr.from(value);
    }

    public int dcdeatrcRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 262, 3);
    }

    public int dcddscbf() {
        return Util.ConvertUnsignedBinary1(this.data, 263);
    }

    public EAttr dcdeatrv() {
        int value = Util.ConvertUnsignedBinary1(this.data, 263, 3);
        return EAttr.from(value);
    }

    public int dcdeatrvRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 263, 3);
    }

    public long dcdudsiz() {
        return Util.ConvertUnsignedBinary8(this.data, 264);
    }

    public double dcdudsizMB() {
        return (double)this.dcdudsiz() / 1024.0 / 1024.0;
    }

    public BigInteger dcdudsizAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 264);
    }

    public long dcdcudsz() {
        return Util.ConvertUnsignedBinary8(this.data, 272);
    }

    public double dcdcudszMB() {
        return (double)this.dcdcudsz() / 1024.0 / 1024.0;
    }

    public BigInteger dcdcudszAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 272);
    }

    public int dcdexflg() {
        return Util.ConvertUnsignedBinary2(this.data, 280);
    }

    public boolean dcdbdsz() {
        return Util.ConvertFlag(this.data, this.dcdexflg(), 128, Field.dcdexflg.length, 0);
    }

    public int dcdscnt() {
        return Util.ConvertUnsignedBinary2(this.data, 282);
    }

    public long dcdovera() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public String dcdacct() {
        return Util.ConvertEbcdic(this.data, 288, 32);
    }

    public int dcdflag5() {
        return Util.ConvertUnsignedBinary1(this.data, 320);
    }

    public boolean dcdallfx() {
        return Util.ConvertFlag(this.data, this.dcdflag5(), 128);
    }

    public boolean dcdusefx() {
        return Util.ConvertFlag(this.data, this.dcdflag5(), 64);
    }

    public boolean dcdscafx() {
        return Util.ConvertFlag(this.data, this.dcdflag5(), 32);
    }

    public boolean dcdnmbfx() {
        return Util.ConvertFlag(this.data, this.dcdflag5(), 16);
    }

    public int dcdds9f1() {
        return Util.ConvertUnsignedBinary1(this.data, 327);
    }

    public boolean dcdds9cr() {
        return Util.ConvertFlag(this.data, this.dcdds9f1(), 128);
    }

    public String dcdjbnmc() {
        return Util.ConvertEbcdic(this.data, 328, 8);
    }

    public String dcdstnmc() {
        return Util.ConvertEbcdic(this.data, 336, 8);
    }

    public LocalTime dcdtimec() {
        return Util.Binary6UsSinceMidnight(this.data, 344);
    }

    public LocalDateTime creationDateTime() {
        return this.dcdcredt() != null ? this.dcdcredt().atTime(this.dcdtimec()) : null;
    }

    public long dcdtimecRawValue() {
        return Util.ConvertUnsignedBinary6(this.data, 344);
    }

    public long dcdallsx() {
        return Util.ConvertSignedBinary8(this.data, 352);
    }

    public double dcdallsxMB() {
        return (double)Util.ConvertSignedBinary8(this.data, 352) / 1024.0;
    }

    public long dcdusesx() {
        return Util.ConvertSignedBinary8(this.data, 360);
    }

    public double dcdusesxMB() {
        return (double)Util.ConvertSignedBinary8(this.data, 360) / 1024.0;
    }

    public long dcdscalx() {
        return Util.ConvertSignedBinary8(this.data, 368);
    }

    public double dcdscalxMB() {
        return (double)Util.ConvertSignedBinary8(this.data, 368) / 1024.0;
    }

    public long dcdnmblx() {
        return Util.ConvertSignedBinary8(this.data, 376);
    }

    public double dcdnmblxMB() {
        return (double)Util.ConvertSignedBinary8(this.data, 376) / 1024.0;
    }

    public int dcdxpsev() {
        return Util.ConvertUnsignedBinary1(this.data, 384);
    }

    public int dcdctype() {
        return Util.ConvertUnsignedBinary1(this.data, 385);
    }

    public boolean dcdcncmp() {
        return Util.ConvertEquateValue(this.data, this.dcdctype(), 0);
    }

    public boolean dcdcgenc() {
        return Util.ConvertEquateValue(this.data, this.dcdctype(), 1);
    }

    public boolean dcdctlrd() {
        return Util.ConvertEquateValue(this.data, this.dcdctype(), 2);
    }

    public boolean dcdczedc() {
        return Util.ConvertEquateValue(this.data, this.dcdctype(), 3);
    }

    public String dcdaencr() {
        return Util.ConvertEbcdic(this.data, 386, 66);
    }

    public int dcdatype() {
        return Util.ConvertUnsignedBinary2(this.data, 386);
    }

    public String dcdaklbl() {
        return Util.ConvertEbcdic(this.data, 388, 64);
    }

    static enum Field {
        dcddsnam(24, 44),
        dcderror(68, 1),
        dcdflag1(69, 1),
        dcdflag2(70, 1),
        dcdflag3(71, 1),
        dcddsorg(74, 2),
        dcddsor0(74, 1),
        dcddsor1(75, 1),
        dcdrecrd(76, 1),
        dcdrecfm(76, 1),
        dcdnmext(77, 1),
        dcdvolsr(78, 6),
        dcdbklng(84, 2),
        dcdlrecl(86, 2),
        dcdallsp(88, 4),
        dcdusesp(92, 4),
        dcdscall(96, 4),
        dcdnmblk(100, 4),
        dcdcredt(104, 4),
        dcdexpdt(108, 4),
        dcdlstrf(112, 4),
        dcddsser(116, 6),
        dcdvolsq(122, 2),
        dcdlbkdt(124, 8),
        dcddclng(132, 2),
        dcddatcl(134, 0),
        dcdsclng(164, 2),
        dcdstgcl(166, 0),
        dcdmclng(196, 2),
        dcdmgtcl(198, 0),
        dcdsglng(228, 2),
        dcdstgrp(230, 0),
        dcdccsid(260, 2),
        dcdcatf(262, 1),
        dcdeatrc(262, 1),
        dcddscbf(263, 1),
        dcdeatrv(263, 1),
        dcdudsiz(264, 8),
        dcdcudsz(272, 8),
        dcdexflg(280, 2),
        dcdscnt(282, 2),
        dcdovera(284, 4),
        dcdacct(288, 32),
        dcdflag5(320, 1),
        dcdds9f1(327, 1),
        dcdjbnmc(328, 8),
        dcdstnmc(336, 8),
        dcdtimec(344, 6),
        dcdallsx(352, 8),
        dcdusesx(360, 8),
        dcdscalx(368, 8),
        dcdnmblx(376, 8),
        dcdxpsev(384, 1),
        dcdctype(385, 1),
        dcdaencr(386, 66),
        dcdatype(386, 2),
        dcdaklbl(388, 64);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

