/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.ActiveDataset;
import com.blackhillsoftware.dcollect.AggregateGroup;
import com.blackhillsoftware.dcollect.BackupDataset;
import com.blackhillsoftware.dcollect.BaseConfiguration;
import com.blackhillsoftware.dcollect.CacheNames;
import com.blackhillsoftware.dcollect.DasdCapacityPlanning;
import com.blackhillsoftware.dcollect.DataClass;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.dcollect.Drive;
import com.blackhillsoftware.dcollect.Library;
import com.blackhillsoftware.dcollect.ManagementClass;
import com.blackhillsoftware.dcollect.MigratedDataset;
import com.blackhillsoftware.dcollect.SmsAccountingInformation;
import com.blackhillsoftware.dcollect.SmsVolume;
import com.blackhillsoftware.dcollect.StorageClass;
import com.blackhillsoftware.dcollect.StorageGroup;
import com.blackhillsoftware.dcollect.TapeCapacityPlanning;
import com.blackhillsoftware.dcollect.Volume;
import com.blackhillsoftware.dcollect.VsamAssociation;
import com.blackhillsoftware.smf.SmfRecord;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class DcollectRecord
extends VRecord {
    private static SmfRecord smf = new SmfRecord(new byte[24]);

    public DcollectRecord(byte[] data) {
        super(data);
    }

    public DcollectRecord(VRecord record) {
        super(record);
    }

    public static DcollectRecord from(VRecord record) {
        byte[] recordData = record.getBytes(4, record.recordLength() - 4);
        DcollectType dcrt = DcollectRecord.dcurctyp(recordData);
        switch (dcrt) {
            case A: {
                return new VsamAssociation(recordData);
            }
            case AG: {
                return new AggregateGroup(recordData);
            }
            case AI: {
                return new SmsAccountingInformation(recordData);
            }
            case B: {
                return new BackupDataset(recordData);
            }
            case BC: {
                return new BaseConfiguration(recordData);
            }
            case C: {
                return new DasdCapacityPlanning(recordData);
            }
            case CN: {
                return new CacheNames(recordData);
            }
            case D: {
                return new ActiveDataset(recordData);
            }
            case DC: {
                return new DataClass(recordData);
            }
            case DR: {
                return new Drive(recordData);
            }
            case LB: {
                return new Library(recordData);
            }
            case M: {
                return new MigratedDataset(recordData);
            }
            case MC: {
                return new ManagementClass(recordData);
            }
            case SC: {
                return new StorageClass(recordData);
            }
            case SG: {
                return new StorageGroup(recordData);
            }
            case T: {
                return new TapeCapacityPlanning(recordData);
            }
            case V: {
                return new Volume(recordData);
            }
            case VL: {
                return new SmsVolume(recordData);
            }
        }
        return new DcollectRecord(recordData);
    }

    public LocalDateTime dateTime() {
        return this.dcudate() != null ? this.dcudate().atTime(this.dcutime()) : null;
    }

    public LocalDateTime dcutmstp() {
        return this.dateTime();
    }

    public String dcollectType() {
        return this.dcurctyp().toString();
    }

    public int dculeng() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public static DcollectType dcurctyp(byte[] data) {
        return DcollectType.from(Util.ConvertEbcdic(data, 4, 2));
    }

    public DcollectType dcurctyp() {
        return DcollectType.from(Util.ConvertEbcdic(this.data, 4, 2));
    }

    public String dcurctypRawValue() {
        return Util.ConvertEbcdic(this.data, 4, 2);
    }

    public int dcuvers() {
        return Util.ConvertSignedBinary2(this.data, 6);
    }

    public String dcusysid() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public LocalTime dcutime() {
        return Util.Binary4x100STime(this.data, 12);
    }

    public long dcutimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public LocalDate dcudate() {
        return Util.SMFDate(this.data, 16);
    }

    public int dcudateRawValue() {
        return Util.ConvertPacked4(this.data, 16);
    }

    static enum Field {
        dculeng(0, 2),
        dcurctyp(4, 2),
        dcuvers(6, 2),
        dcusysid(8, 4),
        dcutime(12, 4),
        dcudate(16, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

