/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Drive
extends DcollectRecord {
    public static final int DDR32NAM = 128;
    private List<Status> m_ddrnstat = null;
    private List<Status> m_ddrstat = null;

    Drive(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.DR)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    Drive(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.DR)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static Drive from(VRecord record) {
        return new Drive(record);
    }

    public String ddrdname() {
        return Util.ConvertEbcdic(this.data, 26, 8);
    }

    public String ddrduser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate ddrddate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String ddrddateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public int ddrflags() {
        return Util.ConvertUnsignedBinary1(this.data, 74);
    }

    public boolean ddr32nam() {
        return Util.ConvertFlag(this.data, this.ddrflags(), 128);
    }

    public LocalTime ddrdtime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String ddrdtimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    private int ddrlblen() {
        return Util.ConvertUnsignedBinary2(this.data, 84);
    }

    public String ddrlibry() {
        if (this.data.length >= 86 + this.ddrlblen()) {
            return Util.ConvertEbcdic(this.data, 86, this.ddrlblen());
        }
        return null;
    }

    public String ddrlbnm() {
        return Util.ConvertEbcdic(this.data, 86, 8);
    }

    public List<Status> ddrnstat() {
        if (this.m_ddrnstat != null) {
            return this.m_ddrnstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(Status.create(this.data, 116 + i * 4, 4));
        }
        this.m_ddrnstat = result;
        return this.m_ddrnstat;
    }

    public long ddrdcons() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public List<Status> ddrstat() {
        if (this.m_ddrstat != null) {
            return this.m_ddrstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(32);
        for (int i = 0; i < 32; ++i) {
            result.add(Status.create(this.data, 152 + i * 8, 8));
        }
        this.m_ddrstat = result;
        return this.m_ddrstat;
    }

    public Status ddrsysst() {
        return Status.create(this.data, 152, 8);
    }

    public static final class Status
    extends Data {
        private Status(byte[] Data2, int offset, int length) {
            super(Data2, offset, length);
        }

        public DriveStatus requestedStatus() {
            int value = Util.ConvertUnsignedBinary1(this.data, 0);
            return DriveStatus.from(value);
        }

        public int requestedStatusRawValue() {
            return Util.ConvertUnsignedBinary1(this.data, 0);
        }

        public DriveStatus currentStatus() {
            int value = Util.ConvertUnsignedBinary1(this.data, 1);
            return DriveStatus.from(value);
        }

        public int currentStatusRawValue() {
            return Util.ConvertUnsignedBinary1(this.data, 1);
        }

        public static Status create(byte[] Data2, int offset, int length) {
            return new Status(Data2, offset, length);
        }

        static enum Field {
            ddrreqst(0, 1),
            ddrcurst(1, 1);

            private final int offset;
            private final int length;

            private Field(int offset, int length) {
                this.offset = offset;
                this.length = length;
            }

            private Field() {
                this.offset = 0;
                this.length = 0;
            }

            int offset() {
                return this.offset;
            }

            int length() {
                return this.length;
            }
        }
    }

    public static enum DriveStatus {
        NO_CONNECT(0),
        ONLINE(1),
        OFFLINE(2),
        NO_REQUEST(3),
        NOT_DEFINED(-16);

        private static Map<Integer, DriveStatus> valueMap;
        private final transient int drivestatus;

        private DriveStatus(int oamdrivestatus) {
            this.drivestatus = oamdrivestatus;
        }

        public static DriveStatus from(int value) {
            DriveStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int drivestatus() {
            return this.drivestatus;
        }

        static {
            valueMap = new HashMap<Integer, DriveStatus>();
            for (DriveStatus x : DriveStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.drivestatus, x);
            }
        }
    }

    static enum Field {
        ddrdname(26, 8),
        ddrduser(56, 8),
        ddrddate(64, 10),
        ddrflags(74, 1),
        ddrdtime(76, 8),
        ddrlblen(84, 2),
        ddrlibry(86, 0),
        ddrlbnm(86, 8),
        ddrnstat(116, 32),
        ddromst(116, 4),
        ddrsout(116, 1),
        ddrcfcs(117, 1),
        ddrdcons(148, 4),
        ddrstat(152, 8),
        ddrsysst(152, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

