/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Library
extends DcollectRecord {
    public static final int DLB32NAM = 128;
    private List<Status> m_dlbnstat = null;
    private List<Status> m_dlbstat = null;

    Library(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.LB)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    Library(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.LB)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static Library from(VRecord record) {
        return new Library(record);
    }

    private int dlbnmlen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public String dlblname() {
        if (this.data.length >= 26 + this.dlbnmlen()) {
            return Util.ConvertEbcdic(this.data, 26, this.dlbnmlen());
        }
        return null;
    }

    public String dlbname() {
        return Util.ConvertEbcdic(this.data, 26, 8);
    }

    public String dlbduser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dlbddate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dlbddateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public int dlbflags() {
        return Util.ConvertUnsignedBinary1(this.data, 74);
    }

    public boolean dlb32nam() {
        return Util.ConvertFlag(this.data, this.dlbflags(), 128);
    }

    public LocalTime dlbdtime() {
        return Util.Dcollect_SMS_Time_8(this.data, 80);
    }

    public String dlbdtimeRawValue() {
        return Util.ConvertEbcdic(this.data, 80, 8);
    }

    public List<Status> dlbnstat() {
        if (this.m_dlbnstat != null) {
            return this.m_dlbnstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(8);
        for (int i = 0; i < 8; ++i) {
            result.add(Status.create(this.data, 88 + i * 4, 4));
        }
        this.m_dlbnstat = result;
        return this.m_dlbnstat;
    }

    public Status dlbomst() {
        return Status.create(this.data, 88, 4);
    }

    public LibraryStatus dlbsout() {
        int value = Util.ConvertUnsignedBinary1(this.data, 88);
        return LibraryStatus.from(value);
    }

    public int dlbsoutRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 88);
    }

    public LibraryStatus dlbcfcs() {
        int value = Util.ConvertUnsignedBinary1(this.data, 89);
        return LibraryStatus.from(value);
    }

    public int dlbcfcsRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 89);
    }

    public LibraryType dlbtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 120);
        return LibraryType.from(value);
    }

    public int dlbtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 120);
    }

    public Device dlbdtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 123);
        return Device.from(value);
    }

    public int dlbdtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 123);
    }

    public long dlbdcons() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public DefaultUse dlbedvt() {
        int value = Util.ConvertUnsignedBinary1(this.data, 128);
        return DefaultUse.from(value);
    }

    public int dlbedvtRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 128);
    }

    public EjectDefault dlbejd() {
        int value = Util.ConvertUnsignedBinary1(this.data, 129);
        return EjectDefault.from(value);
    }

    public int dlbejdRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 129);
    }

    public String dlblcbid() {
        return Util.ConvertEbcdic(this.data, 130, 5);
    }

    public String dlbedunm() {
        return Util.ConvertEbcdic(this.data, 136, 8);
    }

    private int dlbdclen() {
        return Util.ConvertUnsignedBinary2(this.data, 144);
    }

    public String dlbdclnm() {
        if (this.data.length >= 146 + this.dlbdclen()) {
            return Util.ConvertEbcdic(this.data, 146, this.dlbdclen());
        }
        return null;
    }

    public String dlbdcnam() {
        return Util.ConvertEbcdic(this.data, 146, 8);
    }

    public List<Status> dlbstat() {
        if (this.m_dlbstat != null) {
            return this.m_dlbstat;
        }
        ArrayList<Status> result = new ArrayList<Status>(32);
        for (int i = 0; i < 32; ++i) {
            result.add(Status.create(this.data, 176 + i * 8, 8));
        }
        this.m_dlbstat = result;
        return this.m_dlbstat;
    }

    public Status dlbsysst() {
        return Status.create(this.data, 176, 4);
    }

    public static final class Status
    extends Data {
        private Status(byte[] Data2, int offset, int length) {
            super(Data2, offset, length);
        }

        public LibraryStatus requestedStatus() {
            int value = Util.ConvertUnsignedBinary1(this.data, 0);
            return LibraryStatus.from(value);
        }

        public int requestedStatusRawValue() {
            return Util.ConvertUnsignedBinary1(this.data, 0);
        }

        public LibraryStatus currentStatus() {
            int value = Util.ConvertUnsignedBinary1(this.data, 1);
            return LibraryStatus.from(value);
        }

        public int currentStatusRawValue() {
            return Util.ConvertUnsignedBinary1(this.data, 1);
        }

        public static Status create(byte[] Data2, int offset, int length) {
            return new Status(Data2, offset, length);
        }

        static enum Field {
            dlbreqst(0, 1),
            dlbcurst(1, 1);

            private final int offset;
            private final int length;

            private Field(int offset, int length) {
                this.offset = offset;
                this.length = length;
            }

            private Field() {
                this.offset = 0;
                this.length = 0;
            }

            int offset() {
                return this.offset;
            }

            int length() {
                return this.length;
            }
        }
    }

    public static enum LibraryStatus {
        NO_CONNECT(0),
        ONLINE(1),
        OFFLINE(2),
        NO_REQUEST(3),
        PENDING_OFFLINE(4),
        NOT_DEFINED(-16);

        private static Map<Integer, LibraryStatus> valueMap;
        private final transient int librarystatus;

        private LibraryStatus(int librarystatus) {
            this.librarystatus = librarystatus;
        }

        public static LibraryStatus from(int value) {
            LibraryStatus result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int librarystatus() {
            return this.librarystatus;
        }

        static {
            valueMap = new HashMap<Integer, LibraryStatus>();
            for (LibraryStatus x : LibraryStatus.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.librarystatus, x);
            }
        }
    }

    public static enum LibraryType {
        NOT_OPTICAL(0),
        REAL(1),
        PSEUDO(2),
        NOT_DEFINED(-16);

        private static Map<Integer, LibraryType> valueMap;
        private final transient int librarytype;

        private LibraryType(int librarytype) {
            this.librarytype = librarytype;
        }

        public static LibraryType from(int value) {
            LibraryType result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int librarytype() {
            return this.librarytype;
        }

        static {
            valueMap = new HashMap<Integer, LibraryType>();
            for (LibraryType x : LibraryType.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.librarytype, x);
            }
        }
    }

    public static enum Device {
        IBM9246(0),
        IBM3995(1),
        TAPE(2),
        NOT_DEFINED(-16);

        private static Map<Integer, Device> valueMap;
        private final transient int librarydevice;

        private Device(int librarydevice) {
            this.librarydevice = librarydevice;
        }

        public static Device from(int value) {
            Device result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int ibrarydevice() {
            return this.librarydevice;
        }

        static {
            valueMap = new HashMap<Integer, Device>();
            for (Device x : Device.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.librarydevice, x);
            }
        }
    }

    public static enum DefaultUse {
        NULL(0),
        PRIVATE(1),
        SCRATCH(2),
        NOT_DEFINED(-16);

        private static Map<Integer, DefaultUse> valueMap;
        private final transient int librarydefaultuse;

        private DefaultUse(int librarydefaultuse) {
            this.librarydefaultuse = librarydefaultuse;
        }

        public static DefaultUse from(int value) {
            DefaultUse result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int librarydefaultuse() {
            return this.librarydefaultuse;
        }

        static {
            valueMap = new HashMap<Integer, DefaultUse>();
            for (DefaultUse x : DefaultUse.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.librarydefaultuse, x);
            }
        }
    }

    public static enum EjectDefault {
        NULL(0),
        PURGE(1),
        KEEP(2),
        NOT_DEFINED(-16);

        private static Map<Integer, EjectDefault> valueMap;
        private final transient int libraryejectdefault;

        private EjectDefault(int libraryejectdefault) {
            this.libraryejectdefault = libraryejectdefault;
        }

        public static EjectDefault from(int value) {
            EjectDefault result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int libraryejectdefault() {
            return this.libraryejectdefault;
        }

        static {
            valueMap = new HashMap<Integer, EjectDefault>();
            for (EjectDefault x : EjectDefault.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.libraryejectdefault, x);
            }
        }
    }

    static enum Field {
        dlbnmlen(24, 2),
        dlblname(26, 0),
        dlbname(26, 8),
        dlbduser(56, 8),
        dlbddate(64, 10),
        dlbflags(74, 1),
        dlbdtime(80, 8),
        dlbnstat(88, 32),
        dlbomst(88, 4),
        dlbsout(88, 1),
        dlbcfcs(89, 1),
        dlbtype(120, 1),
        dlbdtype(123, 1),
        dlbdcons(124, 4),
        dlbedvt(128, 1),
        dlbejd(129, 1),
        dlblcbid(130, 5),
        dlbedunm(136, 8),
        dlbdclen(144, 2),
        dlbdclnm(146, 0),
        dlbdcnam(146, 8),
        dlbstat(176, 8),
        dlbsysst(176, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

