/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public final class ManagementClass
extends DcollectRecord {
    public static final int DMCFBVER = 128;
    public static final int DMCFBVRD = 64;
    public static final int DMCFRBK = 32;
    public static final int DMCFRNP = 16;
    public static final int DMCFEXDT = 8;
    public static final int DMCFEXDY = 4;
    public static final int DMCFPRDY = 2;
    public static final int DMCFL1DY = 128;
    public static final int DMCFRLMG = 64;
    public static final int DMCFPELE = 32;
    public static final int DMCFBKFQ = 16;
    public static final int DMCFCTSR = 8;
    public static final int DMCFCTCP = 4;
    public static final int DMCPREL = 128;
    public static final int DMCPRCN = 64;
    public static final int DMCPRIM = 32;
    public static final int DMCRLOMG = 128;
    public static final int DMCARNOL = 128;
    public static final int DMCDYNOL = 128;
    public static final int DMCDTNOL = 64;
    public static final int DMCL2LIM = 128;
    public static final int DMCL1NOL = 32;
    public static final int DMCRBNOL = 128;
    public static final int DMCNPNOL = 64;
    public static final int DMCAUTBK = 16;
    public static final int DMCCPYTF = 8;
    public static final int DMCRPNOL = 128;
    public static final int DMCTCYR = 128;
    public static final int DMCTCMN = 64;
    public static final int DMCTCDY = 32;
    public static final int DMCTSYR = 128;
    public static final int DMCTSMN = 64;
    public static final int DMCTSDY = 32;
    public static final int DMCPEMN = 128;
    public static final int DMCPEQD = 64;
    public static final int DMCPEQM = 32;
    public static final int DMCPEYD = 16;
    public static final int DMCPEYM = 8;
    public static final int DMCFIRST = 4;
    public static final int DMCLAST = 2;

    ManagementClass(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.MC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    ManagementClass(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.MC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static ManagementClass from(VRecord record) {
        return new ManagementClass(record);
    }

    private int dmcnmlen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public String dmcname() {
        if (this.data.length >= 26 + this.dmcnmlen()) {
            return Util.ConvertEbcdic(this.data, 26, this.dmcnmlen());
        }
        return null;
    }

    public String dmcuser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dmcdate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dmcdateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime dmctime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String dmctimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String dmcdesc() {
        return Util.ConvertEbcdic(this.data, 84, 120);
    }

    public int dmcspec1() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public boolean dmcfbver() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 128);
    }

    public boolean dmcfbvrd() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 64);
    }

    public boolean dmcfrbk() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 32);
    }

    public boolean dmcfrnp() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 16);
    }

    public boolean dmcfexdt() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 8);
    }

    public boolean dmcfexdy() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 4);
    }

    public boolean dmcfprdy() {
        return Util.ConvertFlag(this.data, this.dmcspec1(), 2);
    }

    public int dmcspec2() {
        return Util.ConvertUnsignedBinary1(this.data, 205);
    }

    public boolean dmcfl1dy() {
        return Util.ConvertFlag(this.data, this.dmcspec2(), 128);
    }

    public boolean dmcfrlmg() {
        return Util.ConvertFlag(this.data, this.dmcspec2(), 64);
    }

    public boolean dmcfpele() {
        return Util.ConvertFlag(this.data, this.dmcspec2(), 32);
    }

    public boolean dmcfbkfq() {
        return Util.ConvertFlag(this.data, this.dmcspec2(), 16);
    }

    public boolean dmcfctsr() {
        return Util.ConvertFlag(this.data, this.dmcspec2(), 8);
    }

    public boolean dmcfctcp() {
        return Util.ConvertFlag(this.data, this.dmcspec2(), 4);
    }

    public int dmcrlf() {
        return Util.ConvertUnsignedBinary1(this.data, 206);
    }

    public boolean dmcprel() {
        return Util.ConvertFlag(this.data, this.dmcrlf(), 128);
    }

    public boolean dmcprcn() {
        return Util.ConvertFlag(this.data, this.dmcrlf(), 64);
    }

    public boolean dmcprim() {
        return Util.ConvertFlag(this.data, this.dmcrlf(), 32);
    }

    public int dmcgdgfl() {
        return Util.ConvertUnsignedBinary1(this.data, 208);
    }

    public boolean dmcrlomg() {
        return Util.ConvertFlag(this.data, this.dmcgdgfl(), 128);
    }

    public int dmcpelem() {
        return Util.ConvertSignedBinary2(this.data, 210);
    }

    public int dmcexpf() {
        return Util.ConvertUnsignedBinary1(this.data, 212);
    }

    public boolean dmcarnol() {
        return Util.ConvertFlag(this.data, this.dmcexpf(), 128);
    }

    public ExpireAction dmcexpac() {
        int value = Util.ConvertUnsignedBinary1(this.data, 213);
        return ExpireAction.from(value);
    }

    public int dmcexpacRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 213);
    }

    public int dmcrdarc() {
        return Util.ConvertUnsignedBinary2(this.data, 214);
    }

    public int dmcretf() {
        return Util.ConvertUnsignedBinary1(this.data, 216);
    }

    public boolean dmcdynol() {
        return Util.ConvertFlag(this.data, this.dmcretf(), 128);
    }

    public boolean dmcdtnol() {
        return Util.ConvertFlag(this.data, this.dmcretf(), 64);
    }

    public ExpirationFormat dmcrfmt() {
        int value = Util.ConvertUnsignedBinary1(this.data, 217);
        return ExpirationFormat.from(value);
    }

    public int dmcrfmtRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 217);
    }

    public int dmcexpdy() {
        return Util.ConvertSignedBinary4(this.data, 220);
    }

    public int dmcexdat() {
        return this.dmcrfmt() == ExpirationFormat.DAYS ? Util.ConvertSignedBinary4(this.data, 224) : 0;
    }

    public int dmceyear() {
        return this.dmcrfmt() == ExpirationFormat.DATE ? Util.ConvertUnsignedBinary2(this.data, 224) : 0;
    }

    public int dmceday() {
        return this.dmcrfmt() == ExpirationFormat.DATE ? Util.ConvertUnsignedBinary2(this.data, 226) : 0;
    }

    public int dmcmigf() {
        return Util.ConvertUnsignedBinary1(this.data, 228);
    }

    public boolean dmcl2lim() {
        return Util.ConvertFlag(this.data, this.dmcmigf(), 128);
    }

    public boolean dmcl1nol() {
        return Util.ConvertFlag(this.data, this.dmcmigf(), 32);
    }

    public int dmcprdy() {
        return Util.ConvertSignedBinary2(this.data, 230);
    }

    public int dmcl1dy() {
        return Util.ConvertSignedBinary2(this.data, 232);
    }

    public Migrate dmccmau() {
        int value = Util.ConvertUnsignedBinary1(this.data, 234);
        return Migrate.from(value);
    }

    public int dmccmauRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 234);
    }

    public int dmcbkflg() {
        return Util.ConvertUnsignedBinary1(this.data, 236);
    }

    public boolean dmcrbnol() {
        return Util.ConvertFlag(this.data, this.dmcbkflg(), 128);
    }

    public boolean dmcnpnol() {
        return Util.ConvertFlag(this.data, this.dmcbkflg(), 64);
    }

    public boolean dmcautbk() {
        return Util.ConvertFlag(this.data, this.dmcbkflg(), 16);
    }

    public boolean dmccpytf() {
        return Util.ConvertFlag(this.data, this.dmcbkflg(), 8);
    }

    public int dmcbkfq() {
        return Util.ConvertSignedBinary2(this.data, 240);
    }

    public int dmcbkvs() {
        return Util.ConvertSignedBinary2(this.data, 242);
    }

    public int dmcbvrd() {
        return Util.ConvertSignedBinary2(this.data, 244);
    }

    public int dmcbkdy() {
        return Util.ConvertSignedBinary2(this.data, 246);
    }

    public int dmcbknp() {
        return Util.ConvertSignedBinary2(this.data, 248);
    }

    public Backup dmcbadu() {
        int value = Util.ConvertUnsignedBinary1(this.data, 250);
        return Backup.from(value);
    }

    public int dmcbaduRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 250);
    }

    public CopyTec dmccpytc() {
        int value = Util.ConvertUnsignedBinary1(this.data, 251);
        return CopyTec.from(value);
    }

    public int dmccpytcRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 251);
    }

    public String dmcbkudc() {
        return Util.ConvertEbcdic(this.data, 252, 8);
    }

    public int dmcmretf() {
        return Util.ConvertUnsignedBinary1(this.data, 260);
    }

    public boolean dmcrpnol() {
        return Util.ConvertFlag(this.data, this.dmcmretf(), 128);
    }

    public int dmcmrtdy() {
        return Util.ConvertUnsignedBinary3(this.data, 261);
    }

    public int dmctscr() {
        return Util.ConvertUnsignedBinary1(this.data, 264);
    }

    public boolean dmctcyr() {
        return Util.ConvertFlag(this.data, this.dmctscr(), 128);
    }

    public boolean dmctcmn() {
        return Util.ConvertFlag(this.data, this.dmctscr(), 64);
    }

    public boolean dmctcdy() {
        return Util.ConvertFlag(this.data, this.dmctscr(), 32);
    }

    public int dmctslu() {
        return Util.ConvertUnsignedBinary1(this.data, 265);
    }

    public boolean dmctsyr() {
        return Util.ConvertFlag(this.data, this.dmctslu(), 128);
    }

    public boolean dmctsmn() {
        return Util.ConvertFlag(this.data, this.dmctslu(), 64);
    }

    public boolean dmctsdy() {
        return Util.ConvertFlag(this.data, this.dmctslu(), 32);
    }

    public int dmcperd() {
        return Util.ConvertUnsignedBinary1(this.data, 266);
    }

    public boolean dmcpemn() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 128);
    }

    public boolean dmcpeqd() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 64);
    }

    public boolean dmcpeqm() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 32);
    }

    public boolean dmcpeyd() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 16);
    }

    public boolean dmcpeym() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 8);
    }

    public boolean dmcfirst() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 4);
    }

    public boolean dmclast() {
        return Util.ConvertFlag(this.data, this.dmcperd(), 2);
    }

    public int dmcvscy() {
        return Util.ConvertSignedBinary2(this.data, 268);
    }

    public int dmcvscm() {
        return Util.ConvertSignedBinary2(this.data, 270);
    }

    public int dmcvscd() {
        return Util.ConvertSignedBinary2(this.data, 272);
    }

    public int dmcvsuy() {
        return Util.ConvertSignedBinary2(this.data, 274);
    }

    public int dmcvsum() {
        return Util.ConvertSignedBinary2(this.data, 276);
    }

    public int dmcvsud() {
        return Util.ConvertSignedBinary2(this.data, 278);
    }

    public int dmcvprd() {
        return Util.ConvertSignedBinary2(this.data, 280);
    }

    public int dmcvpmd() {
        return Util.ConvertSignedBinary2(this.data, 282);
    }

    public int dmcvpqd() {
        return Util.ConvertSignedBinary2(this.data, 284);
    }

    public int dmcvpqm() {
        return Util.ConvertSignedBinary2(this.data, 286);
    }

    public int dmcvpyd() {
        return Util.ConvertSignedBinary2(this.data, 288);
    }

    public int dmcvpym() {
        return Util.ConvertSignedBinary2(this.data, 290);
    }

    public int dmcctsrl() {
        return Util.ConvertUnsignedBinary2(this.data, 308);
    }

    public int dmcctcpy() {
        return Util.ConvertUnsignedBinary2(this.data, 310);
    }

    public int dmccl2dy() {
        return Util.ConvertUnsignedBinary2(this.data, 312);
    }

    private int dmccllen() {
        return Util.ConvertUnsignedBinary2(this.data, 314);
    }

    public String dmcclnam() {
        if (this.data.length >= 316 + this.dmccllen()) {
            return Util.ConvertEbcdic(this.data, 316, this.dmccllen());
        }
        return null;
    }

    public long dmcszlte() {
        return Util.ConvertUnsignedBinary4(this.data, 348);
    }

    public long dmcszgt() {
        return Util.ConvertUnsignedBinary4(this.data, 352);
    }

    public int dmcaclte() {
        return Util.ConvertUnsignedBinary1(this.data, 356);
    }

    public int dmcacgt() {
        return Util.ConvertUnsignedBinary1(this.data, 357);
    }

    public static enum ExpireAction {
        NULL(0),
        DEL(1),
        ARC(2),
        NOT_DEFINED(-16);

        private static Map<Integer, ExpireAction> valueMap;
        private final transient int mcexpact;

        private ExpireAction(int mcexpact) {
            this.mcexpact = mcexpact;
        }

        public static ExpireAction from(int value) {
            ExpireAction result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int mcexpact() {
            return this.mcexpact;
        }

        static {
            valueMap = new HashMap<Integer, ExpireAction>();
            for (ExpireAction x : ExpireAction.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.mcexpact, x);
            }
        }
    }

    public static enum ExpirationFormat {
        NULL(0),
        DATE(1),
        DAYS(2),
        NOT_DEFINED(-16);

        private static Map<Integer, ExpirationFormat> valueMap;
        private final transient int mcexpformat;

        private ExpirationFormat(int mcexpformat) {
            this.mcexpformat = mcexpformat;
        }

        public static ExpirationFormat from(int value) {
            ExpirationFormat result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int mcexpformat() {
            return this.mcexpformat;
        }

        static {
            valueMap = new HashMap<Integer, ExpirationFormat>();
            for (ExpirationFormat x : ExpirationFormat.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.mcexpformat, x);
            }
        }
    }

    public static enum Migrate {
        NONE(0),
        COMMAND(1),
        BOTH(2),
        NOT_DEFINED(-16);

        private static Map<Integer, Migrate> valueMap;
        private final transient int mcmigrate;

        private Migrate(int mcmigrate) {
            this.mcmigrate = mcmigrate;
        }

        public static Migrate from(int value) {
            Migrate result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int mcmigrate() {
            return this.mcmigrate;
        }

        static {
            valueMap = new HashMap<Integer, Migrate>();
            for (Migrate x : Migrate.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.mcmigrate, x);
            }
        }
    }

    public static enum Backup {
        NONE(0),
        ADMIN(1),
        BOTH(2),
        NOT_DEFINED(-16);

        private static Map<Integer, Backup> valueMap;
        private final transient int mcbackup;

        private Backup(int mcbackup) {
            this.mcbackup = mcbackup;
        }

        public static Backup from(int value) {
            Backup result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int mcbackup() {
            return this.mcbackup;
        }

        static {
            valueMap = new HashMap<Integer, Backup>();
            for (Backup x : Backup.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.mcbackup, x);
            }
        }
    }

    public static enum CopyTec {
        STANDARD(0),
        CONCURRENT_PREFERRED(1),
        CONCURRENT_REQUIRED(2),
        NOT_DEFINED(-16);

        private static Map<Integer, CopyTec> valueMap;
        private final transient int mccopytec;

        private CopyTec(int mccopytec) {
            this.mccopytec = mccopytec;
        }

        public static CopyTec from(int value) {
            CopyTec result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int mccopytec() {
            return this.mccopytec;
        }

        static {
            valueMap = new HashMap<Integer, CopyTec>();
            for (CopyTec x : CopyTec.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.mccopytec, x);
            }
        }
    }

    static enum Field {
        dmcnmlen(24, 2),
        dmcname(26, 0),
        dmcuser(56, 8),
        dmcdate(64, 10),
        dmctime(76, 8),
        dmcdesc(84, 120),
        dmcspec1(204, 1),
        dmcspec2(205, 1),
        dmcrlf(206, 1),
        dmcgdgfl(208, 1),
        dmcpelem(210, 2),
        dmcexpf(212, 1),
        dmcexpac(213, 1),
        dmcrdarc(214, 2),
        dmcretf(216, 1),
        dmcrfmt(217, 1),
        dmcexpdy(220, 4),
        dmcexdat(224, 4),
        dmceyear(224, 2),
        dmceday(226, 2),
        dmcmigf(228, 1),
        dmcprdy(230, 2),
        dmcl1dy(232, 2),
        dmccmau(234, 1),
        dmcbkflg(236, 1),
        dmcbkfq(240, 2),
        dmcbkvs(242, 2),
        dmcbvrd(244, 2),
        dmcbkdy(246, 2),
        dmcbknp(248, 2),
        dmcbadu(250, 1),
        dmccpytc(251, 1),
        dmcbkudc(252, 8),
        dmcmretf(260, 1),
        dmcmrtdy(261, 3),
        dmctscr(264, 1),
        dmctslu(265, 1),
        dmcperd(266, 1),
        dmcvscy(268, 2),
        dmcvscm(270, 2),
        dmcvscd(272, 2),
        dmcvsuy(274, 2),
        dmcvsum(276, 2),
        dmcvsud(278, 2),
        dmcvprd(280, 2),
        dmcvpmd(282, 2),
        dmcvpqd(284, 2),
        dmcvpqm(286, 2),
        dmcvpyd(288, 2),
        dmcvpym(290, 2),
        dmcctsrl(308, 2),
        dmcctcpy(310, 2),
        dmccl2dy(312, 2),
        dmccllen(314, 2),
        dmcclnam(316, 0),
        dmcszlte(348, 4),
        dmcszgt(352, 4),
        dmcaclte(356, 1),
        dmcacgt(357, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

