/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.dcollect;

import com.blackhillsoftware.dcollect.DcollectRecord;
import com.blackhillsoftware.dcollect.DcollectType;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.internal.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public final class StorageClass
extends DcollectRecord {
    public static final int DSCDFGSP = 128;
    public static final int DSCDFAVL = 64;
    public static final int DSCFDIRR = 32;
    public static final int DSCFDIRB = 16;
    public static final int DSCFSEQR = 8;
    public static final int DSCFSEQB = 4;
    public static final int DSCSYNCD = 2;
    public static final int DSCFIAD = 1;
    public static final int DSCDFACC = 128;
    public static final int DSCDFSDR = 64;
    public static final int DSCFDCFW = 32;
    public static final int DSCFSCFW = 16;
    public static final int DSCVERSP = 8;
    public static final int DSCBUSP = 4;
    public static final int DSCDSSEP = 2;
    public static final int DSCTIERS = 1;
    public static final int DSCTIER = 128;
    public static final int DSCPAVS = 64;
    public static final int DSCFOLS = 32;
    public static final int DSCFDCLS = 8;
    public static final int DSCDCLS = 128;
    public static final int DSCHLERD = 128;
    public static final int DSCHLEWR = 64;

    StorageClass(byte[] Data2) {
        super(Data2);
        if (!this.dcurctyp().equals((Object)DcollectType.SC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    StorageClass(VRecord record) {
        super(record);
        if (!this.dcurctyp().equals((Object)DcollectType.SC)) {
            throw new IllegalArgumentException("Wrong record type " + this.dcurctyp().toString());
        }
    }

    public static StorageClass from(VRecord record) {
        return new StorageClass(record);
    }

    private int dscnmlen() {
        return Util.ConvertUnsignedBinary2(this.data, 24);
    }

    public String dscname() {
        if (this.data.length >= 26 + this.dscnmlen()) {
            return Util.ConvertEbcdic(this.data, 26, this.dscnmlen());
        }
        return null;
    }

    public String dscuser() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public LocalDate dscdate() {
        return Util.Dcollect_SMS_Date_10(this.data, 64);
    }

    public String dscdateRawValue() {
        return Util.ConvertEbcdic(this.data, 64, 10);
    }

    public LocalTime dsctime() {
        return Util.Dcollect_SMS_Time_8(this.data, 76);
    }

    public String dsctimeRawValue() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String dscdesc() {
        return Util.ConvertEbcdic(this.data, 84, 120);
    }

    public int dscflags() {
        return Util.ConvertUnsignedBinary1(this.data, 204);
    }

    public boolean dscdfgsp() {
        return Util.ConvertFlag(this.data, this.dscflags(), 128);
    }

    public boolean dscdfavl() {
        return Util.ConvertFlag(this.data, this.dscflags(), 64);
    }

    public boolean dscfdirr() {
        return Util.ConvertFlag(this.data, this.dscflags(), 32);
    }

    public boolean dscfdirb() {
        return Util.ConvertFlag(this.data, this.dscflags(), 16);
    }

    public boolean dscfseqr() {
        return Util.ConvertFlag(this.data, this.dscflags(), 8);
    }

    public boolean dscfseqb() {
        return Util.ConvertFlag(this.data, this.dscflags(), 4);
    }

    public boolean dscsyncd() {
        return Util.ConvertFlag(this.data, this.dscflags(), 2);
    }

    public boolean dscfiad() {
        return Util.ConvertFlag(this.data, this.dscflags(), 1);
    }

    public int dscflag2() {
        return Util.ConvertUnsignedBinary1(this.data, 205);
    }

    public boolean dscdfacc() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 128);
    }

    public boolean dscdfsdr() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 64);
    }

    public boolean dscfdcfw() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 32);
    }

    public boolean dscfscfw() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 16);
    }

    public boolean dscversp() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 8);
    }

    public boolean dscbusp() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 4);
    }

    public boolean dscdssep() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 2);
    }

    public boolean dsctiers() {
        return Util.ConvertFlag(this.data, this.dscflag2(), 1);
    }

    public int dscversn() {
        return Util.ConvertUnsignedBinary1(this.data, 206);
    }

    public int dscbakup() {
        return Util.ConvertUnsignedBinary1(this.data, 207);
    }

    public Avail dscavail() {
        int value = Util.ConvertUnsignedBinary1(this.data, 208);
        return Avail.from(value);
    }

    public int dscavailRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 208);
    }

    public Bias dscdirb() {
        int value = Util.ConvertUnsignedBinary1(this.data, 209);
        return Bias.from(value);
    }

    public int dscdirbRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 209);
    }

    public Bias dscseqb() {
        int value = Util.ConvertUnsignedBinary1(this.data, 210);
        return Bias.from(value);
    }

    public int dscseqbRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 210);
    }

    public Access dscacces() {
        int value = Util.ConvertUnsignedBinary1(this.data, 211);
        return Access.from(value);
    }

    public int dscaccesRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 211);
    }

    public int dsciacdl() {
        return Util.ConvertSignedBinary4(this.data, 212);
    }

    public int dscdirr() {
        return Util.ConvertSignedBinary4(this.data, 216);
    }

    public int dscseqr() {
        return Util.ConvertSignedBinary4(this.data, 220);
    }

    public int dscstsdr() {
        return Util.ConvertSignedBinary4(this.data, 224);
    }

    private int dsccslen() {
        return Util.ConvertUnsignedBinary2(this.data, 228);
    }

    public String dsccsnam() {
        if (this.data.length >= 230 + this.dsccslen()) {
            return Util.ConvertEbcdic(this.data, 230, this.dsccslen());
        }
        return null;
    }

    public int dscdircw() {
        return Util.ConvertSignedBinary2(this.data, 260);
    }

    public int dscseqcw() {
        return Util.ConvertSignedBinary2(this.data, 262);
    }

    public int dscflag3() {
        return Util.ConvertUnsignedBinary1(this.data, 264);
    }

    public boolean dsctier() {
        return Util.ConvertFlag(this.data, this.dscflag3(), 128);
    }

    public boolean dscpavs() {
        return Util.ConvertFlag(this.data, this.dscflag3(), 64);
    }

    public boolean dscfols() {
        return Util.ConvertFlag(this.data, this.dscflag3(), 32);
    }

    public boolean dscfdcls() {
        return Util.ConvertFlag(this.data, this.dscflag3(), 8);
    }

    public int dscpav() {
        return Util.ConvertUnsignedBinary1(this.data, 265);
    }

    public int dscstosl() {
        return Util.ConvertUnsignedBinary1(this.data, 266);
    }

    public int dscvflg2() {
        return Util.ConvertUnsignedBinary1(this.data, 267);
    }

    public boolean dscdcls() {
        return Util.ConvertFlag(this.data, this.dscvflg2(), 128);
    }

    public int dsccmmft() {
        return Util.ConvertUnsignedBinary1(this.data, 268);
    }

    public boolean dschlerd() {
        return Util.ConvertFlag(this.data, this.dsccmmft(), 128);
    }

    public boolean dschlewr() {
        return Util.ConvertFlag(this.data, this.dsccmmft(), 64);
    }

    public static enum Avail {
        DONTCARE(0),
        STANDARD(1),
        CONTINUOUS(2),
        CONTINUOUS_PREFERRED(3),
        NOT_DEFINED(-16);

        private static Map<Integer, Avail> valueMap;
        private final transient int scavail;

        private Avail(int scavail) {
            this.scavail = scavail;
        }

        public static Avail from(int value) {
            Avail result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int scavail() {
            return this.scavail;
        }

        static {
            valueMap = new HashMap<Integer, Avail>();
            for (Avail x : Avail.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.scavail, x);
            }
        }
    }

    public static enum Bias {
        DONTCARE(0),
        READ(1),
        WRITE(2),
        NOT_DEFINED(-16);

        private static Map<Integer, Bias> valueMap;
        private final transient int scbias;

        private Bias(int scbias) {
            this.scbias = scbias;
        }

        public static Bias from(int value) {
            Bias result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int scbias() {
            return this.scbias;
        }

        static {
            valueMap = new HashMap<Integer, Bias>();
            for (Bias x : Bias.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.scbias, x);
            }
        }
    }

    public static enum Access {
        CONTINUOUS_PREFERRED(0),
        CONTINUOUS(1),
        STANDARD(2),
        NO_PREF(3),
        NOT_DEFINED(-16);

        private static Map<Integer, Access> valueMap;
        private final transient int scaccess;

        private Access(int scaccess) {
            this.scaccess = scaccess;
        }

        public static Access from(int value) {
            Access result = valueMap.get(value);
            if (result == null) {
                return NOT_DEFINED;
            }
            return result;
        }

        int scaccess() {
            return this.scaccess;
        }

        static {
            valueMap = new HashMap<Integer, Access>();
            for (Access x : Access.values()) {
                if (x == NOT_DEFINED) continue;
                valueMap.put(x.scaccess, x);
            }
        }
    }

    static enum Field {
        dscnmlen(24, 2),
        dscname(26, 0),
        dscuser(56, 8),
        dscdate(64, 10),
        dsctime(76, 8),
        dscdesc(84, 120),
        dscflags(204, 1),
        dscflag2(205, 1),
        dscversn(206, 1),
        dscbakup(207, 1),
        dscavail(208, 1),
        dscdirb(209, 1),
        dscseqb(210, 1),
        dscacces(211, 1),
        dsciacdl(212, 4),
        dscdirr(216, 4),
        dscseqr(220, 4),
        dscstsdr(224, 4),
        dsccslen(228, 2),
        dsccsnam(230, 0),
        dscdircw(260, 2),
        dscseqcw(262, 2),
        dscflag3(264, 1),
        dscpav(265, 1),
        dscstosl(266, 1),
        dscvflg2(267, 1),
        dsccmmft(268, 1);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

