/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.JzosRecordWriter;
import com.blackhillsoftware.smf.SmfRecord;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmfRecordWriter
implements Closeable {
    private JzosRecordWriter recordwriter = null;
    private OutputStream outstream = null;
    boolean closed = false;

    private SmfRecordWriter(JzosRecordWriter aRecordWriter) {
        this.recordwriter = aRecordWriter;
    }

    private SmfRecordWriter(OutputStream anOutputStream) {
        this.outstream = new BufferedOutputStream(anOutputStream);
    }

    public static SmfRecordWriter fromDD(String dd) throws IOException {
        return new SmfRecordWriter(JzosRecordWriter.fromDD(dd));
    }

    public static SmfRecordWriter fromStream(OutputStream stream) {
        return new SmfRecordWriter(stream);
    }

    public static SmfRecordWriter fromName(String name) throws IOException, FileNotFoundException {
        try {
            if (name.startsWith("//DD:")) {
                return new SmfRecordWriter(JzosRecordWriter.fromDD(name.substring(5)));
            }
            if (name.startsWith("//") && !name.startsWith("///")) {
                return new SmfRecordWriter(JzosRecordWriter.fromDatasetName(name));
            }
            return SmfRecordWriter.fromStream(new FileOutputStream(name));
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            boolean zos;
            String osname = System.getProperty("os.name").toLowerCase(Locale.US);
            boolean bl = zos = osname.indexOf("z/os") > -1;
            if (!zos) {
                Logger slf4jLogger = LoggerFactory.getLogger(SmfRecord.class);
                slf4jLogger.error("Error trying to open " + name);
                slf4jLogger.error("This error is expected if trying to read from a DDNAME on a non-z/OS system.");
            }
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.recordwriter != null) {
                this.recordwriter.close();
            }
            if (this.outstream != null) {
                this.outstream.close();
            }
        }
    }

    public synchronized void write(SmfRecord record) throws IOException {
        if (this.recordwriter != null) {
            SmfRecordWriter.write(this.recordwriter, record);
        } else {
            SmfRecordWriter.write(this.outstream, record);
        }
    }

    private static void write(JzosRecordWriter recordwriter, SmfRecord record) throws IOException {
        byte[] data = record.getDataArray();
        recordwriter.write(data, 4, data.length - 4);
    }

    private static void write(OutputStream outstream, SmfRecord record) throws IOException {
        outstream.write(record.getDataArray());
    }
}

