/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.SmfRecordReader;
import com.blackhillsoftware.smf.VRecord;
import com.blackhillsoftware.smf.VRecordReader;
import com.blackhillsoftware.smf.VbsSegmentInfo;
import com.blackhillsoftware.smf.internal.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class StreamRecordReader
extends VRecordReader {
    private SmfRecordReader.RecordFormat recfm = SmfRecordReader.RecordFormat.AUTODETECT;
    private InputStream in;
    private boolean blocked = false;
    private int currentBlocklength = 0;
    private int offsetInBlock = 0;
    private byte[] recorddata = new byte[32768];
    private byte[] blockdata = new byte[32768];

    StreamRecordReader(InputStream anInputStream, SmfRecordReader.RecordFormat format) {
        this.recfm = format;
        if (this.recfm == SmfRecordReader.RecordFormat.U) {
            this.blocked = true;
        }
        this.in = new BufferedInputStream(anInputStream);
    }

    @Override
    public synchronized VRecord read() throws IOException {
        int bytesread = this.read(this.recorddata);
        if (bytesread > 0) {
            return new VRecord(Arrays.copyOfRange(this.recorddata, 0, bytesread));
        }
        return null;
    }

    @Override
    public synchronized int read(byte[] buffer) throws IOException {
        VbsSegmentInfo segmentInfo;
        if (this.closed) {
            throw new IOException("Reader has been closed");
        }
        if (this.eof) {
            return -1;
        }
        if (this.recfm == SmfRecordReader.RecordFormat.AUTODETECT) {
            this.recfm = SmfRecordReader.detectStream(this.in);
            if (this.recfm == SmfRecordReader.RecordFormat.U) {
                this.blocked = true;
            }
        }
        if ((segmentInfo = this.nextSegmentInfo()) == null) {
            return -1;
        }
        if (segmentInfo.segmentType != VbsSegmentInfo.SegmentType.completeRecord && segmentInfo.segmentType != VbsSegmentInfo.SegmentType.firstSegment) {
            throw new IOException("Missing first segment of VBS record");
        }
        this.readSegment(buffer, 4, segmentInfo);
        int recordlength = segmentInfo.length();
        if (segmentInfo.segmentType != VbsSegmentInfo.SegmentType.completeRecord) {
            do {
                if ((segmentInfo = this.nextSegmentInfo()) == null) {
                    throw new IOException("Incomplete record at end of file");
                }
                if (segmentInfo.segmentType == VbsSegmentInfo.SegmentType.completeRecord || segmentInfo.segmentType == VbsSegmentInfo.SegmentType.firstSegment) {
                    throw new IOException("Incomplete record - start of new record when next segment was expected");
                }
                this.readSegment(buffer, recordlength, segmentInfo);
                recordlength += segmentInfo.length() - 4;
            } while (segmentInfo.segmentType != VbsSegmentInfo.SegmentType.lastSegment);
        }
        Util.WriteUnsignedBinary2(buffer, 0, recordlength);
        return recordlength;
    }

    private VbsSegmentInfo nextSegmentInfo() throws IOException {
        VbsSegmentInfo result;
        if (this.eof) {
            return null;
        }
        if (this.offsetInBlock >= this.currentBlocklength) {
            this.readBlockOrRecord();
        }
        VbsSegmentInfo vbsSegmentInfo = result = !this.eof ? new VbsSegmentInfo(this.blockdata, this.offsetInBlock) : null;
        while (result != null && result.segmentType == VbsSegmentInfo.SegmentType.nullSegment) {
            this.readBlockOrRecord();
            result = !this.eof ? new VbsSegmentInfo(this.blockdata, this.offsetInBlock) : null;
        }
        return result;
    }

    private void readSegment(byte[] buffer, int offset, VbsSegmentInfo segmentInfo) throws IOException {
        if (segmentInfo.length() < 4 || segmentInfo.length() > 32760) {
            throw new IOException("Invalid record/segment length: " + segmentInfo.length());
        }
        if (segmentInfo.length() - 4 > buffer.length - offset) {
            throw new IOException("Segment too large: " + Integer.toString(segmentInfo.length()) + ". Output record space remaining: " + Integer.toString(buffer.length - offset));
        }
        if (segmentInfo.length() > this.currentBlocklength - this.offsetInBlock) {
            throw new IOException("Incomplete record. Length: " + Integer.toString(segmentInfo.length()) + ". Block remaining: " + Integer.toString(this.currentBlocklength - this.offsetInBlock));
        }
        System.arraycopy(this.blockdata, this.offsetInBlock + 4, buffer, offset, segmentInfo.length() - 4);
        this.offsetInBlock += segmentInfo.length();
    }

    private void readBlockOrRecord() throws IOException {
        int descriptorWordBytesRead;
        int read;
        for (descriptorWordBytesRead = 0; descriptorWordBytesRead < 4; descriptorWordBytesRead += read) {
            read = this.in.read(this.blockdata, descriptorWordBytesRead, 4 - descriptorWordBytesRead);
            if (read > 0) {
                continue;
            }
            this.eof = true;
            break;
        }
        if (descriptorWordBytesRead == 0) {
            this.offsetInBlock = 0;
            this.currentBlocklength = 0;
        } else {
            int blockBytesRead;
            int read2;
            int length;
            if (descriptorWordBytesRead < 4) {
                throw new IOException("Incomplete block or record - read " + Integer.toString(descriptorWordBytesRead) + " bytes of BDW/RDW");
            }
            if (this.blocked) {
                long bdw = Util.ConvertUnsignedBinary4(this.blockdata, 0);
                if ((bdw & Integer.MIN_VALUE) != 0L) {
                    length = (int)(bdw & Integer.MAX_VALUE);
                    if (length > this.blockdata.length) {
                        this.blockdata = new byte[length];
                    }
                } else {
                    length = Util.ConvertUnsignedBinary2(this.blockdata, 0);
                }
            } else {
                length = Util.ConvertUnsignedBinary2(this.blockdata, 0);
                if (length == 0) {
                    length = Util.ConvertUnsignedBinary2(this.blockdata, 2) + 4;
                    Util.WriteUnsignedBinary2(this.blockdata, 0, length);
                    Util.WriteUnsignedBinary2(this.blockdata, 2, 0);
                }
                if (length > this.blockdata.length) {
                    throw new IOException("Record too large: " + Integer.toString(length) + " bytes");
                }
            }
            if (length < 4 || this.blocked && length < 8) {
                throw new IOException((this.blocked ? "Block" : "Record") + " too short: " + Integer.toString(length) + " bytes");
            }
            for (blockBytesRead = 4; blockBytesRead < length && (read2 = this.in.read(this.blockdata, blockBytesRead, length - blockBytesRead)) > 0; blockBytesRead += read2) {
            }
            if (blockBytesRead < length) {
                throw new IOException("Incomplete block - read " + Integer.toString(blockBytesRead) + " bytes, expected " + Integer.toString(length));
            }
            this.offsetInBlock = this.blocked ? 4 : 0;
            this.currentBlocklength = blockBytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                if (this.in != null) {
                    this.in.close();
                }
            }
        }
    }
}

