/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf;

import com.blackhillsoftware.smf.Data;
import com.blackhillsoftware.smf.RecordReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Spliterator;
import java.util.function.Consumer;

class VRecordReaderSpliterator<T extends Data>
implements Spliterator<T> {
    private RecordReader<T> source;
    private int allowedSplits;
    private Queue<T> queue = new ArrayDeque<T>(100);

    VRecordReaderSpliterator(RecordReader<T> source) {
        this.source = source;
        this.allowedSplits = Runtime.getRuntime().availableProcessors() * 2;
    }

    VRecordReaderSpliterator(RecordReader<T> source, int allowedSplits) {
        this.source = source;
        this.allowedSplits = allowedSplits;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        try {
            if (this.queue.isEmpty()) {
                this.source.refill(this.queue, 100);
            }
            if (!this.queue.isEmpty()) {
                action.accept(this.queue.remove());
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        if (this.allowedSplits < 2) {
            return null;
        }
        this.allowedSplits /= 2;
        return new VRecordReaderSpliterator<T>(this.source, this.allowedSplits);
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 0;
    }
}

