/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.blackhillsoftware.smf.internal.Util;
import java.util.Arrays;

public final class DictionaryEntry
extends SmfData {
    private transient MonitoringField fieldId;
    private int cmodleng;
    private int cmodofst = Util.ConvertUnsignedBinary2(this.data, 16);
    private transient int hashcode = 0;

    private DictionaryEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
        this.cmodleng = Util.ConvertUnsignedBinary2(this.data, 12);
        this.fieldId = MonitoringField.from(this);
    }

    public String cmodname() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public String cmodtype() {
        return Util.ConvertEbcdic(this.data, 8, 1);
    }

    public String cmodidnt() {
        return Util.ConvertEbcdic(this.data, 9, 3);
    }

    public String entryId() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public int cmodleng() {
        return this.cmodleng;
    }

    public int cmodconn() {
        return Util.ConvertUnsignedBinary2(this.data, 14);
    }

    public int cmodofst() {
        return this.cmodofst;
    }

    public String cmodhead() {
        return Util.ConvertEbcdic(this.data, 18, 8);
    }

    @Deprecated
    public MonitoringField getFieldId() {
        return this.fieldId;
    }

    public MonitoringField field() {
        return this.fieldId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DictionaryEntry other = (DictionaryEntry)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = Arrays.hashCode(this.data);
        }
        return this.hashcode;
    }

    @Override
    public String toString() {
        return this.cmodhead() + ":" + this.entryId();
    }

    public static DictionaryEntry create(byte[] Data2, int offset, int length) {
        return new DictionaryEntry(Data2, offset, length);
    }

    static enum Field {
        cmodname(0, 8),
        cmodtype(8, 1),
        cmodidnt(9, 3),
        cmodleng(12, 2),
        cmodconn(14, 2),
        cmodofst(16, 2),
        cmodhead(18, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

