/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.MnHeader;
import com.blackhillsoftware.smf.cics.MnProductSection;
import com.blackhillsoftware.smf.cics.monitoring.Cics;
import com.blackhillsoftware.smf.cics.monitoring.ExceptionType;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class ExceptionData
extends SmfData {
    private MnProductSection mnProductSection;
    private MnHeader mnHeader;

    private ExceptionData(byte[] Data2, int offset, int length, MnProductSection mnProductSection, MnHeader mnHeader) {
        super(Data2, offset, length);
        this.mnProductSection = mnProductSection;
        this.mnHeader = mnHeader;
    }

    public String smfmnsid() {
        return this.mnHeader.smfmnsid();
    }

    public String smfmnprn() {
        return this.mnProductSection.smfmnprn();
    }

    public String smfmnspn() {
        return this.mnProductSection.smfmnspn();
    }

    public String smfmnjbn() {
        return this.mnProductSection.smfmnjbn();
    }

    public ZoneOffset smfmndto() {
        return this.mnProductSection.smfmndto();
    }

    public String excmntrn() {
        return Util.ConvertEbcdic(this.data, 0, 4);
    }

    public long excmnter() {
        return Util.ConvertUnsignedBinary4(this.data, 4);
    }

    public String excmnusr() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String excmntst() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public ZonedDateTime excmnsta() {
        return Util.Binary8xStckTime(this.data, 20);
    }

    public BigInteger excmnstaRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 20);
    }

    public ZonedDateTime excmnsto() {
        return Util.Binary8xStckTime(this.data, 28);
    }

    public BigInteger excmnstoRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public Object excmntno() {
        return Cics.transactionId(this.data, 36, 4);
    }

    public long excmntpr() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public String excmnlun() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public long excmnexn() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public String excmnrty() {
        return Util.ConvertEbcdic(this.data, 64, 8);
    }

    public String excmnrid() {
        return Util.ConvertEbcdic(this.data, 72, 8);
    }

    public ExceptionType excmntyp() {
        int value = Util.ConvertUnsignedBinary2(this.data, 80);
        return ExceptionType.from(value);
    }

    public int excmntypRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 80);
    }

    public String excmntcn() {
        return Util.ConvertEbcdic(this.data, 84, 8);
    }

    public String excmnsrv() {
        return Util.ConvertEbcdic(this.data, 92, 8);
    }

    public String excmnrpt() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String excmnnpx() {
        return Util.ConvertEbcdic(this.data, 108, 20);
    }

    public BigInteger excmnnsx() {
        return Util.ConvertBigInteger(this.data, 128, 8);
    }

    public BigInteger excmntrf() {
        return Util.ConvertBigInteger(this.data, 136, 8);
    }

    public String excmnfcn() {
        return Util.ConvertEbcdic(this.data, 144, 4);
    }

    public String excmncpn() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public String excmnbtr() {
        return Util.ConvertEbcdic(this.data, 156, 4);
    }

    public BigInteger excmnuri() {
        return Util.ConvertBigInteger(this.data, 160, 16);
    }

    public int excmnril() {
        return Util.ConvertSignedBinary4(this.data, 176);
    }

    public String excmnrix() {
        if (this.data.length >= 180 + this.excmnril()) {
            return Util.ConvertEbcdic(this.data, 180, this.excmnril());
        }
        return null;
    }

    public String excmnnid() {
        return Util.ConvertEbcdic(this.data, 436, 8);
    }

    public String excmnrlu() {
        return Util.ConvertEbcdic(this.data, 444, 8);
    }

    public static ExceptionData create(byte[] Data2, int offset, int length, MnProductSection mnProductSection, MnHeader mnHeader) {
        return new ExceptionData(Data2, offset, length, mnProductSection, mnHeader);
    }

    static enum Field {
        excmntrn(0, 4),
        excmnter(4, 4),
        excmnusr(8, 8),
        excmntst(16, 4),
        excmnsta(20, 8),
        excmnsto(28, 8),
        excmntno(36, 4),
        excmntpr(40, 4),
        excmnlun(48, 8),
        excmnexn(60, 4),
        excmnrty(64, 8),
        excmnrid(72, 8),
        excmntyp(80, 2),
        excmntcn(84, 8),
        excmnsrv(92, 8),
        excmnrpt(100, 8),
        excmnnpx(108, 20),
        excmnnsx(128, 8),
        excmntrf(136, 8),
        excmnfcn(144, 4),
        excmncpn(148, 8),
        excmnbtr(156, 4),
        excmnuri(160, 16),
        excmnril(176, 4),
        excmnrix(180, 0),
        excmnnid(436, 8),
        excmnrlu(444, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

