/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.internal.Util;

public final class MniDataEntry
extends SmfData {
    private MniDataEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mniEntryIdent() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mniEntryLength() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public String mniEntryField() {
        if (this.data.length >= 4 + this.mniEntryLength()) {
            return Util.ConvertUtf8(this.data, 4, this.mniEntryLength());
        }
        return null;
    }

    public static MniDataEntry create(byte[] Data2, int offset, int length) {
        return new MniDataEntry(Data2, offset, length);
    }

    static enum Field {
        mniEntryIdent(0, 2),
        mniEntryLength(2, 2),
        mniEntryField(4, 0);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

