/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class MnrFileEntry
extends SmfData {
    public static final int MNR_FILE_LEN = 112;

    private MnrFileEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String mnrFileName() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public CicsClock mnrFileGet() {
        return CicsClock.create(this.data, 8, 8);
    }

    @Deprecated
    public Duration mnrFileGetTime() {
        return Util.Binary4_16_US(this.data, 8);
    }

    @Deprecated
    public double mnrFileGetTimeSeconds() {
        return Util.ToSeconds(this.mnrFileGetTime());
    }

    @Deprecated
    public long mnrFileGetTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    @Deprecated
    public int mnrFileGetFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    @Deprecated
    public int mnrFileGetCount() {
        return Util.ConvertUnsignedBinary3(this.data, 13);
    }

    public CicsClock mnrFilePut() {
        return CicsClock.create(this.data, 16, 8);
    }

    @Deprecated
    public Duration mnrFilePutTime() {
        return Util.Binary4_16_US(this.data, 16);
    }

    @Deprecated
    public double mnrFilePutTimeSeconds() {
        return Util.ToSeconds(this.mnrFilePutTime());
    }

    @Deprecated
    public long mnrFilePutTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    @Deprecated
    public int mnrFilePutFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    @Deprecated
    public int mnrFilePutCount() {
        return Util.ConvertUnsignedBinary3(this.data, 21);
    }

    public CicsClock mnrFileBrwse() {
        return CicsClock.create(this.data, 24, 8);
    }

    @Deprecated
    public Duration mnrFileBrwseTime() {
        return Util.Binary4_16_US(this.data, 24);
    }

    @Deprecated
    public double mnrFileBrwseTimeSeconds() {
        return Util.ToSeconds(this.mnrFileBrwseTime());
    }

    @Deprecated
    public long mnrFileBrwseTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    @Deprecated
    public int mnrFileBrwseFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    @Deprecated
    public int mnrFileBrwseCount() {
        return Util.ConvertUnsignedBinary3(this.data, 29);
    }

    public CicsClock mnrFileAdd() {
        return CicsClock.create(this.data, 32, 8);
    }

    @Deprecated
    public Duration mnrFileAddTime() {
        return Util.Binary4_16_US(this.data, 32);
    }

    @Deprecated
    public double mnrFileAddTimeSeconds() {
        return Util.ToSeconds(this.mnrFileAddTime());
    }

    @Deprecated
    public long mnrFileAddTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    @Deprecated
    public int mnrFileAddFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    @Deprecated
    public int mnrFileAddCount() {
        return Util.ConvertUnsignedBinary3(this.data, 37);
    }

    public CicsClock mnrFileDel() {
        return CicsClock.create(this.data, 40, 8);
    }

    @Deprecated
    public Duration mnrFileDelTime() {
        return Util.Binary4_16_US(this.data, 40);
    }

    @Deprecated
    public double mnrFileDelTimeSeconds() {
        return Util.ToSeconds(this.mnrFileDelTime());
    }

    @Deprecated
    public long mnrFileDelTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 40);
    }

    @Deprecated
    public int mnrFileDelFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    @Deprecated
    public int mnrFileDelCount() {
        return Util.ConvertUnsignedBinary3(this.data, 45);
    }

    public CicsClock mnrFileTotal() {
        return CicsClock.create(this.data, 48, 8);
    }

    @Deprecated
    public Duration mnrFileTotalTime() {
        return Util.Binary4_16_US(this.data, 48);
    }

    @Deprecated
    public double mnrFileTotalTimeSeconds() {
        return Util.ToSeconds(this.mnrFileTotalTime());
    }

    @Deprecated
    public long mnrFileTotalTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 48);
    }

    @Deprecated
    public int mnrFileTotalFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 52);
    }

    @Deprecated
    public int mnrFileTotalCount() {
        return Util.ConvertUnsignedBinary3(this.data, 53);
    }

    public long mnrFileAmRq() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public CicsClock mnrFileIoWt() {
        return CicsClock.create(this.data, 64, 8);
    }

    @Deprecated
    public Duration mnrFileIoWtTime() {
        return Util.Binary4_16_US(this.data, 64);
    }

    @Deprecated
    public double mnrFileIoWtTimeSeconds() {
        return Util.ToSeconds(this.mnrFileIoWtTime());
    }

    @Deprecated
    public long mnrFileIoWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 64);
    }

    @Deprecated
    public int mnrFileIoWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    @Deprecated
    public int mnrFileIoWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 69);
    }

    public CicsClock mnrRlsFileIoWt() {
        return CicsClock.create(this.data, 72, 8);
    }

    @Deprecated
    public Duration mnrRlsFileIoWtTime() {
        return Util.Binary4_16_US(this.data, 72);
    }

    @Deprecated
    public double mnrRlsFileIoWtTimeSeconds() {
        return Util.ToSeconds(this.mnrRlsFileIoWtTime());
    }

    @Deprecated
    public long mnrRlsFileIoWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 72);
    }

    @Deprecated
    public int mnrRlsFileIoWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 76);
    }

    @Deprecated
    public int mnrRlsFileIoWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 77);
    }

    public CicsClock mnrCfdtIoWt() {
        return CicsClock.create(this.data, 80, 8);
    }

    @Deprecated
    public Duration mnrCfdtIoWtTime() {
        return Util.Binary4_16_US(this.data, 80);
    }

    @Deprecated
    public double mnrCfdtIoWtTimeSeconds() {
        return Util.ToSeconds(this.mnrCfdtIoWtTime());
    }

    @Deprecated
    public long mnrCfdtIoWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 80);
    }

    @Deprecated
    public int mnrCfdtIoWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    @Deprecated
    public int mnrCfdtIoWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 85);
    }

    public CicsClock mnrFileXcWt() {
        return CicsClock.create(this.data, 88, 8);
    }

    @Deprecated
    public Duration mnrFileXcWtTime() {
        return Util.Binary4_16_US(this.data, 88);
    }

    @Deprecated
    public double mnrFileXcWtTimeSeconds() {
        return Util.ToSeconds(this.mnrFileXcWtTime());
    }

    @Deprecated
    public long mnrFileXcWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 88);
    }

    @Deprecated
    public int mnrFileXcWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 92);
    }

    @Deprecated
    public int mnrFileXcWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 93);
    }

    public CicsClock mnrFileVsWt() {
        return CicsClock.create(this.data, 96, 8);
    }

    @Deprecated
    public Duration mnrFileVsWtTime() {
        return Util.Binary4_16_US(this.data, 96);
    }

    @Deprecated
    public double mnrFileVsWtTimeSeconds() {
        return Util.ToSeconds(this.mnrFileVsWtTime());
    }

    @Deprecated
    public long mnrFileVsWtTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 96);
    }

    @Deprecated
    public int mnrFileVsWtFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 100);
    }

    @Deprecated
    public int mnrFileVsWtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 101);
    }

    public static MnrFileEntry create(byte[] Data2, int offset, int length) {
        return new MnrFileEntry(Data2, offset, length);
    }

    static enum Field {
        mnrFileName(0, 8),
        mnrFileGet(8, 8),
        mnrFilePut(16, 8),
        mnrFileBrwse(24, 8),
        mnrFileAdd(32, 8),
        mnrFileDel(40, 8),
        mnrFileTotal(48, 8),
        mnrFileAmRq(56, 4),
        mnrFileIoWt(64, 8),
        mnrRlsFileIoWt(72, 8),
        mnrCfdtIoWt(80, 8),
        mnrFileXcWt(88, 8),
        mnrFileVsWt(96, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

