/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class MnrUriMapEntry
extends SmfData {
    private MnrUriMapEntry(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public String mnrUrimapName() {
        return Util.ConvertEbcdic(this.data, 0, 8);
    }

    public long mnrUrimapCipher() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long mnrUrimapFlag() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public CicsClock mnrUrimapWebopen() {
        return CicsClock.create(this.data, 16, 8);
    }

    @Deprecated
    public Duration mnrUrimapWebopenTime() {
        return Util.Binary4_16_US(this.data, 16);
    }

    @Deprecated
    public double mnrUrimapWebopenTimeSeconds() {
        return Util.ToSeconds(this.mnrUrimapWebopenTime());
    }

    @Deprecated
    public long mnrUrimapWebopenTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 16);
    }

    @Deprecated
    public int mnrUrimapWebopenFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 20);
    }

    @Deprecated
    public int mnrUrimapWebopenCount() {
        return Util.ConvertUnsignedBinary3(this.data, 21);
    }

    public CicsClock mnrUrimapWebrecv() {
        return CicsClock.create(this.data, 24, 8);
    }

    @Deprecated
    public Duration mnrUrimapWebrecvTime() {
        return Util.Binary4_16_US(this.data, 24);
    }

    @Deprecated
    public double mnrUrimapWebrecvTimeSeconds() {
        return Util.ToSeconds(this.mnrUrimapWebrecvTime());
    }

    @Deprecated
    public long mnrUrimapWebrecvTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 24);
    }

    @Deprecated
    public int mnrUrimapWebrecvFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    @Deprecated
    public int mnrUrimapWebrecvCount() {
        return Util.ConvertUnsignedBinary3(this.data, 29);
    }

    public CicsClock mnrUrimapWebsend() {
        return CicsClock.create(this.data, 32, 8);
    }

    @Deprecated
    public Duration mnrUrimapWebsendTime() {
        return Util.Binary4_16_US(this.data, 32);
    }

    @Deprecated
    public double mnrUrimapWebsendTimeSeconds() {
        return Util.ToSeconds(this.mnrUrimapWebsendTime());
    }

    @Deprecated
    public long mnrUrimapWebsendTimeRawValue() {
        return Util.ConvertSignedBinary4(this.data, 32);
    }

    @Deprecated
    public int mnrUrimapWebsendFlags() {
        return Util.ConvertUnsignedBinary1(this.data, 36);
    }

    @Deprecated
    public int mnrUrimapWebsendCount() {
        return Util.ConvertUnsignedBinary3(this.data, 37);
    }

    public String mnrUrimapTlsLvl() {
        return Util.ConvertEbcdic(this.data, 40, 8);
    }

    public static MnrUriMapEntry create(byte[] Data2, int offset, int length) {
        return new MnrUriMapEntry(Data2, offset, length);
    }

    static enum Field {
        mnrUrimapName(0, 8),
        mnrUrimapCipher(8, 4),
        mnrUrimapFlag(12, 4),
        mnrUrimapWebopen(16, 8),
        mnrUrimapWebrecv(24, 8),
        mnrUrimapWebsend(32, 8),
        mnrUrimapTlsLvl(40, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

