/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.monitoring;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.CicsInstanceId;
import com.blackhillsoftware.smf.cics.MnHeader;
import com.blackhillsoftware.smf.cics.MnProductSection;
import com.blackhillsoftware.smf.cics.monitoring.Cics;
import com.blackhillsoftware.smf.cics.monitoring.CicsClock;
import com.blackhillsoftware.smf.cics.monitoring.Dictionary;
import com.blackhillsoftware.smf.cics.monitoring.DictionaryEntry;
import com.blackhillsoftware.smf.cics.monitoring.fields.ByteStringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.ClockField;
import com.blackhillsoftware.smf.cics.monitoring.fields.CountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.Field;
import com.blackhillsoftware.smf.cics.monitoring.fields.MonitoringField;
import com.blackhillsoftware.smf.cics.monitoring.fields.MultiCountField;
import com.blackhillsoftware.smf.cics.monitoring.fields.PackedField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TimestampField;
import com.blackhillsoftware.smf.cics.monitoring.fields.TrannumField;
import com.blackhillsoftware.smf.internal.Packed;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public final class PerformanceRecord
extends SmfData {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private Dictionary dictionary;
    private CicsInstanceId cicsInstance;
    private MnProductSection mnProductSection;
    private MnHeader mnHeader;

    private PerformanceRecord(byte[] Data2, int offset, int length, CicsInstanceId cicsInstance, Dictionary dictionary, MnProductSection mnProductSection, MnHeader mnHeader) {
        super(Data2, offset, length);
        this.dictionary = dictionary;
        this.cicsInstance = cicsInstance;
        this.mnProductSection = mnProductSection;
        this.mnHeader = mnHeader;
    }

    public static PerformanceRecord create(byte[] Data2, int offset, int length, CicsInstanceId cicsInstance, Dictionary dictionary, MnProductSection mnProductSection, MnHeader mnHeader) {
        return new PerformanceRecord(Data2, offset, length, cicsInstance, dictionary, mnProductSection, mnHeader);
    }

    public String smfmnsid() {
        return this.mnHeader.smfmnsid();
    }

    public String smfmnprn() {
        return this.mnProductSection.smfmnprn();
    }

    public String smfmnspn() {
        return this.mnProductSection.smfmnspn();
    }

    public String smfmnjbn() {
        return this.mnProductSection.smfmnjbn();
    }

    public ZoneOffset smfmndto() {
        return this.mnProductSection.smfmndto();
    }

    public boolean haveEntry(MonitoringField field) {
        if (field == null) {
            return false;
        }
        return this.dictionary != null && this.dictionary.haveEntry(field);
    }

    public boolean isZero(MonitoringField field) {
        Objects.requireNonNull(field);
        byte[] data = this.getFieldBytes(field);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isZero(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        byte[] data = this.getFieldBytes(dictionaryEntry);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public Object getField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (dictionaryEntry.getFieldId() == null) {
            throw new IllegalArgumentException("Field type not implemented: " + dictionaryEntry.cmodtype());
        }
        if (dictionaryEntry.getFieldId() instanceof CountField) {
            return this.getCountFieldAsBigInteger(dictionaryEntry);
        }
        if (dictionaryEntry.getFieldId() instanceof ByteStringField) {
            return this.getFieldAsString(dictionaryEntry);
        }
        if (dictionaryEntry.getFieldId() instanceof ClockField) {
            return this.getClockField(dictionaryEntry);
        }
        if (dictionaryEntry.getFieldId() instanceof TrannumField) {
            return this.getTrannumField(dictionaryEntry);
        }
        if (dictionaryEntry.getFieldId() instanceof PackedField) {
            if (this.isValidPacked(dictionaryEntry)) {
                return this.getPackedFieldAsBigInteger(dictionaryEntry);
            }
            return this.getFieldAsString(dictionaryEntry);
        }
        if (dictionaryEntry.getFieldId() instanceof TimestampField) {
            return this.getTimestampField(dictionaryEntry);
        }
        if (dictionaryEntry.getFieldId() instanceof MultiCountField) {
            return this.getMultiCountFieldAsBigInteger(dictionaryEntry);
        }
        throw new IllegalArgumentException("Field type not implemented: " + dictionaryEntry.getFieldId().getClass().toString());
    }

    private void checkField(DictionaryEntry dictionaryEntry) {
        if (this.data.length < dictionaryEntry.cmodofst() + dictionaryEntry.cmodleng()) {
            throw new NotAvailableException("Field is outside the bounds of the data." + System.lineSeparator() + "Field offset: " + Integer.toString(dictionaryEntry.cmodofst()) + " Data length: " + Integer.toString(this.data.length) + ", Field: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.cmodname() + ", CICS Instance: " + this.cicsInstance.toString());
        }
    }

    public Object getField(MonitoringField field) {
        Objects.requireNonNull(field);
        return this.getField(this.dictionary.getEntry(field));
    }

    public Duration elapsed() {
        if (this.haveEntry(Field.START) && this.haveEntry(Field.STOP)) {
            return Duration.between(this.getField(Field.START), this.getField(Field.STOP));
        }
        return null;
    }

    public double elapsedSeconds() {
        Duration elapsed = this.elapsed();
        if (elapsed == null) {
            return 0.0;
        }
        double nanos = elapsed.toNanos();
        return nanos / 1.0E9;
    }

    public long getField(CountField field) {
        Objects.requireNonNull(field);
        DictionaryEntry dictionaryEntry = this.dictionary.getEntry(field);
        switch (dictionaryEntry.cmodleng()) {
            case 2: {
                return this.getCountField2(dictionaryEntry);
            }
            case 4: {
                return this.getCountField4(dictionaryEntry);
            }
            case 8: {
                return this.getCountField8(dictionaryEntry);
            }
        }
        throw new IllegalArgumentException("Unexpected field length: " + Integer.toString(dictionaryEntry.cmodleng()) + " for " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
    }

    public long getCountField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof CountField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a CountField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        switch (dictionaryEntry.cmodleng()) {
            case 2: {
                return Util.ConvertUnsignedBinary2(this.data, dictionaryEntry.cmodofst());
            }
            case 4: {
                return Util.ConvertUnsignedBinary4(this.data, dictionaryEntry.cmodofst());
            }
            case 8: {
                try {
                    return Util.ConvertUnsignedBinary8(this.data, dictionaryEntry.cmodofst());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
                }
            }
        }
        throw new IllegalArgumentException("Unexpected field length: " + dictionaryEntry.cmodleng() + "for " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
    }

    @Deprecated
    public long getCountField2(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        return Util.ConvertUnsignedBinary2(this.data, dictionaryEntry.cmodofst());
    }

    @Deprecated
    public long getCountField4(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        return Util.ConvertUnsignedBinary4(this.data, dictionaryEntry.cmodofst());
    }

    @Deprecated
    public long getCountField8(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        try {
            return Util.ConvertUnsignedBinary8(this.data, dictionaryEntry.cmodofst());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
        }
    }

    public BigInteger getFieldAsBigInteger(CountField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getCountFieldAsBigInteger(entry);
    }

    public BigInteger getCountFieldAsBigInteger(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof CountField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a CountField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        if (dictionaryEntry.cmodleng() == 2) {
            return Util.ConvertUnsignedBinary2BigInteger(this.data, dictionaryEntry.cmodofst());
        }
        if (dictionaryEntry.cmodleng() == 4) {
            return Util.ConvertUnsignedBinary4BigInteger(this.data, dictionaryEntry.cmodofst());
        }
        if (dictionaryEntry.cmodleng() == 8) {
            try {
                return Util.ConvertUnsignedBinary8BigInteger(this.data, dictionaryEntry.cmodofst());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
            }
        }
        throw new IllegalArgumentException("Unexpected field length: " + dictionaryEntry.cmodleng() + " for " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
    }

    public long[] getField(MultiCountField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getMultiCountField(entry);
    }

    public long[] getMultiCountField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof MultiCountField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a MultiCountField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        int length = 8;
        int count = dictionaryEntry.cmodleng() / length;
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            try {
                result[i] = Util.ConvertUnsignedBinary8(this.data, dictionaryEntry.cmodofst() + i * length);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
            }
        }
        return result;
    }

    public List<BigInteger> getFieldAsBigInteger(MultiCountField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getMultiCountFieldAsBigInteger(entry);
    }

    public List<BigInteger> getMultiCountFieldAsBigInteger(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof MultiCountField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a MultiCountField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        int length = 8;
        int count = dictionaryEntry.cmodleng() / length;
        ArrayList<BigInteger> result = new ArrayList<BigInteger>(count);
        for (int i = 0; i < count; ++i) {
            try {
                result.add(Util.ConvertUnsignedBinary8BigInteger(this.data, dictionaryEntry.cmodofst() + i * length));
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
            }
        }
        return result;
    }

    public String getField(ByteStringField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getFieldAsString(entry);
    }

    public String getByteStringField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof ByteStringField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a ByteStringField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        return this.getFieldAsString(dictionaryEntry);
    }

    public boolean isValidPacked(PackedField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.isValidPacked(entry);
    }

    public boolean isValidPacked(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof PackedField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a PackedField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        return Packed.isValid(this.data, dictionaryEntry.cmodofst(), dictionaryEntry.cmodleng());
    }

    public long getField(PackedField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getPackedField(entry);
    }

    public long getPackedField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof PackedField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a PackedField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        try {
            return Util.ConvertPackedLong(this.data, dictionaryEntry.cmodofst(), dictionaryEntry.cmodleng());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
        }
    }

    public BigInteger getFieldAsBigInteger(PackedField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getPackedFieldAsBigInteger(entry);
    }

    public BigInteger getPackedFieldAsBigInteger(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof PackedField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a PackedField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        try {
            return Util.ConvertPackedBigInteger(this.data, dictionaryEntry.cmodofst(), dictionaryEntry.cmodleng());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
        }
    }

    public Object getField(TrannumField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getTrannumField(entry);
    }

    public Object getTrannumField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof TrannumField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a TrannumField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        try {
            return Cics.transactionId(this.data, dictionaryEntry.cmodofst(), dictionaryEntry.cmodleng());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString(), e);
        }
    }

    public String getFieldAsString(MonitoringField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getFieldAsString(entry);
    }

    public String getFieldAsString(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        return Util.ConvertEbcdic(this.data, dictionaryEntry.cmodofst(), dictionaryEntry.cmodleng());
    }

    public byte[] getFieldBytes(MonitoringField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getFieldBytes(entry);
    }

    public byte[] getFieldBytes(DictionaryEntry dictionaryEntry) {
        this.checkField(dictionaryEntry);
        byte[] result = new byte[dictionaryEntry.cmodleng()];
        System.arraycopy(this.data, dictionaryEntry.cmodofst(), result, 0, dictionaryEntry.cmodleng());
        return result;
    }

    public String getFieldAsHex(MonitoringField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getFieldAsHex(entry);
    }

    public String getFieldAsHex(DictionaryEntry dictionaryEntry) {
        this.checkField(dictionaryEntry);
        int offset = dictionaryEntry.cmodofst();
        int length = dictionaryEntry.cmodleng();
        char[] out = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int hi = this.data[offset + i] >> 4 & 0xF;
            int lo = this.data[offset + i] & 0xF;
            out[i * 2] = hex[hi];
            out[i * 2 + 1] = hex[lo];
        }
        String newResult = new String(out);
        return newResult;
    }

    public ZonedDateTime getField(TimestampField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getTimestampField(entry);
    }

    public ZonedDateTime getTimestampField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof TimestampField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a TimestampField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        return Util.Binary8xStckTime(this.data, dictionaryEntry.cmodofst());
    }

    public CicsClock getField(ClockField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getClockField(entry);
    }

    public CicsClock getClockField(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        if (!(dictionaryEntry.getFieldId() instanceof ClockField)) {
            throw new IllegalArgumentException("Dictionary Entry is not a ClockField: " + dictionaryEntry.cmodhead() + " " + dictionaryEntry.entryId() + " CICS Instance " + this.cicsInstance.toString());
        }
        this.checkField(dictionaryEntry);
        return CicsClock.create(this.data, dictionaryEntry.cmodofst(), dictionaryEntry.cmodleng());
    }

    @Deprecated
    public Duration getFieldTimer(ClockField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getClockFieldTimer(entry);
    }

    @Deprecated
    public Duration getClockFieldTimer(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        return Util.Binary8StckInterval(this.data, dictionaryEntry.cmodofst());
    }

    @Deprecated
    public double getFieldTimerSeconds(ClockField field) {
        Objects.requireNonNull(field);
        return Util.ToSeconds(this.getFieldTimer(field));
    }

    @Deprecated
    public double getFieldTimerSeconds(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        return Util.ToSeconds(this.getClockFieldTimer(dictionaryEntry));
    }

    @Deprecated
    public int getFieldFlags(ClockField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getClockFieldFlags(entry);
    }

    @Deprecated
    public int getClockFieldFlags(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        return Util.ConvertUnsignedBinary1(this.data, dictionaryEntry.cmodofst() + 8);
    }

    @Deprecated
    public int getFieldPeriodCount(ClockField field) {
        Objects.requireNonNull(field);
        DictionaryEntry entry = this.dictionary.getEntry(field);
        return this.getClockFieldPeriodCount(entry);
    }

    @Deprecated
    public int getClockFieldPeriodCount(DictionaryEntry dictionaryEntry) {
        Objects.requireNonNull(dictionaryEntry);
        this.checkField(dictionaryEntry);
        return Util.ConvertUnsignedBinary3(this.data, dictionaryEntry.cmodofst() + 9);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public CicsInstanceId getCicsInstanceId() {
        return this.cicsInstance;
    }

    @Override
    public String toString() {
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        entries.put("smfmnsid", this.smfmnsid());
        entries.put("smfmnjbn", this.smfmnjbn());
        entries.put("smfmnprn", this.smfmnprn());
        entries.put("smfmnspn", this.smfmnspn());
        entries.put("smfmndto", this.smfmndto().toString());
        if (this.dictionary != null) {
            entries.put("TRAN", this.getField(Field.TRAN));
            ZonedDateTime start = this.getField(Field.START);
            ZonedDateTime stop = this.getField(Field.STOP);
            entries.put("START", start.toString());
            entries.put("STOP", stop.toString());
            entries.put("Elapsed", Duration.between(start, stop).toString());
            block25: for (DictionaryEntry entry : this.dictionary.entries()) {
                switch (entry.cmodhead()) {
                    case "TRAN": 
                    case "START": 
                    case "STOP": 
                    case "OMEGBSC": 
                    case "OMEGDB2": 
                    case "CANWLMSC": {
                        continue block25;
                    }
                    case "RTYPE": {
                        entries.put(entry.cmodhead(), this.getFieldAsString(entry).substring(3));
                        break;
                    }
                    case "TERMINFO": 
                    case "TRANFLAG": 
                    case "OTRANFLG": 
                    case "TASKFLAG": 
                    case "NETUOWSX": 
                    case "TRNGRPID": {
                        if (this.isZero(entry)) continue block25;
                        entries.put(entry.cmodhead(), this.getFieldAsHex(entry));
                        break;
                    }
                    case "TRANNUM": 
                    case "OTRANNUM": 
                    case "PTTRANNO": 
                    case "PHTRANNO": {
                        if (this.isValidPacked(entry)) {
                            long value = this.getPackedField(entry);
                            if (value == 0L) continue block25;
                            entries.put(entry.cmodhead(), Long.toString(value));
                            break;
                        }
                        byte first = this.getFieldBytes(entry)[0];
                        if (first == 64 || first == 0) {
                            String fieldAsString = this.getFieldAsString(entry);
                            if (fieldAsString.length() > 1) {
                                fieldAsString = fieldAsString.substring(1);
                            }
                            if (fieldAsString.trim().length() <= 0) continue block25;
                            entries.put(entry.cmodhead(), fieldAsString);
                            break;
                        }
                        String value = this.getFieldAsString(entry);
                        if (value.length() <= 0) continue block25;
                        entries.put(entry.cmodhead(), value);
                        break;
                    }
                    default: {
                        Object value = this.getField(entry);
                        if (value instanceof CicsClock) {
                            if ((value = ((CicsClock)value).timer()).equals(Duration.ZERO)) {
                                value = null;
                            }
                        } else if (value instanceof Number) {
                            if (((Number)value).doubleValue() == 0.0) {
                                value = null;
                            }
                        } else if (value instanceof String) {
                            value = ((String)value).length() == 0 ? null : "\"" + value + "\"";
                        }
                        if (value == null || entries.putIfAbsent(entry.cmodhead(), value.toString()) == null) continue block25;
                        entries.put(entry.cmodhead() + ":" + entry.entryId(), value.toString());
                    }
                }
            }
        } else {
            entries.put("Information", "No Dictionary");
        }
        return ((Object)entries).toString();
    }
}

