/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.EccCapturePointType;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;

public final class CapturespecResourceStatistics
extends StatisticsDataSection {
    public static final int ECCDS_LENGTH = 156;
    public static final int ECCIDE = 143;
    public static final int ECC_VERS = 1;

    private CapturespecResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int eccdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int eccdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public String eccEventbindingName() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public String eccCapturespecName() {
        return Util.ConvertEbcdic(this.data, 40, 32);
    }

    public EccCapturePointType eccCapturePointType() {
        int value = Util.ConvertUnsignedBinary2(this.data, 72);
        return EccCapturePointType.from(value);
    }

    public int eccCapturePointTypeRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 72);
    }

    public String eccCapturePoint() {
        return Util.ConvertEbcdic(this.data, 74, 25);
    }

    public String eccEventName() {
        return Util.ConvertEbcdic(this.data, 100, 32);
    }

    public long eccEventsCaptured() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger eccEventsCapturedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long eccCaptureFailures() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public static CapturespecResourceStatistics create(byte[] Data2, int offset, int length) {
        return new CapturespecResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        eccdsLen(0, 2),
        eccdsId(2, 2),
        eccEventbindingName(8, 32),
        eccCapturespecName(40, 32),
        eccCapturePointType(72, 2),
        eccCapturePoint(74, 25),
        eccEventName(100, 32),
        eccEventsCaptured(136, 8),
        eccCaptureFailures(144, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

