/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.D2gPoolAccountrec;
import com.blackhillsoftware.smf.cics.statistics.values.D2gPoolAuthtype;
import com.blackhillsoftware.smf.cics.statistics.values.D2gPoolPriority;
import com.blackhillsoftware.smf.cics.statistics.values.D2gResyncMember;
import com.blackhillsoftware.smf.cics.statistics.values.Threadwait;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class Db2GlobalStatistics
extends StatisticsDataSection {
    public static final int D2GIDE = 102;
    public static final int D2GVERS = 1;
    public static final int D2G_LENGTH = 364;

    private Db2GlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int d2glen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int d2gid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int d2gdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String d2gDb2connName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String d2gDb2Id() {
        return Util.ConvertEbcdic(this.data, 16, 4);
    }

    public String d2gDb2Release() {
        return Util.ConvertEbcdic(this.data, 20, 4);
    }

    public ZonedDateTime d2gConnectTimeGmt() {
        return Util.Binary8xStckTime(this.data, 24);
    }

    public BigInteger d2gConnectTimeGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 24);
    }

    public LocalDateTime d2gConnectTimeLocal() {
        return Util.Binary8xStckLocalTime(this.data, 32);
    }

    public BigInteger d2gConnectTimeLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 32);
    }

    public ZonedDateTime d2gDisconnectTimeGmt() {
        return Util.Binary8xStckTime(this.data, 40);
    }

    public BigInteger d2gDisconnectTimeGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 40);
    }

    public LocalDateTime d2gDisconnectTimeLocal() {
        return Util.Binary8xStckLocalTime(this.data, 48);
    }

    public BigInteger d2gDisconnectTimeLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 48);
    }

    public long d2gTcbLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long d2gTcbCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long d2gTcbHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long d2gTcbFree() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long d2gTcbReadyqCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long d2gTcbReadyqHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public String d2gDb2GroupId() {
        return Util.ConvertEbcdic(this.data, 80, 4);
    }

    public D2gResyncMember d2gResyncmember() {
        int value = Util.ConvertUnsignedBinary1(this.data, 84);
        return D2gResyncMember.from(value);
    }

    public int d2gResyncmemberRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 84);
    }

    public long d2gReuselimit() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long d2gTcbProtectedCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public String d2gPoolPlanName() {
        return Util.ConvertEbcdic(this.data, 120, 8);
    }

    public String d2gPoolPlanexitName() {
        return Util.ConvertEbcdic(this.data, 128, 8);
    }

    public String d2gPoolAuthid() {
        return Util.ConvertEbcdic(this.data, 136, 8);
    }

    public D2gPoolAuthtype d2gPoolAuthtype() {
        int value = Util.ConvertUnsignedBinary1(this.data, 144);
        return D2gPoolAuthtype.from(value);
    }

    public int d2gPoolAuthtypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 144);
    }

    public D2gPoolAccountrec d2gPoolAccountrec() {
        int value = Util.ConvertUnsignedBinary1(this.data, 145);
        return D2gPoolAccountrec.from(value);
    }

    public int d2gPoolAccountrecRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 145);
    }

    public Threadwait d2gPoolThreadwait() {
        int value = Util.ConvertUnsignedBinary1(this.data, 146);
        return Threadwait.from(value);
    }

    public int d2gPoolThreadwaitRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 146);
    }

    public D2gPoolPriority d2gPoolPriority() {
        int value = Util.ConvertUnsignedBinary1(this.data, 147);
        return D2gPoolPriority.from(value);
    }

    public int d2gPoolPriorityRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 147);
    }

    public long d2gPoolCalls() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public long d2gPoolSignons() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long d2gPoolCommits() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long d2gPoolAborts() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long d2gPoolSinglePhase() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long d2gPoolThreadReuse() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long d2gPoolThreadTerm() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public long d2gPoolThreadWaits() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long d2gPoolThreadLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long d2gPoolThreadCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long d2gPoolThreadHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long d2gPoolTaskCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long d2gPoolTaskHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long d2gPoolTaskTotal() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long d2gPoolReadyqCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long d2gPoolReadyqHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public long d2gPoolPartialSignons() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long d2gPoolThreadCreate() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public long d2gPoolReuselimitCount() {
        return Util.ConvertUnsignedBinary4(this.data, 220);
    }

    public String d2gComdAuthid() {
        return Util.ConvertEbcdic(this.data, 240, 8);
    }

    public int d2gComdAuthtype() {
        return Util.ConvertUnsignedBinary1(this.data, 248);
    }

    public long d2gComdCalls() {
        return Util.ConvertUnsignedBinary4(this.data, 252);
    }

    public long d2gComdSignons() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long d2gComdThreadTerm() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long d2gComdThreadOverf() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long d2gComdThreadLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 268);
    }

    public long d2gComdThreadCurrent() {
        return Util.ConvertUnsignedBinary4(this.data, 272);
    }

    public long d2gComdThreadHwm() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public long d2gComdThreadCreate() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public String d2gDb2connDefineSource() {
        return Util.ConvertEbcdic(this.data, 316, 8);
    }

    public LocalDateTime d2gDb2connChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 324);
    }

    public BigInteger d2gDb2connChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 324);
    }

    public String d2gDb2connChangeUserid() {
        return Util.ConvertEbcdic(this.data, 332, 8);
    }

    public CIAgent d2gDb2connChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 340);
        return CIAgent.from(value);
    }

    public int d2gDb2connChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 340);
    }

    public CIAgent d2gDb2connInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 342);
        return CIAgent.from(value);
    }

    public int d2gDb2connInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 342);
    }

    public LocalDateTime d2gDb2connInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 344);
    }

    public BigInteger d2gDb2connInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 344);
    }

    public String d2gDb2connInstallUserid() {
        return Util.ConvertEbcdic(this.data, 352, 8);
    }

    public static Db2GlobalStatistics create(byte[] Data2, int offset, int length) {
        return new Db2GlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        d2glen(0, 2),
        d2gid(2, 2),
        d2gdvers(4, 1),
        d2gDb2connName(8, 8),
        d2gDb2Id(16, 4),
        d2gDb2Release(20, 4),
        d2gConnectTimeGmt(24, 8),
        d2gConnectTimeLocal(32, 8),
        d2gDisconnectTimeGmt(40, 8),
        d2gDisconnectTimeLocal(48, 8),
        d2gTcbLimit(56, 4),
        d2gTcbCurrent(60, 4),
        d2gTcbHwm(64, 4),
        d2gTcbFree(68, 4),
        d2gTcbReadyqCurrent(72, 4),
        d2gTcbReadyqHwm(76, 4),
        d2gDb2GroupId(80, 4),
        d2gResyncmember(84, 1),
        d2gReuselimit(88, 4),
        d2gTcbProtectedCurrent(92, 4),
        d2gPoolPlanName(120, 8),
        d2gPoolPlanexitName(128, 8),
        d2gPoolAuthid(136, 8),
        d2gPoolAuthtype(144, 1),
        d2gPoolAccountrec(145, 1),
        d2gPoolThreadwait(146, 1),
        d2gPoolPriority(147, 1),
        d2gPoolCalls(148, 4),
        d2gPoolSignons(152, 4),
        d2gPoolCommits(156, 4),
        d2gPoolAborts(160, 4),
        d2gPoolSinglePhase(164, 4),
        d2gPoolThreadReuse(168, 4),
        d2gPoolThreadTerm(172, 4),
        d2gPoolThreadWaits(176, 4),
        d2gPoolThreadLimit(180, 4),
        d2gPoolThreadCurrent(184, 4),
        d2gPoolThreadHwm(188, 4),
        d2gPoolTaskCurrent(192, 4),
        d2gPoolTaskHwm(196, 4),
        d2gPoolTaskTotal(200, 4),
        d2gPoolReadyqCurrent(204, 4),
        d2gPoolReadyqHwm(208, 4),
        d2gPoolPartialSignons(212, 4),
        d2gPoolThreadCreate(216, 4),
        d2gPoolReuselimitCount(220, 4),
        d2gComdAuthid(240, 8),
        d2gComdAuthtype(248, 1),
        d2gComdCalls(252, 4),
        d2gComdSignons(256, 4),
        d2gComdThreadTerm(260, 4),
        d2gComdThreadOverf(264, 4),
        d2gComdThreadLimit(268, 4),
        d2gComdThreadCurrent(272, 4),
        d2gComdThreadHwm(276, 4),
        d2gComdThreadCreate(280, 4),
        d2gDb2connDefineSource(316, 8),
        d2gDb2connChangeTime(324, 8),
        d2gDb2connChangeUserid(332, 8),
        d2gDb2connChangeAgent(340, 2),
        d2gDb2connInstallAgent(342, 2),
        d2gDb2connInstallTime(344, 8),
        d2gDb2connInstallUserid(352, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

