/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.DispatcherTcbModeStatistics;
import com.blackhillsoftware.smf.cics.statistics.DispatcherTcbPoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DispatcherGlobalStatistics
extends StatisticsDataSection {
    public static final int DSGIDE = 62;
    public static final int DSGVERS = 1;
    public static final int DSGMCLEN = 160;
    public static final int DSGMAXNUMMODES = 18;
    public static final int DSGMAXNUMPOOLS = 4;

    protected DispatcherGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public List<DispatcherTcbModeStatistics> tcbModeStatistics() {
        int datastart = this.dsgglen();
        int count = this.dsgasize();
        ArrayList<DispatcherTcbModeStatistics> result = new ArrayList<DispatcherTcbModeStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(DispatcherTcbModeStatistics.create(this.data, datastart + i * 160, 160));
        }
        return Collections.unmodifiableList(result);
    }

    public List<DispatcherTcbPoolStatistics> tcbPoolStatistics() {
        int datastart = this.dsgglen() + this.dsgasize() * 160;
        int count = this.dsgpsize();
        ArrayList<DispatcherTcbPoolStatistics> result = new ArrayList<DispatcherTcbPoolStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(DispatcherTcbPoolStatistics.create(this.data, datastart + i * 160, 160));
        }
        return Collections.unmodifiableList(result);
    }

    public int dsglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int dsgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int dsgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int dsgglen() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    public int dsgasize() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    public int dsgpsize() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    public Duration dsgicvt() {
        return Util.Binary4MS(this.data, 16);
    }

    public double dsgicvtSeconds() {
        return Util.ToSeconds(this.dsgicvt());
    }

    public long dsgicvtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public Duration dsgicvrt() {
        return Util.Binary4MS(this.data, 20);
    }

    public double dsgicvrtSeconds() {
        return Util.ToSeconds(this.dsgicvrt());
    }

    public long dsgicvrtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public Duration dsgicvsd() {
        return Util.Binary4MS(this.data, 24);
    }

    public double dsgicvsdSeconds() {
        return Util.ToSeconds(this.dsgicvsd());
    }

    public long dsgicvsdRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int dsgpriag() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    public int dsgstsks() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    public int dsgmbtch() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    public int dsgcnt() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    public int dsgpnt() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    public ZonedDateTime dsgstart() {
        return Util.Binary8xStckTime(this.data, 56);
    }

    public BigInteger dsgstartRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    public LocalDateTime dsglstrt() {
        return Util.Binary8xStckLocalTime(this.data, 64);
    }

    public BigInteger dsglstrtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    public Duration dsgejst() {
        return Util.Binary8StckInterval(this.data, 72);
    }

    public double dsgejstSeconds() {
        return Util.ToSeconds(this.dsgejst());
    }

    public long dsgejstRawValue() {
        return Util.ConvertSignedBinary8(this.data, 72);
    }

    public Duration dsgsrbt() {
        return Util.Binary8StckInterval(this.data, 80);
    }

    public double dsgsrbtSeconds() {
        return Util.ToSeconds(this.dsgsrbt());
    }

    public long dsgsrbtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 80);
    }

    public long dsgxscns() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long dsgxscnn() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long dsgxtcbd() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public ZonedDateTime dsggxscn() {
        return Util.Binary8xStckTime(this.data, 120);
    }

    public BigInteger dsggxscnRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public LocalDateTime dsglxscn() {
        return Util.Binary8xStckLocalTime(this.data, 128);
    }

    public BigInteger dsglxscnRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public ZonedDateTime dsggxsnd() {
        return Util.Binary8xStckTime(this.data, 136);
    }

    public BigInteger dsggxsndRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public LocalDateTime dsglxsnd() {
        return Util.Binary8xStckLocalTime(this.data, 144);
    }

    public BigInteger dsglxsndRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 144);
    }

    public static DispatcherGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        dsglen(0, 2),
        dsgid(2, 2),
        dsgdvers(4, 1),
        dsgglen(8, 2),
        dsgasize(10, 2),
        dsgpsize(12, 2),
        dsgicvt(16, 4),
        dsgicvrt(20, 4),
        dsgicvsd(24, 4),
        dsgpriag(26, 2),
        dsgstsks(28, 2),
        dsgmbtch(30, 2),
        dsgcnt(36, 2),
        dsgpnt(38, 2),
        dsgstart(56, 8),
        dsglstrt(64, 8),
        dsgejst(72, 8),
        dsgsrbt(80, 8),
        dsgxscns(104, 4),
        dsgxscnn(108, 4),
        dsgxtcbd(112, 4),
        dsggxscn(120, 8),
        dsglxscn(128, 8),
        dsggxsnd(136, 8),
        dsglxsnd(144, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

