/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class DispatcherMvsTcbGlobalStatistics
extends StatisticsDataSection {
    public static final int DSTIDR = 64;
    public static final int DSTVERS = 1;
    public static final int DSTDS_LENGTH = 80;

    private DispatcherMvsTcbGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int dstdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int dstdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int dstdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long dstdsCicstcbCount() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public Duration dstdsCicstcbCputime() {
        return Util.Binary8StckInterval(this.data, 12);
    }

    public double dstdsCicstcbCputimeSeconds() {
        return Util.ToSeconds(this.dstdsCicstcbCputime());
    }

    public long dstdsCicstcbCputimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 12);
    }

    public long dstdsCicstcbStgBelow() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long dstdsCicstcbStgAbove() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long dstdsNoncicstcbCount() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public Duration dstdsNoncicstcbCputime() {
        return Util.Binary8StckInterval(this.data, 32);
    }

    public double dstdsNoncicstcbCputimeSeconds() {
        return Util.ToSeconds(this.dstdsNoncicstcbCputime());
    }

    public long dstdsNoncicstcbCputimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 32);
    }

    public long dstdsNoncicstcbStgBelow() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long dstdsNoncicstcbStgAbove() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long dstdsCicstcbStgBelowInuse() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long dstdsCicstcbStgAboveInuse() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long dstdsNoncicstcbStgBelowInuse() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long dstdsNoncicstcbStgAboveInuse() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public static DispatcherMvsTcbGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherMvsTcbGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        dstdsLen(0, 2),
        dstdsId(2, 2),
        dstdsVers(4, 1),
        dstdsCicstcbCount(8, 4),
        dstdsCicstcbCputime(12, 8),
        dstdsCicstcbStgBelow(20, 4),
        dstdsCicstcbStgAbove(24, 4),
        dstdsNoncicstcbCount(28, 4),
        dstdsNoncicstcbCputime(32, 8),
        dstdsNoncicstcbStgBelow(40, 4),
        dstdsNoncicstcbStgAbove(44, 4),
        dstdsCicstcbStgBelowInuse(48, 4),
        dstdsCicstcbStgAboveInuse(52, 4),
        dstdsNoncicstcbStgBelowInuse(56, 4),
        dstdsNoncicstcbStgAboveInuse(60, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

