/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class DispatcherMvsTcbResourceStatistics
extends StatisticsDataSection {
    public static final int DSRIDR = 65;
    public static final int DSRVERS = 1;
    public static final int DSRDS_LENGTH = 80;

    private DispatcherMvsTcbResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int dsrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int dsrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int dsrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long dsrdsTcbAddress() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public String dsrdsTcbName() {
        return Util.ConvertEbcdic(this.data, 12, 8);
    }

    public String dsrdsTcbType() {
        return Util.ConvertEbcdic(this.data, 20, 1);
    }

    public long dsrdsTcbCicsTask() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long dsrdsTcbMother() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long dsrdsTcbSister() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long dsrdsTcbDaughter() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public Duration dsrdsTcbCputime() {
        return Util.Binary8StckInterval(this.data, 40);
    }

    public double dsrdsTcbCputimeSeconds() {
        return Util.ToSeconds(this.dsrdsTcbCputime());
    }

    public long dsrdsTcbCputimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 40);
    }

    public long dsrdsTcbStgBelow() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long dsrdsTcbStgAbove() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long dsrdsTcbStgBelowInuse() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long dsrdsTcbStgAboveInuse() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public static DispatcherMvsTcbResourceStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherMvsTcbResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        dsrdsLen(0, 2),
        dsrdsId(2, 2),
        dsrdsVers(4, 1),
        dsrdsTcbAddress(8, 4),
        dsrdsTcbName(12, 8),
        dsrdsTcbType(20, 1),
        dsrdsTcbCicsTask(24, 4),
        dsrdsTcbMother(28, 4),
        dsrdsTcbSister(32, 4),
        dsrdsTcbDaughter(36, 4),
        dsrdsTcbCputime(40, 8),
        dsrdsTcbStgBelow(48, 4),
        dsrdsTcbStgAbove(52, 4),
        dsrdsTcbStgBelowInuse(56, 4),
        dsrdsTcbStgAboveInuse(60, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

