/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.DhdTemplateContents;
import com.blackhillsoftware.smf.cics.statistics.values.DhdTemplateType;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class DoctemplateResourceStatistics
extends StatisticsDataSection {
    public static final int DHDDS_LENGTH = 540;
    public static final int DHDIDR = 112;
    public static final int DHD_VERS = 1;
    public static final int DHD_APPEND_CRLF_NO = 1;
    public static final int DHD_APPEND_CRLF_YES = 2;

    private DoctemplateResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int dhddsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int dhddsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int dhddsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String dhdDoctemplateName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public DhdTemplateType dhdTemplateType() {
        int value = Util.ConvertUnsignedBinary1(this.data, 16);
        return DhdTemplateType.from(value);
    }

    public int dhdTemplateTypeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public int dhdAppendCrlf() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public DhdTemplateContents dhdTemplateContents() {
        int value = Util.ConvertUnsignedBinary1(this.data, 18);
        return DhdTemplateContents.from(value);
    }

    public int dhdTemplateContentsRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 18);
    }

    public String dhdTemplateName() {
        return Util.ConvertEbcdic(this.data, 20, 48);
    }

    public String dhdTemplateExitProgram() {
        return Util.ConvertEbcdic(this.data, 76, 8);
    }

    public String dhdTemplateFileName() {
        return Util.ConvertEbcdic(this.data, 84, 8);
    }

    public String dhdTemplateProgramName() {
        return Util.ConvertEbcdic(this.data, 92, 8);
    }

    public String dhdTemplatePdsMember() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String dhdTemplatePdsDdname() {
        return Util.ConvertEbcdic(this.data, 116, 8);
    }

    public String dhdTemplatePdsDsname() {
        return Util.ConvertEbcdic(this.data, 124, 44);
    }

    public String dhdTemplateTdqueueName() {
        return Util.ConvertEbcdic(this.data, 172, 4);
    }

    public String dhdTemplateTsqueueName() {
        return Util.ConvertEbcdic(this.data, 176, 16);
    }

    public String dhdTemplateHfsfileName() {
        return Util.ConvertEbcdic(this.data, 200, 255);
    }

    public long dhdTemplateCacheSize() {
        return Util.ConvertUnsignedBinary4(this.data, 456);
    }

    public long dhdTemplateUseCount() {
        return Util.ConvertUnsignedBinary4(this.data, 460);
    }

    public long dhdTemplateNewcopies() {
        return Util.ConvertUnsignedBinary4(this.data, 464);
    }

    public long dhdTemplateReadCount() {
        return Util.ConvertUnsignedBinary4(this.data, 468);
    }

    public long dhdTemplateCacheUsed() {
        return Util.ConvertUnsignedBinary4(this.data, 472);
    }

    public long dhdTemplateCacheDeleted() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public String dhdTemplateDefineSource() {
        return Util.ConvertEbcdic(this.data, 496, 8);
    }

    public LocalDateTime dhdTemplateChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 504);
    }

    public BigInteger dhdTemplateChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 504);
    }

    public String dhdTemplateChangeUserid() {
        return Util.ConvertEbcdic(this.data, 512, 8);
    }

    public CIAgent dhdTemplateChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 520);
        return CIAgent.from(value);
    }

    public int dhdTemplateChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 520);
    }

    public CIAgent dhdTemplateInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 522);
        return CIAgent.from(value);
    }

    public int dhdTemplateInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 522);
    }

    public LocalDateTime dhdTemplateInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 524);
    }

    public BigInteger dhdTemplateInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 524);
    }

    public String dhdTemplateInstallUserid() {
        return Util.ConvertEbcdic(this.data, 532, 8);
    }

    public boolean dhdAppendCrlfYes() {
        return Util.ConvertEquateValue(this.data, this.dhdAppendCrlf(), 2);
    }

    public static DoctemplateResourceStatistics create(byte[] Data2, int offset, int length) {
        return new DoctemplateResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        dhddsLen(0, 2),
        dhddsId(2, 2),
        dhddsVers(4, 1),
        dhdDoctemplateName(8, 8),
        dhdTemplateType(16, 1),
        dhdAppendCrlf(17, 1),
        dhdTemplateContents(18, 1),
        dhdTemplateName(20, 48),
        dhdTemplateExitProgram(76, 8),
        dhdTemplateFileName(84, 8),
        dhdTemplateProgramName(92, 8),
        dhdTemplatePdsMember(100, 8),
        dhdTemplatePdsDdname(116, 8),
        dhdTemplatePdsDsname(124, 44),
        dhdTemplateTdqueueName(172, 4),
        dhdTemplateTsqueueName(176, 16),
        dhdTemplateHfsfileName(200, 255),
        dhdTemplateCacheSize(456, 4),
        dhdTemplateUseCount(460, 4),
        dhdTemplateNewcopies(464, 4),
        dhdTemplateReadCount(468, 4),
        dhdTemplateCacheUsed(472, 4),
        dhdTemplateCacheDeleted(476, 4),
        dhdTemplateDefineSource(496, 8),
        dhdTemplateChangeTime(504, 8),
        dhdTemplateChangeUserid(512, 8),
        dhdTemplateChangeAgent(520, 2),
        dhdTemplateInstallAgent(522, 2),
        dhdTemplateInstallTime(524, 8),
        dhdTemplateInstallUserid(532, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

