/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.EnqueuePoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EnqueueManagerGlobalStatistics
extends StatisticsDataSection {
    public static final int NQGIDE = 97;
    public static final int NQGVERS = 1;
    public static final int NQGHLEN = 8;
    public static final int NQGGLEN = 12;

    private EnqueueManagerGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int nqglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int nqgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int nqgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int nqgnpool() {
        return Util.ConvertSignedBinary4(this.data, 8);
    }

    public List<EnqueuePoolStatistics> enqueuePoolStatistics() {
        int datastart = 12;
        int count = this.nqgnpool();
        ArrayList<EnqueuePoolStatistics> result = new ArrayList<EnqueuePoolStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(EnqueuePoolStatistics.create(this.data, datastart + i * 104, 104));
        }
        return Collections.unmodifiableList(result);
    }

    public static EnqueueManagerGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new EnqueueManagerGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        nqglen(0, 2),
        nqgid(2, 2),
        nqgdvers(4, 1),
        nqgnpool(8, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

