/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;

public final class EventBindingResourceStatistics
extends StatisticsDataSection {
    public static final int ECRDS_LENGTH = 132;
    public static final int ECRIDE = 141;
    public static final int ECR_VERS = 1;

    private EventBindingResourceStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ecrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ecrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ecrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ecrEventbindingName() {
        return Util.ConvertEbcdic(this.data, 8, 32);
    }

    public String ecrEpadapterName() {
        return Util.ConvertEbcdic(this.data, 56, 32);
    }

    public String ecrEbDefineSource() {
        return Util.ConvertEbcdic(this.data, 88, 8);
    }

    public LocalDateTime ecrEbChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 96);
    }

    public BigInteger ecrEbChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public String ecrEbChangeUserid() {
        return Util.ConvertEbcdic(this.data, 104, 8);
    }

    public CIAgent ecrEbChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 112);
        return CIAgent.from(value);
    }

    public int ecrEbChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 112);
    }

    public CIAgent ecrEbInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 114);
        return CIAgent.from(value);
    }

    public int ecrEbInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 114);
    }

    public LocalDateTime ecrEbInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 116);
    }

    public BigInteger ecrEbInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 116);
    }

    public String ecrEbInstallUserid() {
        return Util.ConvertEbcdic(this.data, 124, 8);
    }

    public static EventBindingResourceStatistics create(byte[] Data2, int offset, int length) {
        return new EventBindingResourceStatistics(Data2, offset, length);
    }

    static enum Field {
        ecrdsLen(0, 2),
        ecrdsId(2, 2),
        ecrdsVers(4, 1),
        ecrEventbindingName(8, 32),
        ecrEpadapterName(56, 32),
        ecrEbDefineSource(88, 8),
        ecrEbChangeTime(96, 8),
        ecrEbChangeUserid(104, 8),
        ecrEbChangeAgent(112, 2),
        ecrEbInstallAgent(114, 2),
        ecrEbInstallTime(116, 8),
        ecrEbInstallUserid(124, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

