/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class FepiConnectionStatistics
extends StatisticsDataSection {
    public static final int A23IDR = 17;
    public static final int A23VERS = 1;

    private FepiConnectionStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a23len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a23id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a23dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String a23pool() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String a23targ() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String a23node() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public long a23acq() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long a23cnv() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long a23usi() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long a23chout() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long a23chin() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long a23rtout() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long a23error() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public static FepiConnectionStatistics create(byte[] Data2, int offset, int length) {
        return new FepiConnectionStatistics(Data2, offset, length);
    }

    static enum Field {
        a23len(0, 2),
        a23id(2, 2),
        a23dvers(4, 1),
        a23pool(8, 8),
        a23targ(16, 8),
        a23node(24, 8),
        a23acq(32, 4),
        a23cnv(36, 4),
        a23usi(40, 4),
        a23chout(44, 4),
        a23chin(48, 4),
        a23rtout(52, 4),
        a23error(56, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

