/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class FepiTargetStatistics
extends StatisticsDataSection {
    public static final int A24IDR = 18;
    public static final int A24VERS = 1;

    private FepiTargetStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a24len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a24id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a24dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String a24targ() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String a24pool() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String a24appl() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public long a24ndct() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long a24alloc() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long a24totwt() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long a24wait() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long a24pkwt() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long a24tiout() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public static FepiTargetStatistics create(byte[] Data2, int offset, int length) {
        return new FepiTargetStatistics(Data2, offset, length);
    }

    static enum Field {
        a24len(0, 2),
        a24id(2, 2),
        a24dvers(4, 1),
        a24targ(8, 8),
        a24pool(16, 8),
        a24appl(24, 8),
        a24ndct(32, 4),
        a24alloc(36, 4),
        a24totwt(40, 4),
        a24wait(44, 4),
        a24pkwt(48, 4),
        a24tiout(52, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

