/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.IpFamily;
import com.blackhillsoftware.smf.cics.statistics.values.IsrLinkauth;
import com.blackhillsoftware.smf.cics.statistics.values.IsrMirrorlife;
import com.blackhillsoftware.smf.cics.statistics.values.IsrUserauth;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class IpconnStatistics
extends StatisticsDataSection {
    public static final int ISRDS_LENGTH = 580;
    public static final int ISRIDR = 109;
    public static final int ISR_VERS = 1;
    public static final int ISR_SSL_YES = 1;
    public static final int ISR_SSL_NO = 2;

    private IpconnStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int isrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int isrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int isrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String isrIpconnName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public String isrApplid() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String isrNetworkId() {
        return Util.ConvertEbcdic(this.data, 24, 8);
    }

    public String isrHostName() {
        return Util.ConvertEbcdic(this.data, 32, 116);
    }

    public long isrPortNumber() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public int isrSslSupport() {
        return Util.ConvertUnsignedBinary1(this.data, 156);
    }

    public IsrUserauth isrUserauth() {
        int value = Util.ConvertUnsignedBinary1(this.data, 157);
        return IsrUserauth.from(value);
    }

    public int isrUserauthRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 157);
    }

    public IsrLinkauth isrLinkauth() {
        int value = Util.ConvertUnsignedBinary1(this.data, 158);
        return IsrLinkauth.from(value);
    }

    public int isrLinkauthRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 158);
    }

    public IsrMirrorlife isrMirrorlife() {
        int value = Util.ConvertUnsignedBinary1(this.data, 159);
        return IsrMirrorlife.from(value);
    }

    public int isrMirrorlifeRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 159);
    }

    public String isrTcpipService() {
        return Util.ConvertEbcdic(this.data, 160, 8);
    }

    public long isrFsTsRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long isrFsTsBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 200);
    }

    public BigInteger isrFsTsBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 200);
    }

    public long isrFsTsBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 208);
    }

    public BigInteger isrFsTsBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 208);
    }

    public ZonedDateTime isrIpconnGmtCreateTime() {
        return Util.Binary8xStckTime(this.data, 216);
    }

    public BigInteger isrIpconnGmtCreateTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public LocalDateTime isrIpconnCreateTime() {
        return Util.Binary8xStckLocalTime(this.data, 224);
    }

    public BigInteger isrIpconnCreateTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 224);
    }

    public ZonedDateTime isrIpconnGmtDeleteTime() {
        return Util.Binary8xStckTime(this.data, 232);
    }

    public BigInteger isrIpconnGmtDeleteTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 232);
    }

    public LocalDateTime isrIpconnDeleteTime() {
        return Util.Binary8xStckLocalTime(this.data, 240);
    }

    public BigInteger isrIpconnDeleteTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 240);
    }

    public long isrSendSessions() {
        return Util.ConvertUnsignedBinary4(this.data, 256);
    }

    public long isrCurrentSendSessions() {
        return Util.ConvertUnsignedBinary4(this.data, 260);
    }

    public long isrPeakSendSessions() {
        return Util.ConvertUnsignedBinary4(this.data, 264);
    }

    public long isrReceiveSessions() {
        return Util.ConvertUnsignedBinary4(this.data, 276);
    }

    public long isrCurrentReceiveSessions() {
        return Util.ConvertUnsignedBinary4(this.data, 280);
    }

    public long isrPeakReceiveSessions() {
        return Util.ConvertUnsignedBinary4(this.data, 284);
    }

    public long isrTrRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 292);
    }

    public long isrTrBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 296);
    }

    public BigInteger isrTrBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 296);
    }

    public long isrTrBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 304);
    }

    public BigInteger isrTrBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 304);
    }

    public long isrTotalAllocates() {
        return Util.ConvertUnsignedBinary4(this.data, 312);
    }

    public long isrCurrentQueuedAllocates() {
        return Util.ConvertUnsignedBinary4(this.data, 316);
    }

    public long isrPeakQueuedAllocates() {
        return Util.ConvertUnsignedBinary4(this.data, 320);
    }

    public long isrAllocatesFailedLink() {
        return Util.ConvertUnsignedBinary4(this.data, 324);
    }

    public long isrAllocatesFailedOther() {
        return Util.ConvertUnsignedBinary4(this.data, 328);
    }

    public long isrFsTdRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 332);
    }

    public long isrFsTdBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 336);
    }

    public BigInteger isrFsTdBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 336);
    }

    public long isrFsTdBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 344);
    }

    public BigInteger isrFsTdBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 344);
    }

    public long isrAllocateQueueLimit() {
        return Util.ConvertUnsignedBinary4(this.data, 352);
    }

    public long isrQlimitAllocRejects() {
        return Util.ConvertUnsignedBinary4(this.data, 356);
    }

    public Duration isrMaxQueueTime() {
        throw new NotAvailableException("Units for this field are undefined - please contact Black Hill Software");
    }

    public double isrMaxQueueTimeSeconds() {
        return Util.ToSeconds(this.isrMaxQueueTime());
    }

    public long isrMaxQueueTimeRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 360);
    }

    public long isrMaxqtimeAllocQpurges() {
        return Util.ConvertUnsignedBinary4(this.data, 364);
    }

    public long isrMaxqtimeAllocsPurged() {
        return Util.ConvertUnsignedBinary4(this.data, 368);
    }

    public long isrXisqueAllocRejects() {
        return Util.ConvertUnsignedBinary4(this.data, 380);
    }

    public long isrXisqueAllocQpurges() {
        return Util.ConvertUnsignedBinary4(this.data, 384);
    }

    public long isrXisqueAllocsPurged() {
        return Util.ConvertUnsignedBinary4(this.data, 388);
    }

    public long isrTransAttached() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public long isrRemoteTermStarts() {
        return Util.ConvertUnsignedBinary4(this.data, 400);
    }

    public long isrUnsupportedRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 404);
    }

    public long isrFsPgRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 412);
    }

    public long isrFsPgBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 416);
    }

    public BigInteger isrFsPgBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 416);
    }

    public long isrFsPgBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 424);
    }

    public BigInteger isrFsPgBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 424);
    }

    public long isrFsIcRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 436);
    }

    public long isrFsIcBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 440);
    }

    public BigInteger isrFsIcBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 440);
    }

    public long isrFsIcBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 448);
    }

    public BigInteger isrFsIcBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 448);
    }

    public String isrIpconnIpAddress() {
        return Util.ConvertEbcdic(this.data, 456, 39);
    }

    public InetAddress isrIpconnIpAddressAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 456, 39);
    }

    public IpFamily isrIpconnIpFamily() {
        int value = Util.ConvertUnsignedBinary1(this.data, 495);
        return IpFamily.from(value);
    }

    public int isrIpconnIpFamilyRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 495);
    }

    public String isrIpconnDefineSource() {
        return Util.ConvertEbcdic(this.data, 504, 8);
    }

    public LocalDateTime isrIpconnChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 512);
    }

    public BigInteger isrIpconnChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 512);
    }

    public String isrIpconnChangeUserid() {
        return Util.ConvertEbcdic(this.data, 520, 8);
    }

    public CIAgent isrIpconnChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 528);
        return CIAgent.from(value);
    }

    public int isrIpconnChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 528);
    }

    public CIAgent isrIpconnInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 530);
        return CIAgent.from(value);
    }

    public int isrIpconnInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 530);
    }

    public LocalDateTime isrIpconnInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 532);
    }

    public BigInteger isrIpconnInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 532);
    }

    public String isrIpconnInstallUserid() {
        return Util.ConvertEbcdic(this.data, 540, 8);
    }

    public long isrFsFcRequests() {
        return Util.ConvertUnsignedBinary4(this.data, 548);
    }

    public long isrFsFcBytesSent() {
        return Util.ConvertUnsignedBinary8(this.data, 552);
    }

    public BigInteger isrFsFcBytesSentAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 552);
    }

    public long isrFsFcBytesReceived() {
        return Util.ConvertUnsignedBinary8(this.data, 560);
    }

    public BigInteger isrFsFcBytesReceivedAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 560);
    }

    public boolean isrSslYes() {
        return Util.ConvertEquateValue(this.data, this.isrSslSupport(), 1);
    }

    public static IpconnStatistics create(byte[] Data2, int offset, int length) {
        return new IpconnStatistics(Data2, offset, length);
    }

    static enum Field {
        isrdsLen(0, 2),
        isrdsId(2, 2),
        isrdsVers(4, 1),
        isrIpconnName(8, 8),
        isrApplid(16, 8),
        isrNetworkId(24, 8),
        isrHostName(32, 116),
        isrPortNumber(152, 4),
        isrSslSupport(156, 1),
        isrUserauth(157, 1),
        isrLinkauth(158, 1),
        isrMirrorlife(159, 1),
        isrTcpipService(160, 8),
        isrFsTsRequests(196, 4),
        isrFsTsBytesSent(200, 8),
        isrFsTsBytesReceived(208, 8),
        isrIpconnGmtCreateTime(216, 8),
        isrIpconnCreateTime(224, 8),
        isrIpconnGmtDeleteTime(232, 8),
        isrIpconnDeleteTime(240, 8),
        isrSendSessions(256, 4),
        isrCurrentSendSessions(260, 4),
        isrPeakSendSessions(264, 4),
        isrReceiveSessions(276, 4),
        isrCurrentReceiveSessions(280, 4),
        isrPeakReceiveSessions(284, 4),
        isrTrRequests(292, 4),
        isrTrBytesSent(296, 8),
        isrTrBytesReceived(304, 8),
        isrTotalAllocates(312, 4),
        isrCurrentQueuedAllocates(316, 4),
        isrPeakQueuedAllocates(320, 4),
        isrAllocatesFailedLink(324, 4),
        isrAllocatesFailedOther(328, 4),
        isrFsTdRequests(332, 4),
        isrFsTdBytesSent(336, 8),
        isrFsTdBytesReceived(344, 8),
        isrAllocateQueueLimit(352, 4),
        isrQlimitAllocRejects(356, 4),
        isrMaxQueueTime(360, 4),
        isrMaxqtimeAllocQpurges(364, 4),
        isrMaxqtimeAllocsPurged(368, 4),
        isrXisqueAllocRejects(380, 4),
        isrXisqueAllocQpurges(384, 4),
        isrXisqueAllocsPurged(388, 4),
        isrTransAttached(396, 4),
        isrRemoteTermStarts(400, 4),
        isrUnsupportedRequests(404, 4),
        isrFsPgRequests(412, 4),
        isrFsPgBytesSent(416, 8),
        isrFsPgBytesReceived(424, 8),
        isrFsIcRequests(436, 4),
        isrFsIcBytesSent(440, 8),
        isrFsIcBytesReceived(448, 8),
        isrIpconnIpAddress(456, 39),
        isrIpconnIpFamily(495, 1),
        isrIpconnDefineSource(504, 8),
        isrIpconnChangeTime(512, 8),
        isrIpconnChangeUserid(520, 8),
        isrIpconnChangeAgent(528, 2),
        isrIpconnInstallAgent(530, 2),
        isrIpconnInstallTime(532, 8),
        isrIpconnInstallUserid(540, 8),
        isrFsFcRequests(548, 4),
        isrFsFcBytesSent(552, 8),
        isrFsFcBytesReceived(560, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

