/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LoaderPrivateLibraryStatistics
extends StatisticsDataSection {
    public static final int LDYDS_LENGTH = 244;
    public static final int LDYIDR = 32;
    public static final int LDY_CRITICAL_NO = 1;
    public static final int LDY_CRITICAL_YES = 2;
    public static final int LDY_LIBRARY_ENABLED = 1;
    public static final int LDY_LIBRARY_DISABLED = 2;

    private LoaderPrivateLibraryStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ldydsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ldydsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ldydsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ldyLibraryPlatformName() {
        return Util.ConvertEbcdic(this.data, 8, 64);
    }

    public String ldyLibraryApplicationName() {
        return Util.ConvertEbcdic(this.data, 72, 64);
    }

    public long ldyLibraryApplMajorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long ldyLibraryApplMinorVer() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long ldyLibraryApplMicroVer() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public String ldyLibraryName() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public long ldyLibrarySearchPos() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long ldyLibraryRanking() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public int ldyLibraryCritical() {
        return Util.ConvertUnsignedBinary1(this.data, 164);
    }

    public int ldyLibraryEnableStatus() {
        return Util.ConvertUnsignedBinary1(this.data, 165);
    }

    public long ldyLibraryProgLoads() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public String ldyLibraryDefineSource() {
        return Util.ConvertEbcdic(this.data, 188, 8);
    }

    public LocalDateTime ldyLibraryChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 196);
    }

    public BigInteger ldyLibraryChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 196);
    }

    public String ldyLibraryChangeUserid() {
        return Util.ConvertEbcdic(this.data, 204, 8);
    }

    public int ldyLibraryChangeAgent() {
        return Util.ConvertUnsignedBinary2(this.data, 212);
    }

    public int ldyLibraryInstallAgent() {
        return Util.ConvertUnsignedBinary2(this.data, 214);
    }

    public LocalDateTime ldyLibraryInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 216);
    }

    public BigInteger ldyLibraryInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public String ldyLibraryInstallUserid() {
        return Util.ConvertEbcdic(this.data, 224, 8);
    }

    public int ldyLibraryNumdsnames() {
        return Util.ConvertSignedBinary4(this.data, 240);
    }

    public List<String> datasetNames() {
        int datastart = 244;
        int count = this.ldyLibraryNumdsnames();
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(Util.ConvertEbcdic(this.data, datastart + i * 44, 44));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean ldyCriticalYes() {
        return Util.ConvertEquateValue(this.data, this.ldyLibraryCritical(), 2);
    }

    public boolean ldyLibraryEnabled() {
        return Util.ConvertEquateValue(this.data, this.ldyLibraryEnableStatus(), 1);
    }

    public List<String> ldyDsnames() {
        int datastart = 244;
        int count = this.ldyLibraryNumdsnames();
        int length = 44;
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            result.add(Util.ConvertEbcdic(this.data, datastart + i * length, length));
        }
        return Collections.unmodifiableList(result);
    }

    public static LoaderPrivateLibraryStatistics create(byte[] Data2, int offset, int length) {
        return new LoaderPrivateLibraryStatistics(Data2, offset, length);
    }

    static enum Field {
        ldydsLen(0, 2),
        ldydsId(2, 2),
        ldydsVers(4, 1),
        ldyLibraryPlatformName(8, 64),
        ldyLibraryApplicationName(72, 64),
        ldyLibraryApplMajorVer(136, 4),
        ldyLibraryApplMinorVer(140, 4),
        ldyLibraryApplMicroVer(144, 4),
        ldyLibraryName(148, 8),
        ldyLibrarySearchPos(156, 4),
        ldyLibraryRanking(160, 4),
        ldyLibraryCritical(164, 1),
        ldyLibraryEnableStatus(165, 1),
        ldyLibraryProgLoads(168, 4),
        ldyLibraryDefineSource(188, 8),
        ldyLibraryChangeTime(196, 8),
        ldyLibraryChangeUserid(204, 8),
        ldyLibraryChangeAgent(212, 2),
        ldyLibraryInstallAgent(214, 2),
        ldyLibraryInstallTime(216, 8),
        ldyLibraryInstallUserid(224, 8),
        ldyLibraryNumdsnames(240, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

