/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.LdrLocations;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class LoaderPublicProgramStatistics
extends StatisticsDataSection {
    public static final int LDRIDR = 25;
    public static final int LDRVERS = 1;

    private LoaderPublicProgramStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int ldrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int ldrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int ldrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String ldrpname() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long ldrtu() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long ldrfc() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public Duration ldrft() {
        return Util.Binary4_16_US(this.data, 24);
    }

    public double ldrftSeconds() {
        return Util.ToSeconds(this.ldrft());
    }

    public double ldrftRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long ldrrplo() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long ldrtn() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long ldrpsize() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long ldrrpc() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public LdrLocations ldrlocn() {
        int value = Util.ConvertUnsignedBinary1(this.data, 44);
        return LdrLocations.from(value);
    }

    public int ldrlocnRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 44);
    }

    public String ldrlbnm() {
        return Util.ConvertEbcdic(this.data, 48, 8);
    }

    public String ldrlbdnm() {
        return Util.ConvertEbcdic(this.data, 56, 44);
    }

    public static LoaderPublicProgramStatistics create(byte[] Data2, int offset, int length) {
        return new LoaderPublicProgramStatistics(Data2, offset, length);
    }

    static enum Field {
        ldrlen(0, 2),
        ldrid(2, 2),
        ldrdvers(4, 1),
        ldrpname(8, 8),
        ldrtu(16, 4),
        ldrfc(20, 4),
        ldrft(24, 4),
        ldrrplo(28, 4),
        ldrtn(32, 4),
        ldrpsize(36, 4),
        ldrrpc(40, 4),
        ldrlocn(44, 1),
        ldrlbnm(48, 8),
        ldrlbdnm(56, 44);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

