/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.time.Duration;

public final class LogManagerGlobalStatistics
extends StatisticsDataSection {
    public static final int LGGDSLEN = 28;
    public static final int LGGIDE = 92;
    public static final int LGGVERS = 1;

    private LogManagerGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int lgglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int lggid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int lggdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long lggakpfreq() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public Duration lgglgdefer() {
        return Util.Binary4MS(this.data, 12);
    }

    public double lgglgdeferSeconds() {
        return Util.ToSeconds(this.lgglgdefer());
    }

    public long lgglgdeferRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long lggakpstkn() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public static LogManagerGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new LogManagerGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        lgglen(0, 2),
        lggid(2, 2),
        lggdvers(4, 1),
        lggakpfreq(8, 4),
        lgglgdefer(12, 4),
        lggakpstkn(16, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

