/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.LsrPoolStatisticsEntry;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LsrPoolStatistics
extends StatisticsDataSection {
    public static final int A08IDR = 39;
    public static final int A08VERS = 1;
    public static final int A08IDSEP = 128;
    public static final int A08NBS = 11;
    public static final int A08CLEN = 140;

    private LsrPoolStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a08len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a08id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a08dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int a08srpid() {
        return Util.ConvertUnsignedBinary1(this.data, 8);
    }

    public int a08flags() {
        return Util.ConvertUnsignedBinary1(this.data, 9);
    }

    public boolean a08idsep() {
        return Util.ConvertFlag(this.data, this.a08flags(), 128);
    }

    public LocalDateTime a08lbkcd() {
        return Util.Binary8xStckLocalTime(this.data, 12);
    }

    public BigInteger a08lbkcdRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 12);
    }

    public LocalDateTime a08lbkdd() {
        return Util.Binary8xStckLocalTime(this.data, 20);
    }

    public BigInteger a08lbkddRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 20);
    }

    public ZonedDateTime a08gbkcd() {
        return Util.Binary8xStckTime(this.data, 28);
    }

    public BigInteger a08gbkcdRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public ZonedDateTime a08gbkdd() {
        return Util.Binary8xStckTime(this.data, 36);
    }

    public BigInteger a08gbkddRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 36);
    }

    public int a08bkkyl() {
        return Util.ConvertUnsignedBinary2(this.data, 44);
    }

    public int a08bkstn() {
        return Util.ConvertUnsignedBinary2(this.data, 46);
    }

    public int a08bkhsw() {
        return Util.ConvertUnsignedBinary2(this.data, 48);
    }

    public long a08bktsw() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public int a08bkhas() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public long a08tobfnData() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long a08tohbnData() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long a08tobffData() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long a08tofrdData() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long a08touiwData() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long a08tonuwData() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long a08tocrsData() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long a08tocwsData() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long a08tocrfData() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long a08tocwfData() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long a08tobfnIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long a08tohbnIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long a08tobffIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long a08tofrdIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long a08touiwIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long a08tonuwIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long a08tocrsIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long a08tocwsIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long a08tocrfIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long a08tocwfIndx() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public List<LsrPoolStatisticsEntry> lsrPoolEntries() {
        int datastart = 140;
        int count = 11;
        ArrayList<LsrPoolStatisticsEntry> result = new ArrayList<LsrPoolStatisticsEntry>(count);
        for (int i = 0; i < count; ++i) {
            result.add(LsrPoolStatisticsEntry.create(this.data, datastart + i * 40, 40));
        }
        return Collections.unmodifiableList(result);
    }

    public List<LsrPoolStatisticsEntry> lsrPoolIndexEntries() {
        if (!this.a08idsep()) {
            return Collections.emptyList();
        }
        int datastart = 580;
        int count = 11;
        ArrayList<LsrPoolStatisticsEntry> result = new ArrayList<LsrPoolStatisticsEntry>(count);
        for (int i = 0; i < count; ++i) {
            result.add(LsrPoolStatisticsEntry.create(this.data, datastart + i * 40, 40));
        }
        return Collections.unmodifiableList(result);
    }

    public static LsrPoolStatistics create(byte[] Data2, int offset, int length) {
        return new LsrPoolStatistics(Data2, offset, length);
    }

    static enum Field {
        a08len(0, 2),
        a08id(2, 2),
        a08dvers(4, 1),
        a08srpid(8, 1),
        a08flags(9, 1),
        a08lbkcd(12, 8),
        a08lbkdd(20, 8),
        a08gbkcd(28, 8),
        a08gbkdd(36, 8),
        a08bkkyl(44, 2),
        a08bkstn(46, 2),
        a08bkhsw(48, 2),
        a08bktsw(52, 4),
        a08bkhas(56, 2),
        a08tobfnData(60, 4),
        a08tohbnData(64, 4),
        a08tobffData(68, 4),
        a08tofrdData(72, 4),
        a08touiwData(76, 4),
        a08tonuwData(80, 4),
        a08tocrsData(84, 4),
        a08tocwsData(88, 4),
        a08tocrfData(92, 4),
        a08tocwfData(96, 4),
        a08tobfnIndx(100, 4),
        a08tohbnIndx(104, 4),
        a08tobffIndx(108, 4),
        a08tofrdIndx(112, 4),
        a08touiwIndx(116, 4),
        a08tonuwIndx(120, 4),
        a08tocrsIndx(124, 4),
        a08tocwsIndx(128, 4),
        a08tocrfIndx(132, 4),
        a08tocwfIndx(136, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

