/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.MngWlmGM;
import com.blackhillsoftware.smf.cics.statistics.values.MngWlmGt;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public final class MonitoringGlobalStatistics
extends StatisticsDataSection {
    public static final int MNGIDE = 81;
    public static final int MNGVERS = 1;
    public static final int MNGRMIN = 0;
    public static final int MNGRMIY = 1;
    public static final int MNGAPPLN = 0;
    public static final int MNGAPPLY = 1;
    public static final int MNGRCMPN = 0;
    public static final int MNGRCMPY = 1;
    public static final int MNGNSRV = 0;
    public static final int MNGSRV = 1;
    public static final int MNGCCNCR = 0;
    public static final int MNGCCCRT = 1;
    public static final int MNGSCNCR = 0;
    public static final int MNGSCCRT = 1;
    public static final int MNGCLEN = 312;

    private MonitoringGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mnglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mngid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mngdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public long mnger() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long mngers() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long mngpr() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long mngprs() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long mngsmfr() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long mngsmfe() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long mngsmfnc() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long mngsmfcm() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long mngrr() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long mngrrs() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long mngir() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long mngirs() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public int mngfrl() {
        return Util.ConvertUnsignedBinary2(this.data, 56);
    }

    public int mngtrl() {
        return Util.ConvertUnsignedBinary2(this.data, 58);
    }

    public int mngdplrl() {
        return Util.ConvertUnsignedBinary2(this.data, 60);
    }

    public int mngurirl() {
        return Util.ConvertUnsignedBinary2(this.data, 62);
    }

    public int mngwebrl() {
        return Util.ConvertUnsignedBinary2(this.data, 64);
    }

    public int mngrmi() {
        return Util.ConvertUnsignedBinary1(this.data, 66);
    }

    public boolean mngrmiy() {
        return Util.ConvertEquateValue(this.data, this.mngrmi(), 1);
    }

    public int mngappns() {
        return Util.ConvertUnsignedBinary1(this.data, 67);
    }

    public boolean mngapply() {
        return Util.ConvertEquateValue(this.data, this.mngappns(), 1);
    }

    public int mngmrcmp() {
        return Util.ConvertUnsignedBinary1(this.data, 68);
    }

    public boolean mngrcmpy() {
        return Util.ConvertEquateValue(this.data, this.mngmrcmp(), 1);
    }

    public long mngavurl() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long mngavcrl() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public int mngwlmmd() {
        return Util.ConvertUnsignedBinary1(this.data, 80);
    }

    public int mngwlmst() {
        return Util.ConvertUnsignedBinary1(this.data, 81);
    }

    public boolean mngsrv() {
        return Util.ConvertEquateValue(this.data, this.mngwlmst(), 1);
    }

    public String mngwlmsc() {
        return Util.ConvertEbcdic(this.data, 84, 8);
    }

    public String mngwlmwn() {
        return Util.ConvertEbcdic(this.data, 92, 8);
    }

    public String mngwlmrg() {
        return Util.ConvertEbcdic(this.data, 100, 8);
    }

    public String mngwlmrc() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public MngWlmGt mngwlmgt() {
        int value = Util.ConvertUnsignedBinary1(this.data, 116);
        return MngWlmGt.from(value);
    }

    public int mngwlmgtRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 116);
    }

    public int mngwlmcc() {
        return Util.ConvertUnsignedBinary1(this.data, 117);
    }

    public boolean mngcccrt() {
        return Util.ConvertEquateValue(this.data, this.mngwlmcc(), 1);
    }

    public int mngwlmsk() {
        return Util.ConvertUnsignedBinary1(this.data, 118);
    }

    public boolean mngsccrt() {
        return Util.ConvertEquateValue(this.data, this.mngwlmsk(), 1);
    }

    public MngWlmGM mngwlmgm() {
        int value = Util.ConvertUnsignedBinary1(this.data, 119);
        return MngWlmGM.from(value);
    }

    public int mngwlmgmRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 119);
    }

    public long mngwlmgv() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public int mngwlmgi() {
        return Util.ConvertUnsignedBinary2(this.data, 124);
    }

    public String mngcectp() {
        return Util.ConvertEbcdic(this.data, 128, 4);
    }

    public String mngcecid() {
        return Util.ConvertEbcdic(this.data, 132, 16);
    }

    public String mngmctnm() {
        return Util.ConvertEbcdic(this.data, 148, 8);
    }

    public long mngutnum() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long mngstnum() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public ZonedDateTime mnggutcl() {
        return Util.Binary8xStckTime(this.data, 168);
    }

    public BigInteger mnggutclRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 168);
    }

    public LocalDateTime mnglutcl() {
        return Util.Binary8xStckLocalTime(this.data, 176);
    }

    public BigInteger mnglutclRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 176);
    }

    public ZonedDateTime mnggutat() {
        return Util.Binary8xStckTime(this.data, 184);
    }

    public BigInteger mnggutatRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 184);
    }

    public LocalDateTime mnglutat() {
        return Util.Binary8xStckLocalTime(this.data, 192);
    }

    public BigInteger mnglutatRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 192);
    }

    public long mngmxuta() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long mngcauta() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public LocalTime mngfreq() {
        return Util.EBCDIC6hhmmss(this.data, 208);
    }

    public String mngfreqRawValue() {
        return Util.ConvertEbcdic(this.data, 208, 6);
    }

    public Duration mngautrt() {
        return Util.Binary8StckInterval(this.data, 216);
    }

    public double mngautrtSeconds() {
        return Util.ToSeconds(this.mngautrt());
    }

    public long mngautrtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 216);
    }

    public Duration mngputrt() {
        return Util.Binary8StckInterval(this.data, 224);
    }

    public double mngputrtSeconds() {
        return Util.ToSeconds(this.mngputrt());
    }

    public long mngputrtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 224);
    }

    public ZonedDateTime mnggutrt() {
        return Util.Binary8xStckTime(this.data, 232);
    }

    public BigInteger mnggutrtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 232);
    }

    public LocalDateTime mnglutrt() {
        return Util.Binary8xStckLocalTime(this.data, 240);
    }

    public BigInteger mnglutrtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 240);
    }

    public Duration mngcput() {
        return Util.Binary8StckInterval(this.data, 264);
    }

    public double mngcputSeconds() {
        return Util.ToSeconds(this.mngcput());
    }

    public long mngcputRawValue() {
        return Util.ConvertSignedBinary8(this.data, 264);
    }

    public Duration mngtoncp() {
        return Util.Binary8StckInterval(this.data, 272);
    }

    public double mngtoncpSeconds() {
        return Util.ToSeconds(this.mngtoncp());
    }

    public long mngtoncpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 272);
    }

    public Duration mngoflcp() {
        return Util.Binary8StckInterval(this.data, 280);
    }

    public double mngoflcpSeconds() {
        return Util.ToSeconds(this.mngoflcp());
    }

    public long mngoflcpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 280);
    }

    public static MonitoringGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new MonitoringGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        mnglen(0, 2),
        mngid(2, 2),
        mngdvers(4, 1),
        mnger(8, 4),
        mngers(12, 4),
        mngpr(16, 4),
        mngprs(20, 4),
        mngsmfr(24, 4),
        mngsmfe(28, 4),
        mngsmfnc(32, 4),
        mngsmfcm(36, 4),
        mngrr(40, 4),
        mngrrs(44, 4),
        mngir(48, 4),
        mngirs(52, 4),
        mngfrl(56, 2),
        mngtrl(58, 2),
        mngdplrl(60, 2),
        mngurirl(62, 2),
        mngwebrl(64, 2),
        mngrmi(66, 1),
        mngappns(67, 1),
        mngmrcmp(68, 1),
        mngavurl(72, 4),
        mngavcrl(76, 4),
        mngwlmmd(80, 1),
        mngwlmst(81, 1),
        mngwlmsc(84, 8),
        mngwlmwn(92, 8),
        mngwlmrg(100, 8),
        mngwlmrc(108, 8),
        mngwlmgt(116, 1),
        mngwlmcc(117, 1),
        mngwlmsk(118, 1),
        mngwlmgm(119, 1),
        mngwlmgv(120, 4),
        mngwlmgi(124, 2),
        mngcectp(128, 4),
        mngcecid(132, 16),
        mngmctnm(148, 8),
        mngutnum(160, 4),
        mngstnum(164, 4),
        mnggutcl(168, 8),
        mnglutcl(176, 8),
        mnggutat(184, 8),
        mnglutat(192, 8),
        mngmxuta(200, 4),
        mngcauta(204, 4),
        mngfreq(208, 6),
        mngautrt(216, 8),
        mngputrt(224, 8),
        mnggutrt(232, 8),
        mnglutrt(240, 8),
        mngcput(264, 8),
        mngtoncp(272, 8),
        mngoflcp(280, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

