/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.FieldNotPresentException;
import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.TmrAcMth;
import com.blackhillsoftware.smf.cics.statistics.values.TmrNatur;
import com.blackhillsoftware.smf.cics.statistics.values.TmrSesst;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.LocalDateTime;

public class MonitoringTransactionStatistics
extends StatisticsDataSection {
    public static final int MNTIDE = 84;
    public static final int MNTVERS = 1;
    public static final int TMRTRFL1_NONE = 128;
    public static final int TMRTRFL1_TERM = 64;
    public static final int TMRTRFL1_SURR = 32;
    public static final int TMRTRFL1_DEST = 16;
    public static final int TMRTRFL1_BRDG = 8;
    public static final int TMRTRFL2_SYSTEM = 128;
    public static final int TMRTRFL2_MIRROR = 64;
    public static final int TMRTRFL2_DPL = 32;
    public static final int TMRTRFL2_ONC_RPC = 16;
    public static final int TMRTRFL2_WEB = 8;
    public static final int TMRTRFL2_BRIDGE = 4;
    public static final int TMRTFFL2_RUN_TRAN = 1;
    public static final int TMRTRFL3_RPT = 128;
    public static final int TMRTRFL3_NTFY_COMP = 64;
    public static final int TMRTRFL3_NTFY = 32;
    public static final int TMRTRFL4_LOC_BELOW = 128;
    public static final int TMRTRFL4_CICS_KEY = 64;
    public static final int TMRTRFL4_ISOLATE_NO = 32;
    public static final int TMRTRFL4_DYNAMIC = 16;
    public static final int TMRTRFL8_WAIT_NO = 128;
    public static final int TMRTRFL8_COMMIT = 64;
    public static final int TMRTRFL8_INDOUBT_ACT = 32;
    public static final int TMRTRFL8_UOW_SHUNT = 16;
    public static final int TMRTRFL8_UOW_UNSHUNT = 8;
    public static final int TMRTRFL8_INDBT_FAIL = 4;
    public static final int TMRTRFL8_RO_FAILURE = 2;
    public static final String TMRRTYPE_CONVERSE = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(195).array(), 3, 1);
    public static final String TMRRTYPE_DELIVER = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(196).array(), 3, 1);
    public static final String TMRRTYPE_FREQUENCY = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(198).array(), 3, 1);
    public static final String TMRRTYPE_SYNCPOINT = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(226).array(), 3, 1);
    public static final String TMRRTYPE_TERMINATE = Util.ConvertEbcdic(ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(227).array(), 3, 1);

    protected MonitoringTransactionStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mntlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mntid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mntdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String tmrtrid() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public String tmrteid() {
        return Util.ConvertEbcdic(this.data, 12, 4);
    }

    public String tmrusid() {
        return Util.ConvertEbcdic(this.data, 16, 8);
    }

    public String tmrtrty() {
        return Util.ConvertEbcdic(this.data, 24, 4);
    }

    public LocalDateTime tmrattt() {
        return Util.Binary8xStckLocalTime(this.data, 28);
    }

    public BigInteger tmratttRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 28);
    }

    public LocalDateTime tmrdett() {
        return Util.Binary8xStckLocalTime(this.data, 36);
    }

    public BigInteger tmrdettRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 36);
    }

    public long tmrtrsn() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long tmrtpri() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public String tmrtclsn() {
        return Util.ConvertEbcdic(this.data, 52, 8);
    }

    public String tmrlunm() {
        return Util.ConvertEbcdic(this.data, 60, 8);
    }

    public String tmrpgnm() {
        return Util.ConvertEbcdic(this.data, 68, 8);
    }

    public String tmrnetpx() {
        return Util.ConvertEbcdic(this.data, 76, 20);
    }

    public long tmrnetsx() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger tmrnetsxAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public String tmrrsys() {
        return Util.ConvertEbcdic(this.data, 104, 4);
    }

    public long tmrprcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public String tmrrmuow() {
        return Util.ConvertEbcdic(this.data, 112, 8);
    }

    public String tmrsrvcl() {
        return Util.ConvertEbcdic(this.data, 120, 8);
    }

    public String tmrrptcl() {
        return Util.ConvertEbcdic(this.data, 128, 8);
    }

    public String tmrfcty() {
        return Util.ConvertEbcdic(this.data, 136, 4);
    }

    public int tmrtrfl1() {
        return Util.ConvertUnsignedBinary1(this.data, 140);
    }

    public boolean tmrtrfl1None() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 128);
    }

    public boolean tmrtrfl1Term() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 64);
    }

    public boolean tmrtrfl1Surr() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 32);
    }

    public boolean tmrtrfl1Dest() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 16);
    }

    public boolean tmrtrfl1Brdg() {
        return Util.ConvertFlag(this.data, this.tmrtrfl1(), 8);
    }

    public int tmrtrfl2() {
        return Util.ConvertUnsignedBinary1(this.data, 141);
    }

    public boolean tmrtrfl2System() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 128);
    }

    public boolean tmrtrfl2Mirror() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 64);
    }

    public boolean tmrtrfl2Dpl() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 32);
    }

    public boolean tmrtrfl2OncRpc() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 16);
    }

    public boolean tmrtrfl2Web() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 8);
    }

    public boolean tmrtrfl2Bridge() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 4);
    }

    public boolean tmrtffl2RunTran() {
        return Util.ConvertFlag(this.data, this.tmrtrfl2(), 1);
    }

    public int tmrtrfl3() {
        return Util.ConvertUnsignedBinary1(this.data, 142);
    }

    public boolean tmrtrfl3Rpt() {
        return Util.ConvertFlag(this.data, this.tmrtrfl3(), 128);
    }

    public boolean tmrtrfl3NtfyComp() {
        return Util.ConvertFlag(this.data, this.tmrtrfl3(), 64);
    }

    public boolean tmrtrfl3Ntfy() {
        return Util.ConvertFlag(this.data, this.tmrtrfl3(), 32);
    }

    public int tmrtrfl4() {
        return Util.ConvertUnsignedBinary1(this.data, 143);
    }

    public boolean tmrtrfl4LocBelow() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 128);
    }

    public boolean tmrtrfl4CicsKey() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 64);
    }

    public boolean tmrtrfl4IsolateNo() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 32);
    }

    public boolean tmrtrfl4Dynamic() {
        return Util.ConvertFlag(this.data, this.tmrtrfl4(), 16);
    }

    public int tmrtrfl5() {
        return Util.ConvertUnsignedBinary1(this.data, 144);
    }

    public int tmrtrfl6() {
        return Util.ConvertUnsignedBinary1(this.data, 145);
    }

    public int tmrtrfl7() {
        return Util.ConvertUnsignedBinary1(this.data, 146);
    }

    public int tmrtrfl8() {
        return Util.ConvertUnsignedBinary1(this.data, 147);
    }

    public boolean tmrtrfl8WaitNo() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 128);
    }

    public boolean tmrtrfl8Commit() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 64);
    }

    public boolean tmrtrfl8IndoubtAct() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 32);
    }

    public boolean tmrtrfl8UowShunt() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 16);
    }

    public boolean tmrtrfl8UowUnshunt() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 8);
    }

    public boolean tmrtrfl8IndbtFail() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 4);
    }

    public boolean tmrtrfl8RoFailure() {
        return Util.ConvertFlag(this.data, this.tmrtrfl8(), 2);
    }

    public TmrNatur tmrnatur() {
        int value = Util.ConvertUnsignedBinary1(this.data, 148);
        return TmrNatur.from(value);
    }

    public int tmrnaturRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 148);
    }

    public TmrSesst tmrsesst() {
        int value = Util.ConvertUnsignedBinary1(this.data, 149);
        return TmrSesst.from(value);
    }

    public int tmrsesstRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 149);
    }

    public TmrAcMth tmracmth() {
        int value = Util.ConvertUnsignedBinary1(this.data, 150);
        return TmrAcMth.from(value);
    }

    public int tmracmthRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 150);
    }

    public int tmrdvtcd() {
        return Util.ConvertUnsignedBinary1(this.data, 151);
    }

    public String tmrtecnm() {
        return Util.ConvertEbcdic(this.data, 152, 4);
    }

    public String tmrbtrid() {
        return Util.ConvertEbcdic(this.data, 156, 4);
    }

    public String tmrurid() {
        return Util.ConvertEbcdic(this.data, 160, 16);
    }

    public String tmrpname() {
        return Util.ConvertEbcdic(this.data, 176, 36);
    }

    public String tmrptype() {
        return Util.ConvertEbcdic(this.data, 212, 8);
    }

    public String tmrprcid() {
        return Util.ConvertEbcdic(this.data, 220, 52);
    }

    public String tmractid() {
        return Util.ConvertEbcdic(this.data, 272, 52);
    }

    public String tmractnm() {
        return Util.ConvertEbcdic(this.data, 324, 16);
    }

    public String tmrcipad() {
        return Util.ConvertEbcdic(this.data, 340, 40);
    }

    public InetAddress tmrcipadAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 340, 40);
    }

    public byte[] tmrtgpid() {
        if (this.data.length >= 408) {
            byte[] result = new byte[28];
            System.arraycopy(this.data, 380, result, 0, 28);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(380) + " Data length: " + Integer.toString(28));
    }

    public String tmrnetid() {
        return Util.ConvertEbcdic(this.data, 408, 8);
    }

    public String tmrrlunm() {
        return Util.ConvertEbcdic(this.data, 416, 8);
    }

    public String tmrtcpsv() {
        return Util.ConvertEbcdic(this.data, 424, 8);
    }

    public long tmrportn() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    public byte[] tmrotsid() {
        if (this.data.length >= 564) {
            byte[] result = new byte[128];
            System.arraycopy(this.data, 436, result, 0, 128);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(436) + " Data length: " + Integer.toString(128));
    }

    public long tmrcipor() {
        return Util.ConvertUnsignedBinary4(this.data, 564);
    }

    public String tmriscnm() {
        return Util.ConvertEbcdic(this.data, 568, 8);
    }

    public String tmronwid() {
        return Util.ConvertEbcdic(this.data, 576, 8);
    }

    public String tmroapid() {
        return Util.ConvertEbcdic(this.data, 584, 8);
    }

    public LocalDateTime tmroattt() {
        return Util.Binary8xStckLocalTime(this.data, 592);
    }

    public BigInteger tmroatttRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 592);
    }

    public String tmrotrsn() {
        return Util.ConvertEbcdic(this.data, 600, 4);
    }

    public String tmrotrid() {
        return Util.ConvertEbcdic(this.data, 604, 4);
    }

    public String tmrousid() {
        return Util.ConvertEbcdic(this.data, 608, 8);
    }

    public byte[] tmrousrc() {
        if (this.data.length >= 680) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 616, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(616) + " Data length: " + Integer.toString(64));
    }

    public String tmrotcps() {
        return Util.ConvertEbcdic(this.data, 680, 8);
    }

    public long tmroprtn() {
        return Util.ConvertUnsignedBinary4(this.data, 688);
    }

    public String tmrocipa() {
        return Util.ConvertEbcdic(this.data, 692, 40);
    }

    public InetAddress tmrocipaAsInetAddress() throws UnknownHostException {
        return Util.ConvertInetTextAddress(this.data, 692, 40);
    }

    public long tmrocpno() {
        return Util.ConvertUnsignedBinary4(this.data, 732);
    }

    public long tmrotrfg() {
        return Util.ConvertUnsignedBinary8(this.data, 736);
    }

    public BigInteger tmrotrfgAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 736);
    }

    public String tmrofcty() {
        return Util.ConvertEbcdic(this.data, 744, 8);
    }

    public String tmrurimn() {
        return Util.ConvertEbcdic(this.data, 752, 8);
    }

    public String tmrpipln() {
        return Util.ConvertEbcdic(this.data, 760, 8);
    }

    public String tmratmsn() {
        return Util.ConvertEbcdic(this.data, 768, 8);
    }

    public String tmrwsvcn() {
        return Util.ConvertEbcdic(this.data, 776, 32);
    }

    public String tmrwsopn() {
        return Util.ConvertEbcdic(this.data, 808, 64);
    }

    public String tmrnjapn() {
        return Util.ConvertEbcdic(this.data, 872, 32);
    }

    public String tmrwpbmn() {
        return Util.ConvertEbcdic(this.data, 904, 8);
    }

    public String tmrphnwd() {
        return Util.ConvertEbcdic(this.data, 912, 8);
    }

    public String tmrphapl() {
        return Util.ConvertEbcdic(this.data, 920, 8);
    }

    public LocalDateTime tmrphatt() {
        return Util.Binary8xStckLocalTime(this.data, 928);
    }

    public BigInteger tmrphattRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 928);
    }

    public String tmrphtsn() {
        return Util.ConvertEbcdic(this.data, 936, 4);
    }

    public String tmrphtid() {
        return Util.ConvertEbcdic(this.data, 940, 4);
    }

    public long tmrphcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 944);
    }

    public String tmradpid() {
        return Util.ConvertEbcdic(this.data, 948, 64);
    }

    public byte[] tmradpd1() {
        if (this.data.length >= 1076) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 1012, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(1012) + " Data length: " + Integer.toString(64));
    }

    public byte[] tmradpd2() {
        if (this.data.length >= 1140) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 1076, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(1076) + " Data length: " + Integer.toString(64));
    }

    public byte[] tmradpd3() {
        if (this.data.length >= 1204) {
            byte[] result = new byte[64];
            System.arraycopy(this.data, 1140, result, 0, 64);
            return result;
        }
        throw new FieldNotPresentException("Field is outside the bounds of the data. Field offset: " + Integer.toString(1140) + " Data length: " + Integer.toString(64));
    }

    public String tmrsoflg() {
        return Util.ConvertEbcdic(this.data, 1204, 4);
    }

    public String tmrsotlv() {
        return Util.ConvertEbcdic(this.data, 1208, 8);
    }

    public long tmrsocph() {
        return Util.ConvertUnsignedBinary4(this.data, 1216);
    }

    public String tmrsocnm() {
        return Util.ConvertEbcdic(this.data, 1220, 4);
    }

    public String tmrcectp() {
        return Util.ConvertEbcdic(this.data, 1224, 4);
    }

    public String tmrcecid() {
        return Util.ConvertEbcdic(this.data, 1228, 16);
    }

    public String tmrlparn() {
        return Util.ConvertEbcdic(this.data, 1244, 8);
    }

    public long tmrmtsks() {
        return Util.ConvertUnsignedBinary4(this.data, 1252);
    }

    public long tmrctsks() {
        return Util.ConvertUnsignedBinary4(this.data, 1256);
    }

    public String tmrappln() {
        return Util.ConvertEbcdic(this.data, 1260, 64);
    }

    public String tmrplatn() {
        return Util.ConvertEbcdic(this.data, 1324, 64);
    }

    public long tmrmajvr() {
        return Util.ConvertUnsignedBinary4(this.data, 1388);
    }

    public long tmrminvr() {
        return Util.ConvertUnsignedBinary4(this.data, 1392);
    }

    public long tmrmicvr() {
        return Util.ConvertUnsignedBinary4(this.data, 1396);
    }

    public String tmropern() {
        return Util.ConvertEbcdic(this.data, 1400, 64);
    }

    public LocalDateTime tmrptatt() {
        return Util.Binary8xStckLocalTime(this.data, 1464);
    }

    public BigInteger tmrptattRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1464);
    }

    public long tmrpttsn() {
        return Util.ConvertUnsignedBinary4(this.data, 1472);
    }

    public String tmrpttid() {
        return Util.ConvertEbcdic(this.data, 1476, 4);
    }

    public long tmrptcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 1480);
    }

    public long tmrttsks() {
        return Util.ConvertUnsignedBinary4(this.data, 1484);
    }

    public long tmrerror() {
        return Util.ConvertUnsignedBinary4(this.data, 1488);
    }

    public String tmrabcdo() {
        return Util.ConvertEbcdic(this.data, 1492, 4);
    }

    public String tmrabcdc() {
        return Util.ConvertEbcdic(this.data, 1496, 4);
    }

    public String tmrtype() {
        return Util.ConvertEbcdic(this.data, 1500, 4);
    }

    public long tmrpinmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1504);
    }

    public long tmrtci1c() {
        return Util.ConvertUnsignedBinary4(this.data, 1508);
    }

    public long tmrpoumc() {
        return Util.ConvertUnsignedBinary4(this.data, 1512);
    }

    public long tmrtco1c() {
        return Util.ConvertUnsignedBinary4(this.data, 1516);
    }

    public long tmrsinmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1520);
    }

    public long tmrtci2c() {
        return Util.ConvertUnsignedBinary4(this.data, 1524);
    }

    public long tmrsoumc() {
        return Util.ConvertUnsignedBinary4(this.data, 1528);
    }

    public long tmrtco2c() {
        return Util.ConvertUnsignedBinary4(this.data, 1532);
    }

    public long tmr62imc() {
        return Util.ConvertUnsignedBinary4(this.data, 1536);
    }

    public long tmr62ich() {
        return Util.ConvertUnsignedBinary4(this.data, 1540);
    }

    public long tmr62omc() {
        return Util.ConvertUnsignedBinary4(this.data, 1544);
    }

    public long tmr62och() {
        return Util.ConvertUnsignedBinary4(this.data, 1548);
    }

    public long tmrtac() {
        return Util.ConvertUnsignedBinary4(this.data, 1552);
    }

    public long tmrscugb() {
        return Util.ConvertUnsignedBinary4(this.data, 1556);
    }

    public long tmrscuga() {
        return Util.ConvertUnsignedBinary4(this.data, 1560);
    }

    public long tmrsccgb() {
        return Util.ConvertUnsignedBinary4(this.data, 1564);
    }

    public long tmrsccga() {
        return Util.ConvertUnsignedBinary4(this.data, 1568);
    }

    public long tmrushwb() {
        return Util.ConvertUnsignedBinary4(this.data, 1572);
    }

    public long tmrushwa() {
        return Util.ConvertUnsignedBinary4(this.data, 1576);
    }

    public long tmrchwmb() {
        return Util.ConvertUnsignedBinary4(this.data, 1580);
    }

    public long tmrchwma() {
        return Util.ConvertUnsignedBinary4(this.data, 1584);
    }

    public long tmrutsob() {
        return Util.ConvertUnsignedBinary8(this.data, 1588);
    }

    public BigInteger tmrutsobAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1588);
    }

    public long tmrutsoa() {
        return Util.ConvertUnsignedBinary8(this.data, 1596);
    }

    public BigInteger tmrutsoaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1596);
    }

    public long tmrcoccb() {
        return Util.ConvertUnsignedBinary8(this.data, 1604);
    }

    public BigInteger tmrcoccbAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1604);
    }

    public long tmrcocca() {
        return Util.ConvertUnsignedBinary8(this.data, 1612);
    }

    public BigInteger tmrcoccaAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 1612);
    }

    public long tmrsc24s() {
        return Util.ConvertUnsignedBinary4(this.data, 1620);
    }

    public long tmrsc24g() {
        return Util.ConvertUnsignedBinary4(this.data, 1624);
    }

    public long tmrsc24f() {
        return Util.ConvertUnsignedBinary4(this.data, 1628);
    }

    public long tmrsc31s() {
        return Util.ConvertUnsignedBinary4(this.data, 1632);
    }

    public long tmrsc31g() {
        return Util.ConvertUnsignedBinary4(this.data, 1636);
    }

    public long tmrsc31f() {
        return Util.ConvertUnsignedBinary4(this.data, 1640);
    }

    public long tmrsccgg() {
        return Util.ConvertUnsignedBinary4(this.data, 1644);
    }

    public long tmrchwmg() {
        return Util.ConvertUnsignedBinary4(this.data, 1648);
    }

    public long tmrscugg() {
        return Util.ConvertUnsignedBinary4(this.data, 1652);
    }

    public long tmruhwmg() {
        return Util.ConvertUnsignedBinary4(this.data, 1656);
    }

    public long tmrsc64s() {
        return Util.ConvertUnsignedBinary4(this.data, 1660);
    }

    public long tmrsc64g() {
        return Util.ConvertUnsignedBinary4(this.data, 1664);
    }

    public long tmrsc64f() {
        return Util.ConvertUnsignedBinary4(this.data, 1668);
    }

    public long tmrpcuse() {
        return Util.ConvertUnsignedBinary4(this.data, 1672);
    }

    public long tmrpc31a() {
        return Util.ConvertUnsignedBinary4(this.data, 1676);
    }

    public long tmrpcusb() {
        return Util.ConvertUnsignedBinary4(this.data, 1680);
    }

    public long tmrpccah() {
        return Util.ConvertUnsignedBinary4(this.data, 1684);
    }

    public long tmrpccbh() {
        return Util.ConvertUnsignedBinary4(this.data, 1688);
    }

    public long tmrpcrah() {
        return Util.ConvertUnsignedBinary4(this.data, 1692);
    }

    public long tmrpcrbh() {
        return Util.ConvertUnsignedBinary4(this.data, 1696);
    }

    public long tmrpcsah() {
        return Util.ConvertUnsignedBinary4(this.data, 1700);
    }

    public long tmrpcsbh() {
        return Util.ConvertUnsignedBinary4(this.data, 1704);
    }

    public long tmrfcgc() {
        return Util.ConvertUnsignedBinary4(this.data, 1708);
    }

    public long tmrfcpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1712);
    }

    public long tmrfcbc() {
        return Util.ConvertUnsignedBinary4(this.data, 1716);
    }

    public long tmrfcac() {
        return Util.ConvertUnsignedBinary4(this.data, 1720);
    }

    public long tmrfcdc() {
        return Util.ConvertUnsignedBinary4(this.data, 1724);
    }

    public long tmrfctc() {
        return Util.ConvertUnsignedBinary4(this.data, 1728);
    }

    public long tmrfcamc() {
        return Util.ConvertUnsignedBinary4(this.data, 1732);
    }

    public long tmrtdgc() {
        return Util.ConvertUnsignedBinary4(this.data, 1736);
    }

    public long tmrtdpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1740);
    }

    public long tmrtdrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1744);
    }

    public long tmrtdtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1748);
    }

    public long tmrtsgc() {
        return Util.ConvertUnsignedBinary4(this.data, 1752);
    }

    public long tmrtspac() {
        return Util.ConvertUnsignedBinary4(this.data, 1756);
    }

    public long tmrtspmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1760);
    }

    public long tmrtsgsc() {
        return Util.ConvertUnsignedBinary4(this.data, 1764);
    }

    public long tmrtspsc() {
        return Util.ConvertUnsignedBinary4(this.data, 1768);
    }

    public long tmrtstc() {
        return Util.ConvertUnsignedBinary4(this.data, 1772);
    }

    public long tmrbmmc() {
        return Util.ConvertUnsignedBinary4(this.data, 1776);
    }

    public long tmrbmic() {
        return Util.ConvertUnsignedBinary4(this.data, 1780);
    }

    public long tmrbmoc() {
        return Util.ConvertUnsignedBinary4(this.data, 1784);
    }

    public long tmrbmtc() {
        return Util.ConvertUnsignedBinary4(this.data, 1788);
    }

    public long tmrpclic() {
        return Util.ConvertUnsignedBinary4(this.data, 1792);
    }

    public long tmrpcxc() {
        return Util.ConvertUnsignedBinary4(this.data, 1796);
    }

    public long tmrpcloc() {
        return Util.ConvertUnsignedBinary4(this.data, 1800);
    }

    public long tmrpcluc() {
        return Util.ConvertUnsignedBinary4(this.data, 1804);
    }

    public long tmrpcdpl() {
        return Util.ConvertUnsignedBinary4(this.data, 1808);
    }

    public long tmrpcdll() {
        return Util.ConvertUnsignedBinary4(this.data, 1812);
    }

    public long tmrpcdrl() {
        return Util.ConvertUnsignedBinary4(this.data, 1816);
    }

    public long tmrpclcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1820);
    }

    public long tmrpcxcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1824);
    }

    public long tmrpcdcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1828);
    }

    public long tmrpcrcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1832);
    }

    public long tmrpcrcl() {
        return Util.ConvertUnsignedBinary4(this.data, 1836);
    }

    public long tmrjnlct() {
        return Util.ConvertUnsignedBinary4(this.data, 1840);
    }

    public long tmrlgwct() {
        return Util.ConvertUnsignedBinary4(this.data, 1844);
    }

    public long tmricc() {
        return Util.ConvertUnsignedBinary4(this.data, 1848);
    }

    public long tmrictc() {
        return Util.ConvertUnsignedBinary4(this.data, 1852);
    }

    public long tmricscc() {
        return Util.ConvertUnsignedBinary4(this.data, 1856);
    }

    public long tmricscd() {
        return Util.ConvertUnsignedBinary4(this.data, 1860);
    }

    public long tmricsrc() {
        return Util.ConvertUnsignedBinary4(this.data, 1864);
    }

    public long tmricsrd() {
        return Util.ConvertUnsignedBinary4(this.data, 1868);
    }

    public long tmrsppc() {
        return Util.ConvertUnsignedBinary4(this.data, 1872);
    }

    public long tmrcfact() {
        return Util.ConvertUnsignedBinary4(this.data, 1876);
    }

    public long tmrszact() {
        return Util.ConvertUnsignedBinary4(this.data, 1880);
    }

    public long tmrszrct() {
        return Util.ConvertUnsignedBinary4(this.data, 1884);
    }

    public long tmrszsct() {
        return Util.ConvertUnsignedBinary4(this.data, 1888);
    }

    public long tmrsztct() {
        return Util.ConvertUnsignedBinary4(this.data, 1892);
    }

    public long tmrszcot() {
        return Util.ConvertUnsignedBinary4(this.data, 1896);
    }

    public long tmrszcin() {
        return Util.ConvertUnsignedBinary4(this.data, 1900);
    }

    public long tmrszato() {
        return Util.ConvertUnsignedBinary4(this.data, 1904);
    }

    public long tmrszrto() {
        return Util.ConvertUnsignedBinary4(this.data, 1908);
    }

    public long tmrsztot() {
        return Util.ConvertUnsignedBinary4(this.data, 1912);
    }

    public long tmrbarsc() {
        return Util.ConvertUnsignedBinary4(this.data, 1916);
    }

    public long tmrbarac() {
        return Util.ConvertUnsignedBinary4(this.data, 1920);
    }

    public long tmrbalkc() {
        return Util.ConvertUnsignedBinary4(this.data, 1924);
    }

    public long tmrbadpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1928);
    }

    public long tmrbadac() {
        return Util.ConvertUnsignedBinary4(this.data, 1932);
    }

    public long tmrbtpac() {
        return Util.ConvertUnsignedBinary4(this.data, 1936);
    }

    public long tmrbspac() {
        return Util.ConvertUnsignedBinary4(this.data, 1940);
    }

    public long tmrbrpac() {
        return Util.ConvertUnsignedBinary4(this.data, 1944);
    }

    public long tmrbdcpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1948);
    }

    public long tmrbaapc() {
        return Util.ConvertUnsignedBinary4(this.data, 1952);
    }

    public long tmrbatpc() {
        return Util.ConvertUnsignedBinary4(this.data, 1956);
    }

    public long tmrbapdc() {
        return Util.ConvertUnsignedBinary4(this.data, 1960);
    }

    public long tmrbaadc() {
        return Util.ConvertUnsignedBinary4(this.data, 1964);
    }

    public long tmrbatcc() {
        return Util.ConvertUnsignedBinary4(this.data, 1968);
    }

    public long tmrbarec() {
        return Util.ConvertUnsignedBinary4(this.data, 1972);
    }

    public long tmrbadic() {
        return Util.ConvertUnsignedBinary4(this.data, 1976);
    }

    public long tmrbatac() {
        return Util.ConvertUnsignedBinary4(this.data, 1980);
    }

    public long tmrbatec() {
        return Util.ConvertUnsignedBinary4(this.data, 1984);
    }

    public long tmrwbrct() {
        return Util.ConvertUnsignedBinary4(this.data, 1988);
    }

    public long tmrwbcin() {
        return Util.ConvertUnsignedBinary4(this.data, 1992);
    }

    public long tmrwbsct() {
        return Util.ConvertUnsignedBinary4(this.data, 1996);
    }

    public long tmrwbcot() {
        return Util.ConvertUnsignedBinary4(this.data, 2000);
    }

    public long tmrwbtc() {
        return Util.ConvertUnsignedBinary4(this.data, 2004);
    }

    public long tmrwbrpr() {
        return Util.ConvertUnsignedBinary4(this.data, 2008);
    }

    public long tmrwbrpw() {
        return Util.ConvertUnsignedBinary4(this.data, 2012);
    }

    public long tmrwberc() {
        return Util.ConvertUnsignedBinary4(this.data, 2016);
    }

    public long tmrwbbrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2020);
    }

    public long tmrwbrrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2024);
    }

    public long tmrwbwrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2028);
    }

    public long tmrdhcrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2032);
    }

    public long tmrdhinc() {
        return Util.ConvertUnsignedBinary4(this.data, 2036);
    }

    public long tmrdhstc() {
        return Util.ConvertUnsignedBinary4(this.data, 2040);
    }

    public long tmrdhrtc() {
        return Util.ConvertUnsignedBinary4(this.data, 2044);
    }

    public long tmrdhdlc() {
        return Util.ConvertUnsignedBinary4(this.data, 2048);
    }

    public long tmrdhtc() {
        return Util.ConvertUnsignedBinary4(this.data, 2052);
    }

    public long tmrdhtdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2056);
    }

    public long tmrsoben() {
        return Util.ConvertUnsignedBinary4(this.data, 2060);
    }

    public long tmrsobde() {
        return Util.ConvertUnsignedBinary4(this.data, 2064);
    }

    public long tmrsoerc() {
        return Util.ConvertUnsignedBinary4(this.data, 2068);
    }

    public long tmrsocns() {
        return Util.ConvertUnsignedBinary4(this.data, 2072);
    }

    public long tmrsonhw() {
        return Util.ConvertUnsignedBinary4(this.data, 2076);
    }

    public long tmrsorct() {
        return Util.ConvertUnsignedBinary4(this.data, 2080);
    }

    public long tmrsocin() {
        return Util.ConvertUnsignedBinary4(this.data, 2084);
    }

    public long tmrsosct() {
        return Util.ConvertUnsignedBinary4(this.data, 2088);
    }

    public long tmrsocot() {
        return Util.ConvertUnsignedBinary4(this.data, 2092);
    }

    public long tmrsotc() {
        return Util.ConvertUnsignedBinary4(this.data, 2096);
    }

    public long tmrsoimc() {
        return Util.ConvertUnsignedBinary4(this.data, 2100);
    }

    public long tmrsoi1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2104);
    }

    public long tmrsoomc() {
        return Util.ConvertUnsignedBinary4(this.data, 2108);
    }

    public long tmrsoo1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2112);
    }

    public long tmrimsrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2116);
    }

    public long tmrdb2rc() {
        return Util.ConvertUnsignedBinary4(this.data, 2120);
    }

    public long tmrwmqrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2124);
    }

    public long tmrtcbac() {
        return Util.ConvertUnsignedBinary4(this.data, 2128);
    }

    public long tmrdsthw() {
        return Util.ConvertUnsignedBinary4(this.data, 2132);
    }

    public long tmrwbroc() {
        return Util.ConvertUnsignedBinary4(this.data, 2136);
    }

    public long tmrwbwoc() {
        return Util.ConvertUnsignedBinary4(this.data, 2140);
    }

    public long tmrwbirc() {
        return Util.ConvertUnsignedBinary4(this.data, 2144);
    }

    public long tmrwbi1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2148);
    }

    public long tmrwbosc() {
        return Util.ConvertUnsignedBinary4(this.data, 2152);
    }

    public long tmrwbo1c() {
        return Util.ConvertUnsignedBinary4(this.data, 2156);
    }

    public long tmrwbprc() {
        return Util.ConvertUnsignedBinary4(this.data, 2160);
    }

    public long tmrwbboc() {
        return Util.ConvertUnsignedBinary4(this.data, 2164);
    }

    public long tmrwbiwc() {
        return Util.ConvertUnsignedBinary4(this.data, 2168);
    }

    public long tmrwbrdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2172);
    }

    public long tmrwbwdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2176);
    }

    public long tmrpgctc() {
        return Util.ConvertUnsignedBinary4(this.data, 2180);
    }

    public long tmrpgbcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2184);
    }

    public long tmrpggcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2188);
    }

    public long tmrpgpcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2192);
    }

    public long tmrpgmcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2196);
    }

    public long tmrpggcl() {
        return Util.ConvertUnsignedBinary4(this.data, 2200);
    }

    public long tmrpgpcl() {
        return Util.ConvertUnsignedBinary4(this.data, 2204);
    }

    public long tmrpgccc() {
        return Util.ConvertUnsignedBinary4(this.data, 2208);
    }

    public long tmrpgcsh() {
        return Util.ConvertUnsignedBinary4(this.data, 2212);
    }

    public long tmrisact() {
        return Util.ConvertUnsignedBinary4(this.data, 2216);
    }

    public long tmreictc() {
        return Util.ConvertUnsignedBinary4(this.data, 2220);
    }

    public long tmrecsge() {
        return Util.ConvertUnsignedBinary4(this.data, 2224);
    }

    public long tmrecfoc() {
        return Util.ConvertUnsignedBinary4(this.data, 2228);
    }

    public long tmrecevc() {
        return Util.ConvertUnsignedBinary4(this.data, 2232);
    }

    public long tmrecsec() {
        return Util.ConvertUnsignedBinary4(this.data, 2236);
    }

    public long tmrtiatc() {
        return Util.ConvertUnsignedBinary4(this.data, 2240);
    }

    public long tmrtitc() {
        return Util.ConvertUnsignedBinary4(this.data, 2244);
    }

    public long tmrbfdgc() {
        return Util.ConvertUnsignedBinary4(this.data, 2248);
    }

    public long tmrbftc() {
        return Util.ConvertUnsignedBinary4(this.data, 2252);
    }

    public long tmrmltdl() {
        return Util.ConvertUnsignedBinary4(this.data, 2256);
    }

    public long tmrmlxtc() {
        return Util.ConvertUnsignedBinary4(this.data, 2260);
    }

    public long tmrwscbc() {
        return Util.ConvertUnsignedBinary4(this.data, 2264);
    }

    public long tmrwscgc() {
        return Util.ConvertUnsignedBinary4(this.data, 2268);
    }

    public long tmrwsepc() {
        return Util.ConvertUnsignedBinary4(this.data, 2272);
    }

    public long tmrwsatc() {
        return Util.ConvertUnsignedBinary4(this.data, 2276);
    }

    public long tmrwsfcc() {
        return Util.ConvertUnsignedBinary4(this.data, 2280);
    }

    public long tmrwsftc() {
        return Util.ConvertUnsignedBinary4(this.data, 2284);
    }

    public long tmrwssfc() {
        return Util.ConvertUnsignedBinary4(this.data, 2288);
    }

    public long tmrwsqbl() {
        return Util.ConvertUnsignedBinary4(this.data, 2292);
    }

    public long tmrwsrbl() {
        return Util.ConvertUnsignedBinary4(this.data, 2296);
    }

    public long tmrjsrql() {
        return Util.ConvertUnsignedBinary4(this.data, 2300);
    }

    public long tmrjsrpl() {
        return Util.ConvertUnsignedBinary4(this.data, 2304);
    }

    public long tmrmpptx() {
        return Util.ConvertUnsignedBinary4(this.data, 2308);
    }

    public long tmrncget() {
        return Util.ConvertUnsignedBinary4(this.data, 2312);
    }

    public long tmrastc() {
        return Util.ConvertUnsignedBinary4(this.data, 2316);
    }

    public long tmrasrnc() {
        return Util.ConvertUnsignedBinary4(this.data, 2320);
    }

    public long tmrasftc() {
        return Util.ConvertUnsignedBinary4(this.data, 2324);
    }

    public long tmrasfrc() {
        return Util.ConvertUnsignedBinary4(this.data, 2328);
    }

    public long tmrmpsre() {
        return Util.ConvertUnsignedBinary4(this.data, 2332);
    }

    public long tmrmpsra() {
        return Util.ConvertUnsignedBinary4(this.data, 2336);
    }

    public long tmrxsnla() {
        return Util.ConvertUnsignedBinary4(this.data, 2340);
    }

    public long tmrxsnlf() {
        return Util.ConvertUnsignedBinary4(this.data, 2344);
    }

    public Duration tmrdist() {
        return Util.Binary8StckInterval(this.data, 2348);
    }

    public double tmrdistSeconds() {
        return Util.ToSeconds(this.tmrdist());
    }

    public long tmrdistRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2348);
    }

    public int tmrdistCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2357);
    }

    public Duration tmrcput() {
        return Util.Binary8StckInterval(this.data, 2360);
    }

    public double tmrcputSeconds() {
        return Util.ToSeconds(this.tmrcput());
    }

    public long tmrcputRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2360);
    }

    public int tmrcputCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2369);
    }

    public Duration tmroncpt() {
        return Util.Binary8StckInterval(this.data, 2372);
    }

    public double tmroncptSeconds() {
        return Util.ToSeconds(this.tmroncpt());
    }

    public long tmroncptRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2372);
    }

    public int tmroncptCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2381);
    }

    public Duration tmrofcpt() {
        return Util.Binary8StckInterval(this.data, 2384);
    }

    public double tmrofcptSeconds() {
        return Util.ToSeconds(this.tmrofcpt());
    }

    public long tmrofcptRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2384);
    }

    public int tmrofcptCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2393);
    }

    public Duration tmrsust() {
        return Util.Binary8StckInterval(this.data, 2396);
    }

    public double tmrsustSeconds() {
        return Util.ToSeconds(this.tmrsust());
    }

    public long tmrsustRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2396);
    }

    public int tmrsustCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2405);
    }

    public Duration tmrdwt() {
        return Util.Binary8StckInterval(this.data, 2408);
    }

    public double tmrdwtSeconds() {
        return Util.ToSeconds(this.tmrdwt());
    }

    public long tmrdwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2408);
    }

    public int tmrdwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2417);
    }

    public Duration tmrqrdsp() {
        return Util.Binary8StckInterval(this.data, 2420);
    }

    public double tmrqrdspSeconds() {
        return Util.ToSeconds(this.tmrqrdsp());
    }

    public long tmrqrdspRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2420);
    }

    public int tmrqrdspCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2429);
    }

    public Duration tmrqrcpu() {
        return Util.Binary8StckInterval(this.data, 2432);
    }

    public double tmrqrcpuSeconds() {
        return Util.ToSeconds(this.tmrqrcpu());
    }

    public long tmrqrcpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2432);
    }

    public int tmrqrcpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2441);
    }

    public Duration tmrmsdsp() {
        return Util.Binary8StckInterval(this.data, 2444);
    }

    public double tmrmsdspSeconds() {
        return Util.ToSeconds(this.tmrmsdsp());
    }

    public long tmrmsdspRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2444);
    }

    public int tmrmsdspCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2453);
    }

    public Duration tmrmscpu() {
        return Util.Binary8StckInterval(this.data, 2456);
    }

    public double tmrmscpuSeconds() {
        return Util.ToSeconds(this.tmrmscpu());
    }

    public long tmrmscpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2456);
    }

    public int tmrmscpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2465);
    }

    public Duration tmrrodsp() {
        return Util.Binary8StckInterval(this.data, 2468);
    }

    public double tmrrodspSeconds() {
        return Util.ToSeconds(this.tmrrodsp());
    }

    public long tmrrodspRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2468);
    }

    public int tmrrodspCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2477);
    }

    public Duration tmrrocpu() {
        return Util.Binary8StckInterval(this.data, 2480);
    }

    public double tmrrocpuSeconds() {
        return Util.ToSeconds(this.tmrrocpu());
    }

    public long tmrrocpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2480);
    }

    public int tmrrocpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2489);
    }

    public Duration tmrky8ds() {
        return Util.Binary8StckInterval(this.data, 2492);
    }

    public double tmrky8dsSeconds() {
        return Util.ToSeconds(this.tmrky8ds());
    }

    public long tmrky8dsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2492);
    }

    public int tmrky8dsCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2501);
    }

    public Duration tmrky8cp() {
        return Util.Binary8StckInterval(this.data, 2504);
    }

    public double tmrky8cpSeconds() {
        return Util.ToSeconds(this.tmrky8cp());
    }

    public long tmrky8cpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2504);
    }

    public int tmrky8cpCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2513);
    }

    public Duration tmrky9ds() {
        return Util.Binary8StckInterval(this.data, 2516);
    }

    public double tmrky9dsSeconds() {
        return Util.ToSeconds(this.tmrky9ds());
    }

    public long tmrky9dsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2516);
    }

    public int tmrky9dsCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2525);
    }

    public Duration tmrky9cp() {
        return Util.Binary8StckInterval(this.data, 2528);
    }

    public double tmrky9cpSeconds() {
        return Util.ToSeconds(this.tmrky9cp());
    }

    public long tmrky9cpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2528);
    }

    public int tmrky9cpCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2537);
    }

    public Duration tmrl8cpu() {
        return Util.Binary8StckInterval(this.data, 2540);
    }

    public double tmrl8cpuSeconds() {
        return Util.ToSeconds(this.tmrl8cpu());
    }

    public long tmrl8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2540);
    }

    public int tmrl8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2549);
    }

    public Duration tmrl9cpu() {
        return Util.Binary8StckInterval(this.data, 2552);
    }

    public double tmrl9cpuSeconds() {
        return Util.ToSeconds(this.tmrl9cpu());
    }

    public long tmrl9cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2552);
    }

    public int tmrl9cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2561);
    }

    public Duration tmrs8cpu() {
        return Util.Binary8StckInterval(this.data, 2564);
    }

    public double tmrs8cpuSeconds() {
        return Util.ToSeconds(this.tmrs8cpu());
    }

    public long tmrs8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2564);
    }

    public int tmrs8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2573);
    }

    public Duration tmrx8cpu() {
        return Util.Binary8StckInterval(this.data, 2576);
    }

    public double tmrx8cpuSeconds() {
        return Util.ToSeconds(this.tmrx8cpu());
    }

    public long tmrx8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2576);
    }

    public int tmrx8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2585);
    }

    public Duration tmrx9cpu() {
        return Util.Binary8StckInterval(this.data, 2588);
    }

    public double tmrx9cpuSeconds() {
        return Util.ToSeconds(this.tmrx9cpu());
    }

    public long tmrx9cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2588);
    }

    public int tmrx9cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2597);
    }

    public Duration tmrt8cpu() {
        return Util.Binary8StckInterval(this.data, 2600);
    }

    public double tmrt8cpuSeconds() {
        return Util.ToSeconds(this.tmrt8cpu());
    }

    public long tmrt8cpuRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2600);
    }

    public int tmrt8cpuCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2609);
    }

    public Duration tmrqrdly() {
        return Util.Binary8StckInterval(this.data, 2612);
    }

    public double tmrqrdlySeconds() {
        return Util.ToSeconds(this.tmrqrdly());
    }

    public long tmrqrdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2612);
    }

    public int tmrqrdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2621);
    }

    public Duration tmrotdly() {
        return Util.Binary8StckInterval(this.data, 2624);
    }

    public double tmrotdlySeconds() {
        return Util.ToSeconds(this.tmrotdly());
    }

    public long tmrotdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2624);
    }

    public int tmrotdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2633);
    }

    public Duration tmrxtdly() {
        return Util.Binary8StckInterval(this.data, 2636);
    }

    public double tmrxtdlySeconds() {
        return Util.ToSeconds(this.tmrxtdly());
    }

    public long tmrxtdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2636);
    }

    public int tmrxtdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2645);
    }

    public Duration tmrstdly() {
        return Util.Binary8StckInterval(this.data, 2648);
    }

    public double tmrstdlySeconds() {
        return Util.ToSeconds(this.tmrstdly());
    }

    public long tmrstdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2648);
    }

    public int tmrstdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2657);
    }

    public Duration tmrttdly() {
        return Util.Binary8StckInterval(this.data, 2660);
    }

    public double tmrttdlySeconds() {
        return Util.ToSeconds(this.tmrttdly());
    }

    public long tmrttdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2660);
    }

    public int tmrttdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2669);
    }

    public Duration tmrdsmwt() {
        return Util.Binary8StckInterval(this.data, 2672);
    }

    public double tmrdsmwtSeconds() {
        return Util.ToSeconds(this.tmrdsmwt());
    }

    public long tmrdsmwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2672);
    }

    public int tmrdsmwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2681);
    }

    public Duration tmrcmdly() {
        return Util.Binary8StckInterval(this.data, 2684);
    }

    public double tmrcmdlySeconds() {
        return Util.ToSeconds(this.tmrcmdly());
    }

    public long tmrcmdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2684);
    }

    public int tmrcmdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2693);
    }

    public Duration tmrexwt() {
        return Util.Binary8StckInterval(this.data, 2696);
    }

    public double tmrexwtSeconds() {
        return Util.ToSeconds(this.tmrexwt());
    }

    public long tmrexwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2696);
    }

    public int tmrexwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2705);
    }

    public Duration tmrtcwt() {
        return Util.Binary8StckInterval(this.data, 2708);
    }

    public double tmrtcwtSeconds() {
        return Util.ToSeconds(this.tmrtcwt());
    }

    public long tmrtcwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2708);
    }

    public int tmrtcwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2717);
    }

    public Duration tmrfcwt() {
        return Util.Binary8StckInterval(this.data, 2720);
    }

    public double tmrfcwtSeconds() {
        return Util.ToSeconds(this.tmrfcwt());
    }

    public long tmrfcwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2720);
    }

    public int tmrfcwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2729);
    }

    public Duration tmrfcxwt() {
        return Util.Binary8StckInterval(this.data, 2732);
    }

    public double tmrfcxwtSeconds() {
        return Util.ToSeconds(this.tmrfcxwt());
    }

    public long tmrfcxwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2732);
    }

    public int tmrfcxwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2741);
    }

    public Duration tmrfcswt() {
        return Util.Binary8StckInterval(this.data, 2744);
    }

    public double tmrfcswtSeconds() {
        return Util.ToSeconds(this.tmrfcswt());
    }

    public long tmrfcswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2744);
    }

    public int tmrfcswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2753);
    }

    public Duration tmrjcwt() {
        return Util.Binary8StckInterval(this.data, 2756);
    }

    public double tmrjcwtSeconds() {
        return Util.ToSeconds(this.tmrjcwt());
    }

    public long tmrjcwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2756);
    }

    public int tmrjcwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2765);
    }

    public Duration tmrtswt() {
        return Util.Binary8StckInterval(this.data, 2768);
    }

    public double tmrtswtSeconds() {
        return Util.ToSeconds(this.tmrtswt());
    }

    public long tmrtswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2768);
    }

    public int tmrtswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2777);
    }

    public Duration tmrirwt() {
        return Util.Binary8StckInterval(this.data, 2780);
    }

    public double tmrirwtSeconds() {
        return Util.ToSeconds(this.tmrirwt());
    }

    public long tmrirwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2780);
    }

    public int tmrirwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2789);
    }

    public Duration tmrtdwt() {
        return Util.Binary8StckInterval(this.data, 2792);
    }

    public double tmrtdwtSeconds() {
        return Util.ToSeconds(this.tmrtdwt());
    }

    public long tmrtdwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2792);
    }

    public int tmrtdwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2801);
    }

    public Duration tmrpclt() {
        return Util.Binary8StckInterval(this.data, 2804);
    }

    public double tmrpcltSeconds() {
        return Util.ToSeconds(this.tmrpclt());
    }

    public long tmrpcltRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2804);
    }

    public int tmrpcltCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2813);
    }

    public Duration tmrfddly() {
        return Util.Binary8StckInterval(this.data, 2816);
    }

    public double tmrfddlySeconds() {
        return Util.ToSeconds(this.tmrfddly());
    }

    public long tmrfddlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2816);
    }

    public int tmrfddlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2825);
    }

    public Duration tmrfdtcl() {
        return Util.Binary8StckInterval(this.data, 2828);
    }

    public double tmrfdtclSeconds() {
        return Util.ToSeconds(this.tmrfdtcl());
    }

    public long tmrfdtclRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2828);
    }

    public int tmrfdtclCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2837);
    }

    public Duration tmrfdmxt() {
        return Util.Binary8StckInterval(this.data, 2840);
    }

    public double tmrfdmxtSeconds() {
        return Util.ToSeconds(this.tmrfdmxt());
    }

    public long tmrfdmxtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2840);
    }

    public int tmrfdmxtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2849);
    }

    public Duration tmrnqdly() {
        return Util.Binary8StckInterval(this.data, 2852);
    }

    public double tmrnqdlySeconds() {
        return Util.ToSeconds(this.tmrnqdly());
    }

    public long tmrnqdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2852);
    }

    public int tmrnqdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2861);
    }

    public Duration tmrgqdly() {
        return Util.Binary8StckInterval(this.data, 2864);
    }

    public double tmrgqdlySeconds() {
        return Util.ToSeconds(this.tmrgqdly());
    }

    public long tmrgqdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2864);
    }

    public int tmrgqdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2873);
    }

    public Duration tmr61wt() {
        return Util.Binary8StckInterval(this.data, 2876);
    }

    public double tmr61wtSeconds() {
        return Util.ToSeconds(this.tmr61wt());
    }

    public long tmr61wtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2876);
    }

    public int tmr61wtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2885);
    }

    public Duration tmr62wt() {
        return Util.Binary8StckInterval(this.data, 2888);
    }

    public double tmr62wtSeconds() {
        return Util.ToSeconds(this.tmr62wt());
    }

    public long tmr62wtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2888);
    }

    public int tmr62wtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2897);
    }

    public Duration tmrszwt() {
        return Util.Binary8StckInterval(this.data, 2900);
    }

    public double tmrszwtSeconds() {
        return Util.ToSeconds(this.tmrszwt());
    }

    public long tmrszwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2900);
    }

    public int tmrszwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2909);
    }

    public Duration tmrrmit() {
        return Util.Binary8StckInterval(this.data, 2912);
    }

    public double tmrrmitSeconds() {
        return Util.ToSeconds(this.tmrrmit());
    }

    public long tmrrmitRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2912);
    }

    public int tmrrmitCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2921);
    }

    public Duration tmrrmis() {
        return Util.Binary8StckInterval(this.data, 2924);
    }

    public double tmrrmisSeconds() {
        return Util.ToSeconds(this.tmrrmis());
    }

    public long tmrrmisRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2924);
    }

    public int tmrrmisCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2933);
    }

    public Duration tmrsynct() {
        return Util.Binary8StckInterval(this.data, 2936);
    }

    public double tmrsynctSeconds() {
        return Util.ToSeconds(this.tmrsynct());
    }

    public long tmrsynctRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2936);
    }

    public int tmrsynctCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2945);
    }

    public Duration tmrrlswt() {
        return Util.Binary8StckInterval(this.data, 2948);
    }

    public double tmrrlswtSeconds() {
        return Util.ToSeconds(this.tmrrlswt());
    }

    public long tmrrlswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2948);
    }

    public int tmrrlswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2957);
    }

    public Duration tmrrlscp() {
        return Util.Binary8StckInterval(this.data, 2960);
    }

    public double tmrrlscpSeconds() {
        return Util.ToSeconds(this.tmrrlscp());
    }

    public long tmrrlscpRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2960);
    }

    public int tmrrlscpCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2969);
    }

    public Duration tmrlmdly() {
        return Util.Binary8StckInterval(this.data, 2972);
    }

    public double tmrlmdlySeconds() {
        return Util.ToSeconds(this.tmrlmdly());
    }

    public long tmrlmdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2972);
    }

    public int tmrlmdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2981);
    }

    public Duration tmrwtxwt() {
        return Util.Binary8StckInterval(this.data, 2984);
    }

    public double tmrwtxwtSeconds() {
        return Util.ToSeconds(this.tmrwtxwt());
    }

    public long tmrwtxwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2984);
    }

    public int tmrwtxwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 2993);
    }

    public Duration tmrwcewt() {
        return Util.Binary8StckInterval(this.data, 2996);
    }

    public double tmrwcewtSeconds() {
        return Util.ToSeconds(this.tmrwcewt());
    }

    public long tmrwcewtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 2996);
    }

    public int tmrwcewtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3005);
    }

    public Duration tmricdly() {
        return Util.Binary8StckInterval(this.data, 3008);
    }

    public double tmricdlySeconds() {
        return Util.ToSeconds(this.tmricdly());
    }

    public long tmricdlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3008);
    }

    public int tmricdlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3017);
    }

    public Duration tmrgvpwt() {
        return Util.Binary8StckInterval(this.data, 3020);
    }

    public double tmrgvpwtSeconds() {
        return Util.ToSeconds(this.tmrgvpwt());
    }

    public long tmrgvpwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3020);
    }

    public int tmrgvpwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3029);
    }

    public Duration tmrtshwt() {
        return Util.Binary8StckInterval(this.data, 3032);
    }

    public double tmrtshwtSeconds() {
        return Util.ToSeconds(this.tmrtshwt());
    }

    public long tmrtshwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3032);
    }

    public int tmrtshwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3041);
    }

    public Duration tmrcdtwt() {
        return Util.Binary8StckInterval(this.data, 3044);
    }

    public double tmrcdtwtSeconds() {
        return Util.ToSeconds(this.tmrcdtwt());
    }

    public long tmrcdtwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3044);
    }

    public int tmrcdtwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3053);
    }

    public Duration tmrsywtt() {
        return Util.Binary8StckInterval(this.data, 3056);
    }

    public double tmrsywttSeconds() {
        return Util.ToSeconds(this.tmrsywtt());
    }

    public long tmrsywttRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3056);
    }

    public int tmrsywttCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3065);
    }

    public Duration tmrrrswt() {
        return Util.Binary8StckInterval(this.data, 3068);
    }

    public double tmrrrswtSeconds() {
        return Util.ToSeconds(this.tmrrrswt());
    }

    public long tmrrrswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3068);
    }

    public int tmrrrswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3077);
    }

    public Duration tmrrtrwt() {
        return Util.Binary8StckInterval(this.data, 3080);
    }

    public double tmrrtrwtSeconds() {
        return Util.ToSeconds(this.tmrrtrwt());
    }

    public long tmrrtrwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3080);
    }

    public int tmrrtrwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3089);
    }

    public Duration tmrsydly() {
        return Util.Binary8StckInterval(this.data, 3092);
    }

    public double tmrsydlySeconds() {
        return Util.ToSeconds(this.tmrsydly());
    }

    public long tmrsydlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3092);
    }

    public int tmrsydlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3101);
    }

    public Duration tmrsowt() {
        return Util.Binary8StckInterval(this.data, 3104);
    }

    public double tmrsowtSeconds() {
        return Util.ToSeconds(this.tmrsowt());
    }

    public long tmrsowtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3104);
    }

    public int tmrsowtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3113);
    }

    public Duration tmrimswt() {
        return Util.Binary8StckInterval(this.data, 3116);
    }

    public double tmrimswtSeconds() {
        return Util.ToSeconds(this.tmrimswt());
    }

    public long tmrimswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3116);
    }

    public int tmrimswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3125);
    }

    public Duration tmrrdqwt() {
        return Util.Binary8StckInterval(this.data, 3128);
    }

    public double tmrrdqwtSeconds() {
        return Util.ToSeconds(this.tmrrdqwt());
    }

    public long tmrrdqwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3128);
    }

    public int tmrrdqwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3137);
    }

    public Duration tmrconwt() {
        return Util.Binary8StckInterval(this.data, 3140);
    }

    public double tmrconwtSeconds() {
        return Util.ToSeconds(this.tmrconwt());
    }

    public long tmrconwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3140);
    }

    public int tmrconwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3149);
    }

    public Duration tmrmqgwt() {
        return Util.Binary8StckInterval(this.data, 3152);
    }

    public double tmrmqgwtSeconds() {
        return Util.ToSeconds(this.tmrmqgwt());
    }

    public long tmrmqgwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3152);
    }

    public int tmrmqgwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3161);
    }

    public Duration tmrjvmt() {
        return Util.Binary8StckInterval(this.data, 3164);
    }

    public double tmrjvmtSeconds() {
        return Util.ToSeconds(this.tmrjvmt());
    }

    public long tmrjvmtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3164);
    }

    public int tmrjvmtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3173);
    }

    public Duration tmrjvms() {
        return Util.Binary8StckInterval(this.data, 3176);
    }

    public double tmrjvmsSeconds() {
        return Util.ToSeconds(this.tmrjvms());
    }

    public long tmrjvmsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3176);
    }

    public int tmrjvmsCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3185);
    }

    public Duration tmrsoowt() {
        return Util.Binary8StckInterval(this.data, 3188);
    }

    public double tmrsoowtSeconds() {
        return Util.ToSeconds(this.tmrsoowt());
    }

    public long tmrsoowtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3188);
    }

    public int tmrsoowtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3197);
    }

    public Duration tmrrqrwt() {
        return Util.Binary8StckInterval(this.data, 3200);
    }

    public double tmrrqrwtSeconds() {
        return Util.ToSeconds(this.tmrrqrwt());
    }

    public long tmrrqrwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3200);
    }

    public int tmrrqrwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3209);
    }

    public Duration tmrrqpwt() {
        return Util.Binary8StckInterval(this.data, 3212);
    }

    public double tmrrqpwtSeconds() {
        return Util.ToSeconds(this.tmrrqpwt());
    }

    public long tmrrqpwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3212);
    }

    public int tmrrqpwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3221);
    }

    public Duration tmroidwt() {
        return Util.Binary8StckInterval(this.data, 3224);
    }

    public double tmroidwtSeconds() {
        return Util.ToSeconds(this.tmroidwt());
    }

    public long tmroidwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3224);
    }

    public int tmroidwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3233);
    }

    public Duration tmrjvmit() {
        return Util.Binary8StckInterval(this.data, 3236);
    }

    public double tmrjvmitSeconds() {
        return Util.ToSeconds(this.tmrjvmit());
    }

    public long tmrjvmitRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3236);
    }

    public int tmrjvmitCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3245);
    }

    public Duration tmrjvmrt() {
        return Util.Binary8StckInterval(this.data, 3248);
    }

    public double tmrjvmrtSeconds() {
        return Util.ToSeconds(this.tmrjvmrt());
    }

    public long tmrjvmrtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3248);
    }

    public int tmrjvmrtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3257);
    }

    public Duration tmrptpwt() {
        return Util.Binary8StckInterval(this.data, 3260);
    }

    public double tmrptpwtSeconds() {
        return Util.ToSeconds(this.tmrptpwt());
    }

    public long tmrptpwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3260);
    }

    public int tmrptpwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3269);
    }

    public Duration tmrdscwt() {
        return Util.Binary8StckInterval(this.data, 3272);
    }

    public double tmrdscwtSeconds() {
        return Util.ToSeconds(this.tmrdscwt());
    }

    public long tmrdscwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3272);
    }

    public int tmrdscwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3281);
    }

    public Duration tmriswt() {
        return Util.Binary8StckInterval(this.data, 3284);
    }

    public double tmriswtSeconds() {
        return Util.ToSeconds(this.tmriswt());
    }

    public long tmriswtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3284);
    }

    public int tmriswtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3293);
    }

    public Duration tmrjstwt() {
        return Util.Binary8StckInterval(this.data, 3296);
    }

    public double tmrjstwtSeconds() {
        return Util.ToSeconds(this.tmrjstwt());
    }

    public long tmrjstwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3296);
    }

    public int tmrjstwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3305);
    }

    public Duration tmrmqast() {
        return Util.Binary8StckInterval(this.data, 3308);
    }

    public double tmrmqastSeconds() {
        return Util.ToSeconds(this.tmrmqast());
    }

    public long tmrmqastRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3308);
    }

    public int tmrmqastCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3317);
    }

    public Duration tmrtdilw() {
        return Util.Binary8StckInterval(this.data, 3320);
    }

    public double tmrtdilwSeconds() {
        return Util.ToSeconds(this.tmrtdilw());
    }

    public long tmrtdilwRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3320);
    }

    public int tmrtdilwCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3329);
    }

    public Duration tmrtdelw() {
        return Util.Binary8StckInterval(this.data, 3332);
    }

    public double tmrtdelwSeconds() {
        return Util.ToSeconds(this.tmrtdelw());
    }

    public long tmrtdelwRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3332);
    }

    public int tmrtdelwCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3341);
    }

    public Duration tmrrodly() {
        return Util.Binary8StckInterval(this.data, 3344);
    }

    public double tmrrodlySeconds() {
        return Util.ToSeconds(this.tmrrodly());
    }

    public long tmrrodlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3344);
    }

    public int tmrrodlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3353);
    }

    public Duration tmrsodly() {
        return Util.Binary8StckInterval(this.data, 3356);
    }

    public double tmrsodlySeconds() {
        return Util.ToSeconds(this.tmrsodly());
    }

    public long tmrsodlyRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3356);
    }

    public int tmrsodlyCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3365);
    }

    public Duration tmrisawt() {
        return Util.Binary8StckInterval(this.data, 3368);
    }

    public double tmrisawtSeconds() {
        return Util.ToSeconds(this.tmrisawt());
    }

    public long tmrisawtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3368);
    }

    public int tmrisawtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3377);
    }

    public Duration tmrtcawt() {
        return Util.Binary8StckInterval(this.data, 3380);
    }

    public double tmrtcawtSeconds() {
        return Util.ToSeconds(this.tmrtcawt());
    }

    public long tmrtcawtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3380);
    }

    public int tmrtcawtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3389);
    }

    public Duration tmrdsawt() {
        return Util.Binary8StckInterval(this.data, 3392);
    }

    public double tmrdsawtSeconds() {
        return Util.ToSeconds(this.tmrdsawt());
    }

    public long tmrdsawtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3392);
    }

    public int tmrdsawtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3401);
    }

    public Duration tmrasfwt() {
        return Util.Binary8StckInterval(this.data, 3404);
    }

    public double tmrasfwtSeconds() {
        return Util.ToSeconds(this.tmrasfwt());
    }

    public long tmrasfwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3404);
    }

    public int tmrasfwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3413);
    }

    public Duration tmrasrwt() {
        return Util.Binary8StckInterval(this.data, 3416);
    }

    public double tmrasrwtSeconds() {
        return Util.ToSeconds(this.tmrasrwt());
    }

    public long tmrasrwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3416);
    }

    public int tmrasrwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3425);
    }

    public Duration tmruriop() {
        return Util.Binary8StckInterval(this.data, 3428);
    }

    public double tmruriopSeconds() {
        return Util.ToSeconds(this.tmruriop());
    }

    public long tmruriopRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3428);
    }

    public int tmruriopCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3437);
    }

    public Duration tmrurirc() {
        return Util.Binary8StckInterval(this.data, 3440);
    }

    public double tmrurircSeconds() {
        return Util.ToSeconds(this.tmrurirc());
    }

    public long tmrurircRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3440);
    }

    public int tmrurircCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3449);
    }

    public Duration tmrurisn() {
        return Util.Binary8StckInterval(this.data, 3452);
    }

    public double tmrurisnSeconds() {
        return Util.ToSeconds(this.tmrurisn());
    }

    public long tmrurisnRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3452);
    }

    public int tmrurisnCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3461);
    }

    public Duration tmrwsinv() {
        return Util.Binary8StckInterval(this.data, 3464);
    }

    public double tmrwsinvSeconds() {
        return Util.ToSeconds(this.tmrwsinv());
    }

    public long tmrwsinvRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3464);
    }

    public int tmrwsinvCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3473);
    }

    public Duration tmrxsvpw() {
        return Util.Binary8StckInterval(this.data, 3476);
    }

    public double tmrxsvpwSeconds() {
        return Util.ToSeconds(this.tmrxsvpw());
    }

    public long tmrxsvpwRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3476);
    }

    public int tmrxsvpwCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3485);
    }

    public Duration tmrxsvke() {
        return Util.Binary8StckInterval(this.data, 3488);
    }

    public double tmrxsvkeSeconds() {
        return Util.ToSeconds(this.tmrxsvke());
    }

    public long tmrxsvkeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3488);
    }

    public int tmrxsvkeCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3497);
    }

    public Duration tmrxsvba() {
        return Util.Binary8StckInterval(this.data, 3500);
    }

    public double tmrxsvbaSeconds() {
        return Util.ToSeconds(this.tmrxsvba());
    }

    public long tmrxsvbaRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3500);
    }

    public int tmrxsvbaCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3509);
    }

    public Duration tmrxsvjw() {
        return Util.Binary8StckInterval(this.data, 3512);
    }

    public double tmrxsvjwSeconds() {
        return Util.ToSeconds(this.tmrxsvjw());
    }

    public long tmrxsvjwRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3512);
    }

    public int tmrxsvjwCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3521);
    }

    public Duration tmrsmmwt() {
        return Util.Binary8StckInterval(this.data, 3524);
    }

    public double tmrsmmwtSeconds() {
        return Util.ToSeconds(this.tmrsmmwt());
    }

    public long tmrsmmwtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 3524);
    }

    public int tmrsmmwtCount() {
        return Util.ConvertUnsignedBinary3(this.data, 3533);
    }

    public static MonitoringTransactionStatistics create(byte[] Data2, int offset, int length) {
        return new MonitoringTransactionStatistics(Data2, offset, length);
    }

    static enum Field {
        mntlen(0, 2),
        mntid(2, 2),
        mntdvers(4, 1),
        tmrtrid(8, 4),
        tmrteid(12, 4),
        tmrusid(16, 8),
        tmrtrty(24, 4),
        tmrattt(28, 8),
        tmrdett(36, 8),
        tmrtrsn(44, 4),
        tmrtpri(48, 4),
        tmrtclsn(52, 8),
        tmrlunm(60, 8),
        tmrpgnm(68, 8),
        tmrnetpx(76, 20),
        tmrnetsx(96, 8),
        tmrrsys(104, 4),
        tmrprcnt(108, 4),
        tmrrmuow(112, 8),
        tmrsrvcl(120, 8),
        tmrrptcl(128, 8),
        tmrfcty(136, 4),
        tmrtrfl1(140, 1),
        tmrtrfl2(141, 1),
        tmrtrfl3(142, 1),
        tmrtrfl4(143, 1),
        tmrtrfl5(144, 1),
        tmrtrfl6(145, 1),
        tmrtrfl7(146, 1),
        tmrtrfl8(147, 1),
        tmrnatur(148, 1),
        tmrsesst(149, 1),
        tmracmth(150, 1),
        tmrdvtcd(151, 1),
        tmrtecnm(152, 4),
        tmrbtrid(156, 4),
        tmrurid(160, 16),
        tmrpname(176, 36),
        tmrptype(212, 8),
        tmrprcid(220, 52),
        tmractid(272, 52),
        tmractnm(324, 16),
        tmrcipad(340, 40),
        tmrtgpid(380, 28),
        tmrnetid(408, 8),
        tmrrlunm(416, 8),
        tmrtcpsv(424, 8),
        tmrportn(432, 4),
        tmrotsid(436, 128),
        tmrcipor(564, 4),
        tmriscnm(568, 8),
        tmronwid(576, 8),
        tmroapid(584, 8),
        tmroattt(592, 8),
        tmrotrsn(600, 4),
        tmrotrid(604, 4),
        tmrousid(608, 8),
        tmrousrc(616, 64),
        tmrotcps(680, 8),
        tmroprtn(688, 4),
        tmrocipa(692, 40),
        tmrocpno(732, 4),
        tmrotrfg(736, 8),
        tmrofcty(744, 8),
        tmrurimn(752, 8),
        tmrpipln(760, 8),
        tmratmsn(768, 8),
        tmrwsvcn(776, 32),
        tmrwsopn(808, 64),
        tmrnjapn(872, 32),
        tmrwpbmn(904, 8),
        tmrphnwd(912, 8),
        tmrphapl(920, 8),
        tmrphatt(928, 8),
        tmrphtsn(936, 4),
        tmrphtid(940, 4),
        tmrphcnt(944, 4),
        tmradpid(948, 64),
        tmradpd1(1012, 64),
        tmradpd2(1076, 64),
        tmradpd3(1140, 64),
        tmrsoflg(1204, 4),
        tmrsotlv(1208, 8),
        tmrsocph(1216, 4),
        tmrsocnm(1220, 4),
        tmrcectp(1224, 4),
        tmrcecid(1228, 16),
        tmrlparn(1244, 8),
        tmrmtsks(1252, 4),
        tmrctsks(1256, 4),
        tmrappln(1260, 64),
        tmrplatn(1324, 64),
        tmrmajvr(1388, 4),
        tmrminvr(1392, 4),
        tmrmicvr(1396, 4),
        tmropern(1400, 64),
        tmrptatt(1464, 8),
        tmrpttsn(1472, 4),
        tmrpttid(1476, 4),
        tmrptcnt(1480, 4),
        tmrttsks(1484, 4),
        tmrerror(1488, 4),
        tmrabcdo(1492, 4),
        tmrabcdc(1496, 4),
        tmrtype(1500, 4),
        tmrpinmc(1504, 4),
        tmrtci1c(1508, 4),
        tmrpoumc(1512, 4),
        tmrtco1c(1516, 4),
        tmrsinmc(1520, 4),
        tmrtci2c(1524, 4),
        tmrsoumc(1528, 4),
        tmrtco2c(1532, 4),
        tmr62imc(1536, 4),
        tmr62ich(1540, 4),
        tmr62omc(1544, 4),
        tmr62och(1548, 4),
        tmrtac(1552, 4),
        tmrscugb(1556, 4),
        tmrscuga(1560, 4),
        tmrsccgb(1564, 4),
        tmrsccga(1568, 4),
        tmrushwb(1572, 4),
        tmrushwa(1576, 4),
        tmrchwmb(1580, 4),
        tmrchwma(1584, 4),
        tmrutsob(1588, 8),
        tmrutsoa(1596, 8),
        tmrcoccb(1604, 8),
        tmrcocca(1612, 8),
        tmrsc24s(1620, 4),
        tmrsc24g(1624, 4),
        tmrsc24f(1628, 4),
        tmrsc31s(1632, 4),
        tmrsc31g(1636, 4),
        tmrsc31f(1640, 4),
        tmrsccgg(1644, 4),
        tmrchwmg(1648, 4),
        tmrscugg(1652, 4),
        tmruhwmg(1656, 4),
        tmrsc64s(1660, 4),
        tmrsc64g(1664, 4),
        tmrsc64f(1668, 4),
        tmrpcuse(1672, 4),
        tmrpc31a(1676, 4),
        tmrpcusb(1680, 4),
        tmrpccah(1684, 4),
        tmrpccbh(1688, 4),
        tmrpcrah(1692, 4),
        tmrpcrbh(1696, 4),
        tmrpcsah(1700, 4),
        tmrpcsbh(1704, 4),
        tmrfcgc(1708, 4),
        tmrfcpc(1712, 4),
        tmrfcbc(1716, 4),
        tmrfcac(1720, 4),
        tmrfcdc(1724, 4),
        tmrfctc(1728, 4),
        tmrfcamc(1732, 4),
        tmrtdgc(1736, 4),
        tmrtdpc(1740, 4),
        tmrtdrc(1744, 4),
        tmrtdtc(1748, 4),
        tmrtsgc(1752, 4),
        tmrtspac(1756, 4),
        tmrtspmc(1760, 4),
        tmrtsgsc(1764, 4),
        tmrtspsc(1768, 4),
        tmrtstc(1772, 4),
        tmrbmmc(1776, 4),
        tmrbmic(1780, 4),
        tmrbmoc(1784, 4),
        tmrbmtc(1788, 4),
        tmrpclic(1792, 4),
        tmrpcxc(1796, 4),
        tmrpcloc(1800, 4),
        tmrpcluc(1804, 4),
        tmrpcdpl(1808, 4),
        tmrpcdll(1812, 4),
        tmrpcdrl(1816, 4),
        tmrpclcc(1820, 4),
        tmrpcxcc(1824, 4),
        tmrpcdcc(1828, 4),
        tmrpcrcc(1832, 4),
        tmrpcrcl(1836, 4),
        tmrjnlct(1840, 4),
        tmrlgwct(1844, 4),
        tmricc(1848, 4),
        tmrictc(1852, 4),
        tmricscc(1856, 4),
        tmricscd(1860, 4),
        tmricsrc(1864, 4),
        tmricsrd(1868, 4),
        tmrsppc(1872, 4),
        tmrcfact(1876, 4),
        tmrszact(1880, 4),
        tmrszrct(1884, 4),
        tmrszsct(1888, 4),
        tmrsztct(1892, 4),
        tmrszcot(1896, 4),
        tmrszcin(1900, 4),
        tmrszato(1904, 4),
        tmrszrto(1908, 4),
        tmrsztot(1912, 4),
        tmrbarsc(1916, 4),
        tmrbarac(1920, 4),
        tmrbalkc(1924, 4),
        tmrbadpc(1928, 4),
        tmrbadac(1932, 4),
        tmrbtpac(1936, 4),
        tmrbspac(1940, 4),
        tmrbrpac(1944, 4),
        tmrbdcpc(1948, 4),
        tmrbaapc(1952, 4),
        tmrbatpc(1956, 4),
        tmrbapdc(1960, 4),
        tmrbaadc(1964, 4),
        tmrbatcc(1968, 4),
        tmrbarec(1972, 4),
        tmrbadic(1976, 4),
        tmrbatac(1980, 4),
        tmrbatec(1984, 4),
        tmrwbrct(1988, 4),
        tmrwbcin(1992, 4),
        tmrwbsct(1996, 4),
        tmrwbcot(2000, 4),
        tmrwbtc(2004, 4),
        tmrwbrpr(2008, 4),
        tmrwbrpw(2012, 4),
        tmrwberc(2016, 4),
        tmrwbbrc(2020, 4),
        tmrwbrrc(2024, 4),
        tmrwbwrc(2028, 4),
        tmrdhcrc(2032, 4),
        tmrdhinc(2036, 4),
        tmrdhstc(2040, 4),
        tmrdhrtc(2044, 4),
        tmrdhdlc(2048, 4),
        tmrdhtc(2052, 4),
        tmrdhtdl(2056, 4),
        tmrsoben(2060, 4),
        tmrsobde(2064, 4),
        tmrsoerc(2068, 4),
        tmrsocns(2072, 4),
        tmrsonhw(2076, 4),
        tmrsorct(2080, 4),
        tmrsocin(2084, 4),
        tmrsosct(2088, 4),
        tmrsocot(2092, 4),
        tmrsotc(2096, 4),
        tmrsoimc(2100, 4),
        tmrsoi1c(2104, 4),
        tmrsoomc(2108, 4),
        tmrsoo1c(2112, 4),
        tmrimsrc(2116, 4),
        tmrdb2rc(2120, 4),
        tmrwmqrc(2124, 4),
        tmrtcbac(2128, 4),
        tmrdsthw(2132, 4),
        tmrwbroc(2136, 4),
        tmrwbwoc(2140, 4),
        tmrwbirc(2144, 4),
        tmrwbi1c(2148, 4),
        tmrwbosc(2152, 4),
        tmrwbo1c(2156, 4),
        tmrwbprc(2160, 4),
        tmrwbboc(2164, 4),
        tmrwbiwc(2168, 4),
        tmrwbrdl(2172, 4),
        tmrwbwdl(2176, 4),
        tmrpgctc(2180, 4),
        tmrpgbcc(2184, 4),
        tmrpggcc(2188, 4),
        tmrpgpcc(2192, 4),
        tmrpgmcc(2196, 4),
        tmrpggcl(2200, 4),
        tmrpgpcl(2204, 4),
        tmrpgccc(2208, 4),
        tmrpgcsh(2212, 4),
        tmrisact(2216, 4),
        tmreictc(2220, 4),
        tmrecsge(2224, 4),
        tmrecfoc(2228, 4),
        tmrecevc(2232, 4),
        tmrecsec(2236, 4),
        tmrtiatc(2240, 4),
        tmrtitc(2244, 4),
        tmrbfdgc(2248, 4),
        tmrbftc(2252, 4),
        tmrmltdl(2256, 4),
        tmrmlxtc(2260, 4),
        tmrwscbc(2264, 4),
        tmrwscgc(2268, 4),
        tmrwsepc(2272, 4),
        tmrwsatc(2276, 4),
        tmrwsfcc(2280, 4),
        tmrwsftc(2284, 4),
        tmrwssfc(2288, 4),
        tmrwsqbl(2292, 4),
        tmrwsrbl(2296, 4),
        tmrjsrql(2300, 4),
        tmrjsrpl(2304, 4),
        tmrmpptx(2308, 4),
        tmrncget(2312, 4),
        tmrastc(2316, 4),
        tmrasrnc(2320, 4),
        tmrasftc(2324, 4),
        tmrasfrc(2328, 4),
        tmrmpsre(2332, 4),
        tmrmpsra(2336, 4),
        tmrxsnla(2340, 4),
        tmrxsnlf(2344, 4),
        tmrdist(2348, 12),
        tmrcput(2360, 12),
        tmroncpt(2372, 12),
        tmrofcpt(2384, 12),
        tmrsust(2396, 12),
        tmrdwt(2408, 12),
        tmrqrdsp(2420, 12),
        tmrqrcpu(2432, 12),
        tmrmsdsp(2444, 12),
        tmrmscpu(2456, 12),
        tmrrodsp(2468, 12),
        tmrrocpu(2480, 12),
        tmrky8ds(2492, 12),
        tmrky8cp(2504, 12),
        tmrky9ds(2516, 12),
        tmrky9cp(2528, 12),
        tmrl8cpu(2540, 12),
        tmrl9cpu(2552, 12),
        tmrs8cpu(2564, 12),
        tmrx8cpu(2576, 12),
        tmrx9cpu(2588, 12),
        tmrt8cpu(2600, 12),
        tmrqrdly(2612, 12),
        tmrotdly(2624, 12),
        tmrxtdly(2636, 12),
        tmrstdly(2648, 12),
        tmrttdly(2660, 12),
        tmrdsmwt(2672, 12),
        tmrcmdly(2684, 12),
        tmrexwt(2696, 12),
        tmrtcwt(2708, 12),
        tmrfcwt(2720, 12),
        tmrfcxwt(2732, 12),
        tmrfcswt(2744, 12),
        tmrjcwt(2756, 12),
        tmrtswt(2768, 12),
        tmrirwt(2780, 12),
        tmrtdwt(2792, 12),
        tmrpclt(2804, 12),
        tmrfddly(2816, 12),
        tmrfdtcl(2828, 12),
        tmrfdmxt(2840, 12),
        tmrnqdly(2852, 12),
        tmrgqdly(2864, 12),
        tmr61wt(2876, 12),
        tmr62wt(2888, 12),
        tmrszwt(2900, 12),
        tmrrmit(2912, 12),
        tmrrmis(2924, 12),
        tmrsynct(2936, 12),
        tmrrlswt(2948, 12),
        tmrrlscp(2960, 12),
        tmrlmdly(2972, 12),
        tmrwtxwt(2984, 12),
        tmrwcewt(2996, 12),
        tmricdly(3008, 12),
        tmrgvpwt(3020, 12),
        tmrtshwt(3032, 12),
        tmrcdtwt(3044, 12),
        tmrsywtt(3056, 12),
        tmrrrswt(3068, 12),
        tmrrtrwt(3080, 12),
        tmrsydly(3092, 12),
        tmrsowt(3104, 12),
        tmrimswt(3116, 12),
        tmrrdqwt(3128, 12),
        tmrconwt(3140, 12),
        tmrmqgwt(3152, 12),
        tmrjvmt(3164, 12),
        tmrjvms(3176, 12),
        tmrsoowt(3188, 12),
        tmrrqrwt(3200, 12),
        tmrrqpwt(3212, 12),
        tmroidwt(3224, 12),
        tmrjvmit(3236, 12),
        tmrjvmrt(3248, 12),
        tmrptpwt(3260, 12),
        tmrdscwt(3272, 12),
        tmriswt(3284, 12),
        tmrjstwt(3296, 12),
        tmrmqast(3308, 12),
        tmrtdilw(3320, 12),
        tmrtdelw(3332, 12),
        tmrrodly(3344, 12),
        tmrsodly(3356, 12),
        tmrisawt(3368, 12),
        tmrtcawt(3380, 12),
        tmrdsawt(3392, 12),
        tmrasfwt(3404, 12),
        tmrasrwt(3416, 12),
        tmruriop(3428, 12),
        tmrurirc(3440, 12),
        tmrurisn(3452, 12),
        tmrwsinv(3464, 12),
        tmrxsvpw(3476, 12),
        tmrxsvke(3488, 12),
        tmrxsvba(3500, 12),
        tmrxsvjw(3512, 12),
        tmrsmmwt(3524, 12);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

