/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.MqgResyncMember;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class MqConnectionGlobalStatistics
extends StatisticsDataSection {
    public static final int MQGidr = 74;
    public static final int MQGvers = 1;
    public static final int MQG_Connected = 1;
    public static final int MQG_Not_Connected = 2;
    public static final int MQGDS_length = 344;

    private MqConnectionGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int mqglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int mqgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int mqgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String mqgQmgrName() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public String mqgMqRelease() {
        return Util.ConvertEbcdic(this.data, 12, 4);
    }

    public int mqgConnectionStatus() {
        return Util.ConvertUnsignedBinary1(this.data, 16);
    }

    public boolean mqgConnected() {
        return Util.ConvertEquateValue(this.data, this.mqgConnectionStatus(), 1);
    }

    public MqgResyncMember mqgResyncmember() {
        int value = Util.ConvertUnsignedBinary1(this.data, 17);
        return MqgResyncMember.from(value);
    }

    public int mqgResyncmemberRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 17);
    }

    public String mqgInitiationQueue() {
        return Util.ConvertEbcdic(this.data, 20, 48);
    }

    public long mqgTTasks() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    @Deprecated
    public long mqgTtasks() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long mqgTFutileAtt() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    @Deprecated
    public long mqgTfutileatt() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public long mqgTApi() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    @Deprecated
    public long mqgTapi() {
        return Util.ConvertUnsignedBinary4(this.data, 76);
    }

    public long mqgTApiOk() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    @Deprecated
    public long mqgTapiok() {
        return Util.ConvertUnsignedBinary4(this.data, 80);
    }

    public long mqgTCall() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    @Deprecated
    public long mqgTcall() {
        return Util.ConvertUnsignedBinary4(this.data, 84);
    }

    public long mqgTCallSyncComp() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    @Deprecated
    public long mqgTcallsynccomp() {
        return Util.ConvertUnsignedBinary4(this.data, 88);
    }

    public long mqgTCallIO() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    @Deprecated
    public long mqgTcallio() {
        return Util.ConvertUnsignedBinary4(this.data, 92);
    }

    public long mqgTWaitMsg() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    @Deprecated
    public long mqgTwaitmsg() {
        return Util.ConvertUnsignedBinary4(this.data, 96);
    }

    public long mqgTSubtasked() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    @Deprecated
    public long mqgTsubtasked() {
        return Util.ConvertUnsignedBinary4(this.data, 100);
    }

    public long mqgTopen() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    public long mqgTclose() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    public long mqgTget() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    public long mqgTgetwait() {
        return Util.ConvertUnsignedBinary4(this.data, 116);
    }

    public long mqgTput() {
        return Util.ConvertUnsignedBinary4(this.data, 120);
    }

    public long mqgTput1() {
        return Util.ConvertUnsignedBinary4(this.data, 124);
    }

    public long mqgTinq() {
        return Util.ConvertUnsignedBinary4(this.data, 128);
    }

    public long mqgTset() {
        return Util.ConvertUnsignedBinary4(this.data, 132);
    }

    public long mqgIndoubtUOW() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    @Deprecated
    public long mqgIndoubtuow() {
        return Util.ConvertUnsignedBinary4(this.data, 136);
    }

    public long mqgUnResolvedUOW() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    @Deprecated
    public long mqgUnresolveduow() {
        return Util.ConvertUnsignedBinary4(this.data, 140);
    }

    public long mqgResolveComm() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    @Deprecated
    public long mqgResolvecomm() {
        return Util.ConvertUnsignedBinary4(this.data, 144);
    }

    public long mqgResolveBack() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    @Deprecated
    public long mqgResolveback() {
        return Util.ConvertUnsignedBinary4(this.data, 148);
    }

    public long mqgTBackUOW() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    @Deprecated
    public long mqgTbackuow() {
        return Util.ConvertUnsignedBinary4(this.data, 152);
    }

    public long mqgTCommUOW() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    @Deprecated
    public long mqgTcommuow() {
        return Util.ConvertUnsignedBinary4(this.data, 156);
    }

    public long mqgTTaskend() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    @Deprecated
    public long mqgTtaskend() {
        return Util.ConvertUnsignedBinary4(this.data, 160);
    }

    public long mqgTSPComm() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    @Deprecated
    public long mqgTspcomm() {
        return Util.ConvertUnsignedBinary4(this.data, 164);
    }

    public long mqgT2PComm() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    @Deprecated
    public long mqgT2pcomm() {
        return Util.ConvertUnsignedBinary4(this.data, 168);
    }

    public long mqgTcb() {
        return Util.ConvertUnsignedBinary4(this.data, 172);
    }

    public long mqgTConsume() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    @Deprecated
    public long mqgTconsume() {
        return Util.ConvertUnsignedBinary4(this.data, 176);
    }

    public long mqgTctl() {
        return Util.ConvertUnsignedBinary4(this.data, 180);
    }

    public long mqgTsub() {
        return Util.ConvertUnsignedBinary4(this.data, 184);
    }

    public long mqgTsubrq() {
        return Util.ConvertUnsignedBinary4(this.data, 188);
    }

    public long mqgTstat() {
        return Util.ConvertUnsignedBinary4(this.data, 192);
    }

    public long mqgTcrtmh() {
        return Util.ConvertUnsignedBinary4(this.data, 196);
    }

    public long mqgTdltmh() {
        return Util.ConvertUnsignedBinary4(this.data, 200);
    }

    public long mqgTsetmp() {
        return Util.ConvertUnsignedBinary4(this.data, 204);
    }

    public long mqgTinqmp() {
        return Util.ConvertUnsignedBinary4(this.data, 208);
    }

    public long mqgTdltmp() {
        return Util.ConvertUnsignedBinary4(this.data, 212);
    }

    public long mqgTmhbuf() {
        return Util.ConvertUnsignedBinary4(this.data, 216);
    }

    public long mqgTbufmh() {
        return Util.ConvertUnsignedBinary4(this.data, 220);
    }

    public String mqgMqconnName() {
        return Util.ConvertEbcdic(this.data, 252, 8);
    }

    public String mqgMqname() {
        return Util.ConvertEbcdic(this.data, 260, 4);
    }

    public ZonedDateTime mqgConnectTimeGmt() {
        return Util.Binary8xStckTime(this.data, 264);
    }

    public BigInteger mqgConnectTimeGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 264);
    }

    public LocalDateTime mqgConnectTimeLocal() {
        return Util.Binary8xStckLocalTime(this.data, 272);
    }

    public BigInteger mqgConnectTimeLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 272);
    }

    public ZonedDateTime mqgDisconnectTimeGmt() {
        return Util.Binary8xStckTime(this.data, 280);
    }

    public BigInteger mqgDisconnectTimeGmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 280);
    }

    public LocalDateTime mqgDisconnectTimeLocal() {
        return Util.Binary8xStckLocalTime(this.data, 288);
    }

    public BigInteger mqgDisconnectTimeLocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 288);
    }

    public String mqgMqconnDefineSource() {
        return Util.ConvertEbcdic(this.data, 296, 8);
    }

    public LocalDateTime mqgMqconnChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 304);
    }

    public BigInteger mqgMqconnChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 304);
    }

    public String mqgMqconnChangeUserid() {
        return Util.ConvertEbcdic(this.data, 312, 8);
    }

    public CIAgent mqgMqconnChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 320);
        return CIAgent.from(value);
    }

    public int mqgMqconnChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 320);
    }

    public CIAgent mqgMqconnInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 322);
        return CIAgent.from(value);
    }

    public int mqgMqconnInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 322);
    }

    public LocalDateTime mqgMqconnInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 324);
    }

    public BigInteger mqgMqconnInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 324);
    }

    public String mqgMqconnInstallUserid() {
        return Util.ConvertEbcdic(this.data, 332, 8);
    }

    public static MqConnectionGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new MqConnectionGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        mqglen(0, 2),
        mqgid(2, 2),
        mqgdvers(4, 1),
        mqgQmgrName(8, 4),
        mqgMqRelease(12, 4),
        mqgConnectionStatus(16, 1),
        mqgResyncmember(17, 1),
        mqgInitiationQueue(20, 48),
        mqgTTasks(68, 4),
        mqgTFutileAtt(72, 4),
        mqgTApi(76, 4),
        mqgTApiOk(80, 4),
        mqgTCall(84, 4),
        mqgTCallSyncComp(88, 4),
        mqgTCallIO(92, 4),
        mqgTWaitMsg(96, 4),
        mqgTSubtasked(100, 4),
        mqgTopen(104, 4),
        mqgTclose(108, 4),
        mqgTget(112, 4),
        mqgTgetwait(116, 4),
        mqgTput(120, 4),
        mqgTput1(124, 4),
        mqgTinq(128, 4),
        mqgTset(132, 4),
        mqgIndoubtUOW(136, 4),
        mqgUnResolvedUOW(140, 4),
        mqgResolveComm(144, 4),
        mqgResolveBack(148, 4),
        mqgTBackUOW(152, 4),
        mqgTCommUOW(156, 4),
        mqgTTaskend(160, 4),
        mqgTSPComm(164, 4),
        mqgT2PComm(168, 4),
        mqgTcb(172, 4),
        mqgTConsume(176, 4),
        mqgTctl(180, 4),
        mqgTsub(184, 4),
        mqgTsubrq(188, 4),
        mqgTstat(192, 4),
        mqgTcrtmh(196, 4),
        mqgTdltmh(200, 4),
        mqgTsetmp(204, 4),
        mqgTinqmp(208, 4),
        mqgTdltmp(212, 4),
        mqgTmhbuf(216, 4),
        mqgTbufmh(220, 4),
        mqgMqconnName(252, 8),
        mqgMqname(260, 4),
        mqgConnectTimeGmt(264, 8),
        mqgConnectTimeLocal(272, 8),
        mqgDisconnectTimeGmt(280, 8),
        mqgDisconnectTimeLocal(288, 8),
        mqgMqconnDefineSource(296, 8),
        mqgMqconnChangeTime(304, 8),
        mqgMqconnChangeUserid(312, 8),
        mqgMqconnChangeAgent(320, 2),
        mqgMqconnInstallAgent(322, 2),
        mqgMqconnInstallTime(324, 8),
        mqgMqconnInstallUserid(332, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

