/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class PublicJvmProgramStatistics
extends StatisticsDataSection {
    public static final int PGRDS_LENGTH = 312;
    public static final int PGR_IDR = 119;
    public static final int PGR_VERS = 1;
    public static final int PGR_ENTRYPOINT_NO = 1;
    public static final int PGR_ENTRYPOINT_YES = 2;

    private PublicJvmProgramStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int pgrdsLen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int pgrdsId() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int pgrdsVers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String pgrJvmprogramName() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public int pgrJvmprogramEntrypoint() {
        return Util.ConvertUnsignedBinary1(this.data, 23);
    }

    public long pgrJvmprogramUsecount() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public int pgrJvmprogramExecKey() {
        return Util.ConvertUnsignedBinary1(this.data, 28);
    }

    public String pgrJvmprogramJvmclass() {
        return Util.ConvertEbcdic(this.data, 32, 255);
    }

    public String pgrJvmprogramServer() {
        return Util.ConvertEbcdic(this.data, 288, 8);
    }

    public boolean pgrEntrypointYes() {
        return Util.ConvertEquateValue(this.data, this.pgrJvmprogramEntrypoint(), 2);
    }

    public static PublicJvmProgramStatistics create(byte[] Data2, int offset, int length) {
        return new PublicJvmProgramStatistics(Data2, offset, length);
    }

    static enum Field {
        pgrdsLen(0, 2),
        pgrdsId(2, 2),
        pgrdsVers(4, 1),
        pgrJvmprogramName(8, 8),
        pgrJvmprogramEntrypoint(23, 1),
        pgrJvmprogramUsecount(24, 4),
        pgrJvmprogramExecKey(28, 1),
        pgrJvmprogramJvmclass(32, 255),
        pgrJvmprogramServer(288, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

