/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import java.util.HashMap;
import java.util.Map;

public enum Stid {
    STIXMG(10),
    STIXMR(11),
    STIXMC(12),
    STIFEPIP(16),
    STIFEPIC(17),
    STIFEPIT(18),
    STISMD(19),
    STISMT(20),
    STIVT(21),
    STIPAUTO(23),
    STIAUTO(24),
    STILDR(25),
    STIDBUSS(28),
    STISMDSA(29),
    STILDG(30),
    STILDB(31),
    STILDY(32),
    STITCR(34),
    STILDP(36),
    STILSRR(39),
    STILSRFR(40),
    STITDQR(42),
    STITDQG(45),
    STISECUR(46),
    STITSQ(48),
    STICONSR(52),
    STICONSS(54),
    STIUSG(61),
    STIDS(62),
    STITM(63),
    STIDST(64),
    STIDSR(65),
    STIST(66),
    STIFCR(67),
    STIMQG(74),
    STICONMR(76),
    STIM(81),
    STIMNR(84),
    STITDR(85),
    STITDG(87),
    STISDR(88),
    STISDG(90),
    STILGG(92),
    STILGR(93),
    STILGS(94),
    STINQG(97),
    STIRMG(99),
    STIRLR(100),
    STIWBG(101),
    STID2G(102),
    STID2R(103),
    STIWBR(104),
    STIPIR(105),
    STIPIW(106),
    STISOG(107),
    STISOR(108),
    STIISR(109),
    STIW2R(110),
    STIDHD(112),
    STIMLR(113),
    STISJS(116),
    STISJG(117),
    STISJR(118),
    STIPGR(119),
    STIPGD(120),
    STIECG(140),
    STIECR(141),
    STIEPG(142),
    STIECC(143),
    STIEPR(144),
    STIMPR(145),
    STIPGP(146),
    STIPGE(147),
    STIMQR(148),
    STIASG(149),
    STINDJ(150),
    STICIP(151),
    _41(41, "41"),
    _53(53, "53"),
    _60(60, "60"),
    _82(82, "82"),
    _121(121, "121"),
    _122(122, "122"),
    _123(123, "123"),
    _124(124, "124"),
    _125(125, "125"),
    _126(126, "126"),
    _127(127, "127"),
    _128(128, "128"),
    _129(129, "129"),
    NOT_DEFINED(-1);

    private static Map<Integer, Stid> valueMap;
    private final transient int stid;
    private final transient String stidString;

    private Stid(int Stid2) {
        this.stid = Stid2;
        this.stidString = null;
    }

    private Stid(int Stid2, String stidString) {
        this.stid = Stid2;
        this.stidString = stidString;
    }

    public String toString() {
        if (this.stidString != null) {
            return this.stidString;
        }
        return this.name();
    }

    public static Stid from(int value) {
        Stid result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    public int value() {
        if (this.stid == -1) {
            throw new IllegalArgumentException("This STID is not defined to EasySMF");
        }
        return this.stid;
    }

    static {
        valueMap = new HashMap<Integer, Stid>();
        for (Stid x : Stid.values()) {
            if (x.stid < 0) continue;
            if (valueMap.containsKey(x.stid)) {
                throw new IllegalArgumentException("Duplicate STID ID");
            }
            valueMap.put(x.stid, x);
        }
    }
}

