/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.SmfData;
import com.blackhillsoftware.smf.cics.statistics.values.SmsMemlimitSrc;
import com.blackhillsoftware.smf.cics.statistics.values.SmsState;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class StorageManagerGlobalStatistics
extends SmfData {
    public static final int SMSSTGPROTNA = 0;
    public static final int SMSSTGPROTA = 1;
    public static final int SMSRENTPGMNP = 0;
    public static final int SMSRENTPGMP = 1;
    public static final int SMSTRANISONA = 0;
    public static final int SMSTRANISOA = 1;

    private StorageManagerGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int smsgbllen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    static int smsgbllen(byte[] data, int offset) {
        return Util.ConvertUnsignedBinary2(data, offset + 0);
    }

    public int smsnpagp() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int smsstgprot() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public int smsrentpgm() {
        return Util.ConvertUnsignedBinary1(this.data, 5);
    }

    public int smstraniso() {
        return Util.ConvertUnsignedBinary1(this.data, 6);
    }

    public SmsMemlimitSrc smsmemlimitsrc() {
        int value = Util.ConvertUnsignedBinary1(this.data, 7);
        return SmsMemlimitSrc.from(value);
    }

    public int smsmemlimitsrcRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 7);
    }

    public long smsusscur() {
        return Util.ConvertUnsignedBinary4(this.data, 8);
    }

    public long smsusscum() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long smsusshwm() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long smscsscur() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long smscsscum() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long smscsshwm() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long smsdsalimit() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long smsedsalimit() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long smsdsatotal() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long smsedsatotal() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long smshwmdsatotal() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long smshwmedsatotal() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public Duration smstimewaitmvs() {
        return Util.Binary8StckInterval(this.data, 56);
    }

    public double smstimewaitmvsSeconds() {
        return Util.ToSeconds(this.smstimewaitmvs());
    }

    public long smstimewaitmvsRawValue() {
        return Util.ConvertSignedBinary8(this.data, 56);
    }

    public long smsmvsstgreqwaits() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long smsmemlimit() {
        return Util.ConvertUnsignedBinary8(this.data, 80);
    }

    public BigInteger smsmemlimitAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 80);
    }

    public long smsgetstorsize() {
        return Util.ConvertUnsignedBinary8(this.data, 88);
    }

    public BigInteger smsgetstorsizeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 88);
    }

    public long smsasactive() {
        return Util.ConvertUnsignedBinary8(this.data, 96);
    }

    public BigInteger smsasactiveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 96);
    }

    public long smshwmasactive() {
        return Util.ConvertUnsignedBinary8(this.data, 104);
    }

    public BigInteger smshwmasactiveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 104);
    }

    public long smsgdsaactive() {
        return Util.ConvertUnsignedBinary8(this.data, 112);
    }

    public BigInteger smsgdsaactiveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 112);
    }

    public long smshwmgdsaactive() {
        return Util.ConvertUnsignedBinary8(this.data, 120);
    }

    public BigInteger smshwmgdsaactiveAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 120);
    }

    public long smsgdsaalloc() {
        return Util.ConvertUnsignedBinary8(this.data, 128);
    }

    public BigInteger smsgdsaallocAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 128);
    }

    public long smshwmgdsaalloc() {
        return Util.ConvertUnsignedBinary8(this.data, 136);
    }

    public BigInteger smshwmgdsaallocAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public long smslvabytes() {
        return Util.ConvertUnsignedBinary8(this.data, 176);
    }

    public BigInteger smslvabytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 176);
    }

    public long smslvhbytes() {
        return Util.ConvertUnsignedBinary8(this.data, 184);
    }

    public BigInteger smslvhbytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 184);
    }

    public long smslvgbytes() {
        return Util.ConvertUnsignedBinary8(this.data, 192);
    }

    public BigInteger smslvgbytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 192);
    }

    public long smslvnmemobj() {
        return Util.ConvertUnsignedBinary8(this.data, 200);
    }

    public BigInteger smslvnmemobjAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 200);
    }

    public long smsfromguardfail() {
        return Util.ConvertUnsignedBinary8(this.data, 216);
    }

    public BigInteger smsfromguardfailAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 216);
    }

    public long smsfromguardfailsize() {
        return Util.ConvertUnsignedBinary8(this.data, 224);
    }

    public BigInteger smsfromguardfailsizeAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 224);
    }

    public long smslvshrbytes() {
        return Util.ConvertUnsignedBinary8(this.data, 240);
    }

    public BigInteger smslvshrbytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 240);
    }

    public long smslvshrgbytes() {
        return Util.ConvertUnsignedBinary8(this.data, 248);
    }

    public BigInteger smslvshrgbytesAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 248);
    }

    public long smslvshrnmemobj() {
        return Util.ConvertUnsignedBinary8(this.data, 256);
    }

    public BigInteger smslvshrnmemobjAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 256);
    }

    public long smshvauxslots() {
        return Util.ConvertUnsignedBinary8(this.data, 272);
    }

    public BigInteger smshvauxslotsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 272);
    }

    public long smshvgauxslots() {
        return Util.ConvertUnsignedBinary8(this.data, 280);
    }

    public BigInteger smshvgauxslotsAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 280);
    }

    public long smshvpagesinreal() {
        return Util.ConvertUnsignedBinary8(this.data, 288);
    }

    public BigInteger smshvpagesinrealAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 288);
    }

    public long smshvgpagesinreal() {
        return Util.ConvertUnsignedBinary8(this.data, 296);
    }

    public BigInteger smshvgpagesinrealAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 296);
    }

    public long smslargememobj() {
        return Util.ConvertUnsignedBinary8(this.data, 304);
    }

    public BigInteger smslargememobjAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 304);
    }

    public long smslargepagesinreal() {
        return Util.ConvertUnsignedBinary8(this.data, 312);
    }

    public BigInteger smslargepagesinrealAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 312);
    }

    public ZonedDateTime smsmvsmonsamplelasttimegmt() {
        return Util.Binary8xStckTime(this.data, 352);
    }

    public BigInteger smsmvsmonsamplelasttimegmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 352);
    }

    public LocalDateTime smsmvsmonsamplelasttimelocal() {
        return Util.Binary8xStckLocalTime(this.data, 360);
    }

    public BigInteger smsmvsmonsamplelasttimelocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 360);
    }

    public SmsState smsmvs24state() {
        int value = Util.ConvertUnsignedBinary1(this.data, 384);
        return SmsState.from(value);
    }

    public int smsmvs24stateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 384);
    }

    public long smsmvs24totalunalloc() {
        return Util.ConvertUnsignedBinary4(this.data, 388);
    }

    public long smsmvs24totalunalloclwm() {
        return Util.ConvertUnsignedBinary4(this.data, 392);
    }

    public long smsmvs24largestunalloc() {
        return Util.ConvertUnsignedBinary4(this.data, 396);
    }

    public long smsmvs24largestunalloclwm() {
        return Util.ConvertUnsignedBinary4(this.data, 400);
    }

    public ZonedDateTime smsmvs24lastsostimegmt() {
        return Util.Binary8xStckTime(this.data, 408);
    }

    public BigInteger smsmvs24lastsostimegmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 408);
    }

    public LocalDateTime smsmvs24lastsostimelocal() {
        return Util.Binary8xStckLocalTime(this.data, 416);
    }

    public BigInteger smsmvs24lastsostimelocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 416);
    }

    public Duration smsmvs24waittime() {
        return Util.Binary8StckInterval(this.data, 424);
    }

    public double smsmvs24waittimeSeconds() {
        return Util.ToSeconds(this.smsmvs24waittime());
    }

    public long smsmvs24waittimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 424);
    }

    public long smsmvs24numwaits() {
        return Util.ConvertUnsignedBinary4(this.data, 432);
    }

    public long smsmvs24numwaitshwm() {
        return Util.ConvertUnsignedBinary4(this.data, 436);
    }

    public long smsmvs24totalnumwaits() {
        return Util.ConvertUnsignedBinary4(this.data, 440);
    }

    public long smsmvs24soscount() {
        return Util.ConvertUnsignedBinary4(this.data, 444);
    }

    public Duration smsmvs24sostime() {
        return Util.Binary8StckInterval(this.data, 448);
    }

    public double smsmvs24sostimeSeconds() {
        return Util.ToSeconds(this.smsmvs24sostime());
    }

    public long smsmvs24sostimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 448);
    }

    public SmsState smsmvs31state() {
        int value = Util.ConvertUnsignedBinary1(this.data, 472);
        return SmsState.from(value);
    }

    public int smsmvs31stateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 472);
    }

    public long smsmvs31totalunalloc() {
        return Util.ConvertUnsignedBinary4(this.data, 476);
    }

    public long smsmvs31totalunalloclwm() {
        return Util.ConvertUnsignedBinary4(this.data, 480);
    }

    public long smsmvs31largestunalloc() {
        return Util.ConvertUnsignedBinary4(this.data, 484);
    }

    public long smsmvs31largestunalloclwm() {
        return Util.ConvertUnsignedBinary4(this.data, 488);
    }

    public ZonedDateTime smsmvs31lastsostimegmt() {
        return Util.Binary8xStckTime(this.data, 496);
    }

    public BigInteger smsmvs31lastsostimegmtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 496);
    }

    public LocalDateTime smsmvs31lastsostimelocal() {
        return Util.Binary8xStckLocalTime(this.data, 504);
    }

    public BigInteger smsmvs31lastsostimelocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 504);
    }

    public Duration smsmvs31waittime() {
        return Util.Binary8StckInterval(this.data, 512);
    }

    public double smsmvs31waittimeSeconds() {
        return Util.ToSeconds(this.smsmvs31waittime());
    }

    public long smsmvs31waittimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 512);
    }

    public long smsmvs31numwaits() {
        return Util.ConvertUnsignedBinary4(this.data, 520);
    }

    public long smsmvs31numwaitshwm() {
        return Util.ConvertUnsignedBinary4(this.data, 524);
    }

    public long smsmvs31totalnumwaits() {
        return Util.ConvertUnsignedBinary4(this.data, 528);
    }

    public long smsmvs31soscount() {
        return Util.ConvertUnsignedBinary4(this.data, 532);
    }

    public Duration smsmvs31sostime() {
        return Util.Binary8StckInterval(this.data, 536);
    }

    public double smsmvs31sostimeSeconds() {
        return Util.ToSeconds(this.smsmvs31sostime());
    }

    public long smsmvs31sostimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 536);
    }

    public SmsState smsmvs64state() {
        int value = Util.ConvertUnsignedBinary1(this.data, 560);
        return SmsState.from(value);
    }

    public int smsmvs64stateRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 560);
    }

    public long smsmvs64soscount() {
        return Util.ConvertUnsignedBinary4(this.data, 564);
    }

    public Duration smsmvs64sostime() {
        return Util.Binary8StckInterval(this.data, 568);
    }

    public double smsmvs64sostimeSeconds() {
        return Util.ToSeconds(this.smsmvs64sostime());
    }

    public long smsmvs64sostimeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 568);
    }

    public long smsmvs64unalloc() {
        return Util.ConvertUnsignedBinary8(this.data, 576);
    }

    public BigInteger smsmvs64unallocAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 576);
    }

    public long smsmvs64unalloclwm() {
        return Util.ConvertUnsignedBinary8(this.data, 584);
    }

    public BigInteger smsmvs64unalloclwmAsBigInteger() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 584);
    }

    public ZonedDateTime smsmvs64lastsostimeutc() {
        return Util.Binary8xStckTime(this.data, 592);
    }

    public BigInteger smsmvs64lastsostimeutcRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 592);
    }

    public LocalDateTime smsmvs64lastsostimelocal() {
        return Util.Binary8xStckLocalTime(this.data, 600);
    }

    public BigInteger smsmvs64lastsostimelocalRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 600);
    }

    public boolean smsstgprota() {
        return Util.ConvertEquateValue(this.data, this.smsstgprot(), 1);
    }

    public boolean smsrentpgmp() {
        return Util.ConvertEquateValue(this.data, this.smsrentpgm(), 1);
    }

    public boolean smstranisoa() {
        return Util.ConvertEquateValue(this.data, this.smstraniso(), 1);
    }

    public static StorageManagerGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new StorageManagerGlobalStatistics(Data2, offset, length);
    }

    static enum Field {
        smsgbllen(0, 2),
        smsnpagp(2, 2),
        smsstgprot(4, 1),
        smsrentpgm(5, 1),
        smstraniso(6, 1),
        smsmemlimitsrc(7, 1),
        smsusscur(8, 4),
        smsusscum(12, 4),
        smsusshwm(16, 4),
        smscsscur(20, 4),
        smscsscum(24, 4),
        smscsshwm(28, 4),
        smsdsalimit(32, 4),
        smsedsalimit(36, 4),
        smsdsatotal(40, 4),
        smsedsatotal(44, 4),
        smshwmdsatotal(48, 4),
        smshwmedsatotal(52, 4),
        smstimewaitmvs(56, 8),
        smsmvsstgreqwaits(64, 4),
        smsmemlimit(80, 8),
        smsgetstorsize(88, 8),
        smsasactive(96, 8),
        smshwmasactive(104, 8),
        smsgdsaactive(112, 8),
        smshwmgdsaactive(120, 8),
        smsgdsaalloc(128, 8),
        smshwmgdsaalloc(136, 8),
        smslvabytes(176, 8),
        smslvhbytes(184, 8),
        smslvgbytes(192, 8),
        smslvnmemobj(200, 8),
        smsfromguardfail(216, 8),
        smsfromguardfailsize(224, 8),
        smslvshrbytes(240, 8),
        smslvshrgbytes(248, 8),
        smslvshrnmemobj(256, 8),
        smshvauxslots(272, 8),
        smshvgauxslots(280, 8),
        smshvpagesinreal(288, 8),
        smshvgpagesinreal(296, 8),
        smslargememobj(304, 8),
        smslargepagesinreal(312, 8),
        smsmvsmonsamplelasttimegmt(352, 8),
        smsmvsmonsamplelasttimelocal(360, 8),
        smsmvs24state(384, 1),
        smsmvs24totalunalloc(388, 4),
        smsmvs24totalunalloclwm(392, 4),
        smsmvs24largestunalloc(396, 4),
        smsmvs24largestunalloclwm(400, 4),
        smsmvs24lastsostimegmt(408, 8),
        smsmvs24lastsostimelocal(416, 8),
        smsmvs24waittime(424, 8),
        smsmvs24numwaits(432, 4),
        smsmvs24numwaitshwm(436, 4),
        smsmvs24totalnumwaits(440, 4),
        smsmvs24soscount(444, 4),
        smsmvs24sostime(448, 8),
        smsmvs31state(472, 1),
        smsmvs31totalunalloc(476, 4),
        smsmvs31totalunalloclwm(480, 4),
        smsmvs31largestunalloc(484, 4),
        smsmvs31largestunalloclwm(488, 4),
        smsmvs31lastsostimegmt(496, 8),
        smsmvs31lastsostimelocal(504, 8),
        smsmvs31waittime(512, 8),
        smsmvs31numwaits(520, 4),
        smsmvs31numwaitshwm(524, 4),
        smsmvs31totalnumwaits(528, 4),
        smsmvs31soscount(532, 4),
        smsmvs31sostime(536, 8),
        smsmvs64state(560, 1),
        smsmvs64soscount(564, 4),
        smsmvs64sostime(568, 8),
        smsmvs64unalloc(576, 8),
        smsmvs64unalloclwm(584, 8),
        smsmvs64lastsostimeutc(592, 8),
        smsmvs64lastsostimelocal(600, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

