/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class TerminalStatistics
extends StatisticsDataSection {
    public static final int A06IDR = 34;
    public static final int A06IDL = 82;
    public static final int A06VERS = 1;
    public static final int A06CLEN = 108;

    private TerminalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int a06len() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int a06id() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int a06dvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String a06teti() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public int a06tett() {
        return Util.ConvertUnsignedBinary1(this.data, 12);
    }

    public int a06eamib() {
        return Util.ConvertUnsignedBinary1(this.data, 13);
    }

    public int a06lenp() {
        return Util.ConvertPacked4(this.data, 16);
    }

    public long a06teni() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long a06teno() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long a06teot() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long a06csvc() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long a06tete() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long a06teoe() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long a06tcnt() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long a06scnt() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public int a06mcnt() {
        return Util.ConvertUnsignedBinary2(this.data, 52);
    }

    public String a06lunam() {
        return Util.ConvertEbcdic(this.data, 56, 8);
    }

    public String a06prty() {
        return Util.ConvertEbcdic(this.data, 64, 1);
    }

    public long a06stg() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public String a06sysid() {
        return Util.ConvertEbcdic(this.data, 72, 4);
    }

    public LocalDateTime a06ontm() {
        return Util.Binary8xStckLocalTime(this.data, 76);
    }

    public BigInteger a06ontmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 76);
    }

    public LocalDateTime a06offtm() {
        return Util.Binary8xStckLocalTime(this.data, 84);
    }

    public BigInteger a06offtmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 84);
    }

    public ZonedDateTime a06gontm() {
        return Util.Binary8xStckTime(this.data, 92);
    }

    public BigInteger a06gontmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public ZonedDateTime a06goftm() {
        return Util.Binary8xStckTime(this.data, 100);
    }

    public BigInteger a06goftmRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 100);
    }

    public static TerminalStatistics create(byte[] Data2, int offset, int length) {
        return new TerminalStatistics(Data2, offset, length);
    }

    static enum Field {
        a06len(0, 2),
        a06id(2, 2),
        a06dvers(4, 1),
        a06teti(8, 4),
        a06tett(12, 1),
        a06eamib(13, 1),
        a06lenp(16, 4),
        a06teni(20, 4),
        a06teno(24, 4),
        a06teot(28, 4),
        a06csvc(32, 4),
        a06tete(36, 4),
        a06teoe(40, 4),
        a06tcnt(44, 4),
        a06scnt(48, 4),
        a06mcnt(52, 2),
        a06lunam(56, 8),
        a06prty(64, 1),
        a06stg(68, 4),
        a06sysid(72, 4),
        a06ontm(76, 8),
        a06offtm(84, 8),
        a06gontm(92, 8),
        a06goftm(100, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

