/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.internal.Util;

public final class TransactionDumpcodeStatistics
extends StatisticsDataSection {
    public static final int TDRIDE = 85;
    public static final int TDRVERS = 1;
    public static final int TDRCLEN = 28;

    private TransactionDumpcodeStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int tdrlen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int tdrid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int tdrdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String tdrcode() {
        return Util.ConvertEbcdic(this.data, 8, 4);
    }

    public long tdrstkn() {
        return Util.ConvertUnsignedBinary4(this.data, 12);
    }

    public long tdrssupr() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long tdrttkn() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long tdrtsupr() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public static TransactionDumpcodeStatistics create(byte[] Data2, int offset, int length) {
        return new TransactionDumpcodeStatistics(Data2, offset, length);
    }

    static enum Field {
        tdrlen(0, 2),
        tdrid(2, 2),
        tdrdvers(4, 1),
        tdrcode(8, 4),
        tdrstkn(12, 4),
        tdrssupr(16, 4),
        tdrttkn(20, 4),
        tdrtsupr(24, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

