/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics;

import com.blackhillsoftware.smf.cics.statistics.StatisticsDataSection;
import com.blackhillsoftware.smf.cics.statistics.values.CIAgent;
import com.blackhillsoftware.smf.cics.statistics.values.XmcPurgeAction;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public final class TransactionManagerTclassStatistics
extends StatisticsDataSection {
    public static final int XMCIDE = 12;
    public static final int XMCVERS = 1;

    private TransactionManagerTclassStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    public int xmclen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    public int xmcid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    public int xmcdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    public String xmctcl() {
        return Util.ConvertEbcdic(this.data, 8, 8);
    }

    public long xmctat() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    public long xmcpi() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    public long xmctq() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    public long xmcai() {
        return Util.ConvertUnsignedBinary4(this.data, 28);
    }

    public long xmcaaq() {
        return Util.ConvertUnsignedBinary4(this.data, 32);
    }

    public long xmcpwq() {
        return Util.ConvertUnsignedBinary4(this.data, 36);
    }

    public long xmcmxt() {
        return Util.ConvertUnsignedBinary4(this.data, 40);
    }

    public long xmcth() {
        return Util.ConvertUnsignedBinary4(this.data, 44);
    }

    public long xmcitd() {
        return Util.ConvertUnsignedBinary4(this.data, 48);
    }

    public long xmcpat() {
        return Util.ConvertUnsignedBinary4(this.data, 52);
    }

    public long xmcpqt() {
        return Util.ConvertUnsignedBinary4(this.data, 56);
    }

    public long xmctama() {
        return Util.ConvertUnsignedBinary4(this.data, 60);
    }

    public long xmctapt() {
        return Util.ConvertUnsignedBinary4(this.data, 64);
    }

    public long xmccat() {
        return Util.ConvertUnsignedBinary4(this.data, 68);
    }

    public long xmccqt() {
        return Util.ConvertUnsignedBinary4(this.data, 72);
    }

    public Duration xmctqtme() {
        return Util.Binary8StckInterval(this.data, 76);
    }

    public double xmctqtmeSeconds() {
        return Util.ToSeconds(this.xmctqtme());
    }

    public long xmctqtmeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 76);
    }

    public Duration xmccqtme() {
        return Util.Binary8StckInterval(this.data, 84);
    }

    public double xmccqtmeSeconds() {
        return Util.ToSeconds(this.xmccqtme());
    }

    public long xmccqtmeRawValue() {
        return Util.ConvertSignedBinary8(this.data, 84);
    }

    public ZonedDateTime xmcgama() {
        return Util.Binary8xStckTime(this.data, 92);
    }

    public BigInteger xmcgamaRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 92);
    }

    public XmcPurgeAction xmcpua() {
        int value = Util.ConvertUnsignedBinary1(this.data, 100);
        return XmcPurgeAction.from(value);
    }

    public int xmcpuaRawValue() {
        return Util.ConvertUnsignedBinary1(this.data, 100);
    }

    public String xmcTclassDefineSource() {
        return Util.ConvertEbcdic(this.data, 108, 8);
    }

    public LocalDateTime xmcTclassChangeTime() {
        return Util.Binary8xStckLocalTime(this.data, 116);
    }

    public BigInteger xmcTclassChangeTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 116);
    }

    public String xmcTclassChangeUserid() {
        return Util.ConvertEbcdic(this.data, 124, 8);
    }

    public CIAgent xmcTclassChangeAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 132);
        return CIAgent.from(value);
    }

    public int xmcTclassChangeAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 132);
    }

    public CIAgent xmcTclassInstallAgent() {
        int value = Util.ConvertUnsignedBinary2(this.data, 134);
        return CIAgent.from(value);
    }

    public int xmcTclassInstallAgentRawValue() {
        return Util.ConvertUnsignedBinary2(this.data, 134);
    }

    public LocalDateTime xmcTclassInstallTime() {
        return Util.Binary8xStckLocalTime(this.data, 136);
    }

    public BigInteger xmcTclassInstallTimeRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 136);
    }

    public String xmcTclassInstallUserid() {
        return Util.ConvertEbcdic(this.data, 144, 8);
    }

    public static TransactionManagerTclassStatistics create(byte[] Data2, int offset, int length) {
        return new TransactionManagerTclassStatistics(Data2, offset, length);
    }

    static enum Field {
        xmclen(0, 2),
        xmcid(2, 2),
        xmcdvers(4, 1),
        xmctcl(8, 8),
        xmctat(16, 4),
        xmcpi(20, 4),
        xmctq(24, 4),
        xmcai(28, 4),
        xmcaaq(32, 4),
        xmcpwq(36, 4),
        xmcmxt(40, 4),
        xmcth(44, 4),
        xmcitd(48, 4),
        xmcpat(52, 4),
        xmcpqt(56, 4),
        xmctama(60, 4),
        xmctapt(64, 4),
        xmccat(68, 4),
        xmccqt(72, 4),
        xmctqtme(76, 8),
        xmccqtme(84, 8),
        xmcgama(92, 8),
        xmcpua(100, 1),
        xmcTclassDefineSource(108, 8),
        xmcTclassChangeTime(116, 8),
        xmcTclassChangeUserid(124, 8),
        xmcTclassChangeAgent(132, 2),
        xmcTclassInstallAgent(134, 2),
        xmcTclassInstallTime(136, 8),
        xmcTclassInstallUserid(144, 8);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

