/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.cics510;

import com.blackhillsoftware.smf.NotAvailableException;
import com.blackhillsoftware.smf.cics.statistics.DispatcherTcbPoolStatistics;
import com.blackhillsoftware.smf.cics.statistics.cics510.DispatcherTcbModeStatistics;
import com.blackhillsoftware.smf.internal.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DispatcherGlobalStatistics
extends com.blackhillsoftware.smf.cics.statistics.DispatcherGlobalStatistics {
    public static final int DSGIDE = 62;
    public static final int DSGVERS = 1;
    public static final int DSGMCLEN = 128;
    public static final int DSGMAXNUMMODES = 18;
    public static final int DSGMAXNUMPOOLS = 4;

    private DispatcherGlobalStatistics(byte[] Data2, int offset, int length) {
        super(Data2, offset, length);
    }

    @Override
    public int dsglen() {
        return Util.ConvertUnsignedBinary2(this.data, 0);
    }

    @Override
    public int dsgid() {
        return Util.ConvertUnsignedBinary2(this.data, 2);
    }

    @Override
    public int dsgdvers() {
        return Util.ConvertUnsignedBinary1(this.data, 4);
    }

    @Override
    public int dsgglen() {
        return Util.ConvertUnsignedBinary2(this.data, 8);
    }

    @Override
    public int dsgasize() {
        return Util.ConvertUnsignedBinary2(this.data, 10);
    }

    @Override
    public int dsgpsize() {
        return Util.ConvertUnsignedBinary2(this.data, 12);
    }

    @Override
    public Duration dsgicvt() {
        return Util.Binary4MS(this.data, 16);
    }

    @Override
    public double dsgicvtSeconds() {
        return Util.ToSeconds(this.dsgicvt());
    }

    @Override
    public long dsgicvtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 16);
    }

    @Override
    public Duration dsgicvrt() {
        return Util.Binary4MS(this.data, 20);
    }

    @Override
    public double dsgicvrtSeconds() {
        return Util.ToSeconds(this.dsgicvrt());
    }

    @Override
    public long dsgicvrtRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 20);
    }

    @Override
    public Duration dsgicvsd() {
        return Util.Binary4MS(this.data, 24);
    }

    @Override
    public double dsgicvsdSeconds() {
        return Util.ToSeconds(this.dsgicvsd());
    }

    @Override
    public long dsgicvsdRawValue() {
        return Util.ConvertUnsignedBinary4(this.data, 24);
    }

    @Override
    public int dsgpriag() {
        return Util.ConvertUnsignedBinary2(this.data, 26);
    }

    @Override
    public int dsgstsks() {
        return Util.ConvertUnsignedBinary2(this.data, 28);
    }

    @Override
    public int dsgmbtch() {
        return Util.ConvertUnsignedBinary2(this.data, 30);
    }

    @Override
    public int dsgcnt() {
        return Util.ConvertUnsignedBinary2(this.data, 36);
    }

    @Override
    public int dsgpnt() {
        return Util.ConvertUnsignedBinary2(this.data, 38);
    }

    @Override
    public ZonedDateTime dsgstart() {
        return Util.Binary8xStckTime(this.data, 56);
    }

    @Override
    public BigInteger dsgstartRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 56);
    }

    @Override
    public LocalDateTime dsglstrt() {
        return Util.Binary8xStckLocalTime(this.data, 64);
    }

    @Override
    public BigInteger dsglstrtRawValue() {
        return Util.ConvertUnsignedBinary8BigInteger(this.data, 64);
    }

    @Override
    public Duration dsgejst() {
        return Util.Binary8StckInterval(this.data, 72);
    }

    @Override
    public double dsgejstSeconds() {
        return Util.ToSeconds(this.dsgejst());
    }

    @Override
    public long dsgejstRawValue() {
        return Util.ConvertSignedBinary8(this.data, 72);
    }

    @Override
    public Duration dsgsrbt() {
        return Util.Binary8StckInterval(this.data, 80);
    }

    @Override
    public double dsgsrbtSeconds() {
        return Util.ToSeconds(this.dsgsrbt());
    }

    @Override
    public long dsgsrbtRawValue() {
        return Util.ConvertSignedBinary8(this.data, 80);
    }

    @Override
    public long dsgxscns() {
        return Util.ConvertUnsignedBinary4(this.data, 104);
    }

    @Override
    public long dsgxscnn() {
        return Util.ConvertUnsignedBinary4(this.data, 108);
    }

    @Override
    public long dsgxtcbd() {
        return Util.ConvertUnsignedBinary4(this.data, 112);
    }

    @Override
    public List<com.blackhillsoftware.smf.cics.statistics.DispatcherTcbModeStatistics> tcbModeStatistics() {
        int datastart = this.dsgglen();
        int count = this.dsgasize();
        ArrayList<DispatcherTcbModeStatistics> result = new ArrayList<DispatcherTcbModeStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(DispatcherTcbModeStatistics.create(this.data, datastart + i * 136, 136));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<DispatcherTcbPoolStatistics> tcbPoolStatistics() {
        int datastart = this.dsgglen() + this.dsgasize() * 136;
        int count = this.dsgpsize();
        ArrayList<com.blackhillsoftware.smf.cics.statistics.cics510.DispatcherTcbPoolStatistics> result = new ArrayList<com.blackhillsoftware.smf.cics.statistics.cics510.DispatcherTcbPoolStatistics>(count);
        for (int i = 0; i < count; ++i) {
            result.add(com.blackhillsoftware.smf.cics.statistics.cics510.DispatcherTcbPoolStatistics.create(this.data, datastart + i * 144, 144));
        }
        return Collections.unmodifiableList(result);
    }

    public static DispatcherGlobalStatistics create(byte[] Data2, int offset, int length) {
        return new DispatcherGlobalStatistics(Data2, offset, length);
    }

    @Override
    public ZonedDateTime dsggxscn() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public BigInteger dsggxscnRawValue() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public LocalDateTime dsglxscn() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public BigInteger dsglxscnRawValue() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public ZonedDateTime dsggxsnd() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public BigInteger dsggxsndRawValue() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public LocalDateTime dsglxsnd() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    @Override
    public BigInteger dsglxsndRawValue() {
        throw new NotAvailableException("Not available in CICS 5.1");
    }

    static enum Field {
        dsglen(0, 2),
        dsgid(2, 2),
        dsgdvers(4, 1),
        dsgglen(8, 2),
        dsgasize(10, 2),
        dsgpsize(12, 2),
        dsgicvt(16, 4),
        dsgicvrt(20, 4),
        dsgicvsd(24, 4),
        dsgpriag(26, 2),
        dsgstsks(28, 2),
        dsgmbtch(30, 2),
        dsgcnt(36, 2),
        dsgpnt(38, 2),
        dsgstart(56, 8),
        dsglstrt(64, 8),
        dsgejst(72, 8),
        dsgsrbt(80, 8),
        dsgxscns(104, 4),
        dsgxscnn(108, 4),
        dsgxtcbd(112, 4);

        private final int offset;
        private final int length;

        private Field(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private Field() {
            this.offset = 0;
            this.length = 0;
        }

        int offset() {
            return this.offset;
        }

        int length() {
            return this.length;
        }
    }
}

