/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum Location {
    BELOW(1),
    ABOVE(2),
    ABOVEBAR(3),
    NOT_DEFINED(-16);

    private static Map<Integer, Location> valueMap;
    private final int smslocation;

    private Location(int smslocation) {
        this.smslocation = smslocation;
    }

    public static Location from(int value) {
        Location result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int smslocation() {
        return this.smslocation;
    }

    static {
        valueMap = new HashMap<Integer, Location>();
        for (Location x : Location.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.smslocation, x);
        }
    }
}

