/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum SmdAccess {
    CICS(1),
    USER(2),
    READONLY(3),
    TRUSTED(4),
    NOT_DEFINED(-16);

    private static Map<Integer, SmdAccess> valueMap;
    private final int smdaccess;

    private SmdAccess(int smdaccess) {
        this.smdaccess = smdaccess;
    }

    public static SmdAccess from(int value) {
        SmdAccess result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int smdaccess() {
        return this.smdaccess;
    }

    static {
        valueMap = new HashMap<Integer, SmdAccess>();
        for (SmdAccess x : SmdAccess.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.smdaccess, x);
        }
    }
}

