/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum TqrIOtype {
    NA(0),
    INPUT(1),
    OUTPUT(2),
    READBACK(3),
    NOT_DEFINED(-16);

    private static Map<Integer, TqrIOtype> valueMap;
    private final int tqriotype;

    private TqrIOtype(int tqriotype) {
        this.tqriotype = tqriotype;
    }

    public static TqrIOtype from(int value) {
        TqrIOtype result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tqriotype() {
        return this.tqriotype;
    }

    static {
        valueMap = new HashMap<Integer, TqrIOtype>();
        for (TqrIOtype x : TqrIOtype.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tqriotype, x);
        }
    }
}

