/*
 * Decompiled with CFR 0.152.
 */
package com.blackhillsoftware.smf.cics.statistics.values;

import java.util.HashMap;
import java.util.Map;

public enum TqrRtype {
    NA(0),
    PHYSICAL(1),
    LOGICAL(2),
    NONRECOVERABLE(3),
    NOT_DEFINED(-16);

    private static Map<Integer, TqrRtype> valueMap;
    private final int tqrrtype;

    private TqrRtype(int tqrrtype) {
        this.tqrrtype = tqrrtype;
    }

    public static TqrRtype from(int value) {
        TqrRtype result = valueMap.get(value);
        if (result == null) {
            return NOT_DEFINED;
        }
        return result;
    }

    int tqrrtype() {
        return this.tqrrtype;
    }

    static {
        valueMap = new HashMap<Integer, TqrRtype>();
        for (TqrRtype x : TqrRtype.values()) {
            if (x == NOT_DEFINED) continue;
            valueMap.put(x.tqrrtype, x);
        }
    }
}

